/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.world;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.common.util.NonNullFunction;

public abstract class AbstractWorldGenRegisteredFeature<T extends AbstractWorldGenRegisteredFeature<T, FC, F>, FC extends FeatureConfiguration, F extends Feature<FC>>
implements Supplier<Holder<PlacedFeature>> {
    private final String name;
    private final NonNullFunction<String, ResourceLocation> _idFactory;
    private final Supplier<F> _featureSupplier;
    private final Supplier<FC> _configurationSupplier;
    private List<PlacementModifier> _placementModifiers;
    private Holder<PlacedFeature> _placed;

    protected AbstractWorldGenRegisteredFeature(String name, NonNullFunction<String, ResourceLocation> idFactory, Supplier<F> featureSupplier, Supplier<FC> configurationSupplier) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        this.name = name;
        this._idFactory = Objects.requireNonNull(idFactory);
        this._featureSupplier = Objects.requireNonNull(featureSupplier);
        this._configurationSupplier = Objects.requireNonNull(configurationSupplier);
        this._placementModifiers = ObjectLists.emptyList();
        this._placed = null;
    }

    public void register() {
        Holder configuredFeatureHolder = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)((ResourceLocation)this._idFactory.apply((Object)(this.name + "_conf"))), (Object)new ConfiguredFeature((Feature)this._featureSupplier.get(), (FeatureConfiguration)this._configurationSupplier.get()));
        this._placed = BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_194653_, (ResourceLocation)((ResourceLocation)this._idFactory.apply((Object)(this.name + "_placed"))), (Object)new PlacedFeature(Holder.m_205706_((Holder)configuredFeatureHolder), this._placementModifiers));
    }

    public T placement(PlacementModifier ... modifiers) {
        this._placementModifiers = ObjectLists.unmodifiable((ObjectList)new ObjectArrayList((Object[])modifiers));
        return this.self();
    }

    @Override
    public Holder<PlacedFeature> get() {
        return this._placed;
    }

    private T self() {
        return (T)this;
    }
}

