/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.recipe.AbstractManyToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ManyToOneRecipeSerializer<IngredientT, Result, RecipeIngredient extends IRecipeIngredient<IngredientT>, RecipeResult extends IRecipeResult<Result>, Recipe extends AbstractManyToOneRecipe<IngredientT, Result, RecipeIngredient, RecipeResult>>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<Recipe> {
    private final AbstractManyToOneRecipe.IRecipeFactory<IngredientT, Result, RecipeIngredient, RecipeResult, Recipe> _recipeFactory;
    private final Function<JsonElement, RecipeIngredient> _jsonIngredientFactory;
    private final Function<FriendlyByteBuf, RecipeIngredient> _packetIngredientFactory;
    private final Function<JsonElement, RecipeResult> _jsonResultFactory;
    private final Function<FriendlyByteBuf, RecipeResult> _packetResultFactory;
    private final IntFunction<String> _jsonIngredientsLabelsSupplier;

    public ManyToOneRecipeSerializer(AbstractManyToOneRecipe.IRecipeFactory<IngredientT, Result, RecipeIngredient, RecipeResult, Recipe> recipeFactory, Function<JsonElement, RecipeIngredient> jsonIngredient1Factory, Function<FriendlyByteBuf, RecipeIngredient> packetIngredient1Factory, Function<JsonElement, RecipeResult> jsonResultFactory, Function<FriendlyByteBuf, RecipeResult> packetResultFactory, IntFunction<String> jsonIngredientsLabelsSupplier) {
        this._recipeFactory = recipeFactory;
        this._jsonIngredientFactory = jsonIngredient1Factory;
        this._packetIngredientFactory = packetIngredient1Factory;
        this._jsonResultFactory = jsonResultFactory;
        this._packetResultFactory = packetResultFactory;
        this._jsonIngredientsLabelsSupplier = jsonIngredientsLabelsSupplier;
    }

    public Recipe fromJson(ResourceLocation recipeId, JsonObject json) {
        String elementName;
        ObjectArrayList ingredients = new ObjectArrayList(5);
        int idx = 0;
        while (json.has(elementName = this._jsonIngredientsLabelsSupplier.apply(idx))) {
            ingredients.add((IRecipeIngredient)this._jsonIngredientFactory.apply(json.get(elementName)));
            ++idx;
        }
        IRecipeResult result = (IRecipeResult)this._jsonResultFactory.apply(JSONHelper.jsonGetMandatoryElement(json, "result"));
        return this.create(recipeId, (List<RecipeIngredient>)ingredients, (RecipeResult)result);
    }

    @Nullable
    public Recipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        ObjectArrayList ingredients = new ObjectArrayList(count);
        for (int i = 0; i < count; ++i) {
            ingredients.add((IRecipeIngredient)this._packetIngredientFactory.apply(buffer));
        }
        IRecipeResult result = (IRecipeResult)this._packetResultFactory.apply(buffer);
        return this.create(recipeId, (List<RecipeIngredient>)ingredients, (RecipeResult)result);
    }

    public void toNetwork(FriendlyByteBuf buffer, Recipe recipe) {
        ((AbstractManyToOneRecipe)recipe).serializeTo(buffer);
    }

    private Recipe create(ResourceLocation id, List<RecipeIngredient> ingredients, RecipeResult result) {
        if (result.isEmpty()) {
            throw new IllegalArgumentException("A many-to-one recipe result cannot be empty");
        }
        return this._recipeFactory.create(id, ingredients, result);
    }
}

