/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.energy;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import it.zerono.mods.zerocore.lib.data.nbt.NBTHelper;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IEnergySystemAware;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class WideEnergyStack
implements IEnergySystemAware {
    public static final WideEnergyStack EMPTY = new WideEnergyStack();
    private final EnergySystem _system;
    private WideAmount _amount;

    public WideEnergyStack(EnergySystem system) {
        this(system, WideAmount.ZERO);
    }

    public WideEnergyStack(EnergySystem system, WideAmount amount) {
        this._system = system;
        this._amount = amount.copy();
    }

    public WideEnergyStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new WideEnergyStack(this._system, this._amount);
    }

    public boolean isEmpty() {
        return EMPTY == this || this._amount.isZero();
    }

    public boolean isEnergySystemEqual(WideEnergyStack other) {
        return this.getEnergySystem() == other.getEnergySystem();
    }

    public static boolean areStacksEqual(WideEnergyStack stackA, WideEnergyStack stackB) {
        if (stackA.isEmpty() && stackB.isEmpty()) {
            return true;
        }
        return !stackA.isEmpty() && !stackB.isEmpty() && stackA.isStackEqual(stackB);
    }

    public WideAmount getMaxStackSize() {
        return WideAmount.MAX_VALUE;
    }

    public WideAmount getAmount() {
        return this._amount.copy();
    }

    public void setAmount(WideAmount amount) {
        this._amount = this._amount.set(amount);
    }

    public void grow(WideAmount increment) {
        this._amount = this._amount.add(increment);
    }

    public void shrink(WideAmount decrement) {
        this._amount = this._amount.subtract(decrement);
    }

    public CompoundTag serializeTo(CompoundTag nbt) {
        NBTHelper.nbtSetEnum(nbt, "sys", this._system);
        nbt.m_128365_("amount", (Tag)this._amount.serializeTo(new CompoundTag()));
        return nbt;
    }

    public static WideEnergyStack from(CompoundTag nbt) {
        if (NBTHelper.nbtContainsEnum(nbt, "sys") && nbt.m_128425_("amount", 10)) {
            return new WideEnergyStack(NBTHelper.nbtGetEnum(nbt, "sys", EnergySystem.class), WideAmount.from(nbt.m_128469_("amount")));
        }
        Log.LOGGER.info(Log.CORE, "Tried to read an WideEnergyStack from invalid NBT data");
        return EMPTY;
    }

    public void serializeTo(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this._system);
        this._amount.serializeTo(buffer);
    }

    public static WideEnergyStack from(FriendlyByteBuf buffer) {
        try {
            return new WideEnergyStack((EnergySystem)buffer.m_130066_(EnergySystem.class), WideAmount.from(buffer));
        }
        catch (RuntimeException ex) {
            Log.LOGGER.info(Log.CORE, "Tried to read an WideEnergyStack from invalid packet data");
            return EMPTY;
        }
    }

    public JsonElement serializeTo() {
        JsonObject json = new JsonObject();
        JSONHelper.jsonSetEnum(json, "sys", this._system);
        json.add("amount", (JsonElement)this._amount.serializeTo(json));
        return json;
    }

    public static WideEnergyStack from(JsonElement element) {
        try {
            JsonObject json = element.getAsJsonObject();
            return new WideEnergyStack(JSONHelper.jsonGetEnum(json, "sys", EnergySystem.class), WideAmount.from(json.getAsJsonObject("amount")));
        }
        catch (RuntimeException ex) {
            Log.LOGGER.info(Log.CORE, "Tried to read an WideEnergyStack from invalid JSON data");
            return EMPTY;
        }
    }

    @Override
    public EnergySystem getEnergySystem() {
        return this._system;
    }

    public String toString() {
        return this._amount + " " + this._system;
    }

    private WideEnergyStack() {
        this._system = EnergySystem.REFERENCE;
        this._amount = WideAmount.ZERO;
    }

    private boolean isStackEqual(WideEnergyStack other) {
        return this._system == other._system && this._amount.equals(other._amount);
    }
}

