/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;

public final class DataGenHelper {
    private static final ResourceLocation ITEM_PARENT_GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation ITEM_PARENT_HANDHELD = new ResourceLocation("item/handheld");

    public static ItemModelBuilder simpleItem(ItemModelProvider provider, String name, ResourceLocation parent, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, parent)).texture("layer0", texture);
    }

    public static ItemModelBuilder simpleItem(ItemModelProvider provider, Item item, ResourceLocation parent, ResourceLocation texture) {
        return DataGenHelper.simpleItem(provider, DataGenHelper.itemName(item), parent, texture);
    }

    public static ItemModelBuilder generatedItem(ItemModelProvider provider, String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ITEM_PARENT_GENERATED)).texture("layer0", texture);
    }

    public static ItemModelBuilder generatedItem(ItemModelProvider provider, Item item, ResourceLocation texture) {
        return DataGenHelper.generatedItem(provider, DataGenHelper.itemName(item), texture);
    }

    public static ItemModelBuilder generatedItem(ItemModelProvider provider, Item item) {
        return DataGenHelper.generatedItem(provider, DataGenHelper.itemName(item), DataGenHelper.defaultItemTexture(provider, item));
    }

    public static ItemModelBuilder handHeldItem(ItemModelProvider provider, String name, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)provider.withExistingParent(name, ITEM_PARENT_HANDHELD)).texture("layer0", texture);
    }

    public static ItemModelBuilder handHeldItem(ItemModelProvider provider, Item item, ResourceLocation texture) {
        return DataGenHelper.handHeldItem(provider, DataGenHelper.itemName(item), texture);
    }

    public static ItemModelBuilder handHeldItem(ItemModelProvider provider, Item item) {
        return DataGenHelper.handHeldItem(provider, DataGenHelper.itemName(item), DataGenHelper.defaultItemTexture(provider, item));
    }

    private static String itemName(Item item) {
        return item.getRegistryName().m_135815_();
    }

    private static ResourceLocation defaultItemTexture(ItemModelProvider provider, Item item) {
        return provider.modLoc("item/" + DataGenHelper.itemName(item));
    }

    private DataGenHelper() {
    }
}

