/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.resourcepack.recipe.IRecipeTemplate;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ShapelessRecipeTemplate
implements IRecipeTemplate<ShapelessRecipeBuilder.Result> {
    public final Item result;
    public final int count;
    public final String group;
    public final List<Ingredient> ingredients;

    public ShapelessRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        ResourceLocation item = new ResourceLocation(result.get("item").getAsString());
        int count = 1;
        JsonElement c = result.get("count");
        if (c != null) {
            count = c.getAsInt();
        }
        this.result = (Item)Registry.f_122827_.m_7745_(item);
        this.count = count;
        JsonElement g = json.get("group");
        this.group = g == null ? "" : g.getAsString();
        ArrayList<Ingredient> ingredientsList = new ArrayList<Ingredient>();
        JsonArray ingredients = json.getAsJsonArray("ingredients");
        ingredients.forEach(p -> ingredientsList.add(Ingredient.m_43917_((JsonElement)p)));
        this.ingredients = ingredientsList;
    }

    @Override
    public <T extends BlockType> ShapelessRecipeBuilder.Result createSimilar(T originalMat, T destinationMat, Item unlockItem, String id) {
        ItemLike newRes = BlockType.changeItemBlockType((ItemLike)this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s", this.result));
        }
        ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder(newRes, this.count);
        for (Ingredient ing : this.ingredients) {
            for (ItemStack in : ing.m_43908_()) {
                ItemLike i;
                Item it = in.m_41720_();
                if (it == Items.f_42127_ || (i = BlockType.changeItemBlockType((ItemLike)it, originalMat, destinationMat)) == null) continue;
                ing = Ingredient.m_43929_((ItemLike[])new ItemLike[]{i});
                break;
            }
            builder.m_126184_(ing);
        }
        builder.m_142409_(this.group);
        builder.m_142284_("has_planks", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{unlockItem}));
        AtomicReference newRecipe = new AtomicReference();
        if (id == null) {
            builder.m_176498_(r -> newRecipe.set((ShapelessRecipeBuilder.Result)r));
        } else {
            builder.m_176500_(r -> newRecipe.set((ShapelessRecipeBuilder.Result)r), id);
        }
        return (ShapelessRecipeBuilder.Result)newRecipe.get();
    }
}

