/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.openmbean.InvalidOpenTypeException;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.client.TextureCache;
import net.mehvahdjukaar.selene.resourcepack.BlockTypeResTransformer;
import net.mehvahdjukaar.selene.resourcepack.DynamicResourcePack;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.StaticResource;
import net.mehvahdjukaar.selene.resourcepack.recipe.IRecipeTemplate;
import net.mehvahdjukaar.selene.resourcepack.recipe.TemplateRecipeManager;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class RPUtils {
    public static String serializeJson(JsonElement json) throws IOException {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
        jsonWriter.setLenient(true);
        jsonWriter.setIndent("  ");
        Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        return stringWriter.toString();
    }

    public static JsonObject deserializeJson(InputStream stream) {
        return GsonHelper.m_13859_((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    public static ResourceLocation findFirstBlockTextureLocation(ResourceManager manager, Block block) throws FileNotFoundException {
        return RPUtils.findFirstBlockTextureLocation(manager, block, t -> true);
    }

    public static ResourceLocation findFirstBlockTextureLocation(ResourceManager manager, Block block, Predicate<String> texturePredicate) throws FileNotFoundException {
        String cached = TextureCache.getCached((ItemLike)block, texturePredicate);
        if (cached != null) {
            return new ResourceLocation(cached);
        }
        try {
            JsonObject modelElement;
            ResourceLocation res = block.getRegistryName();
            Resource blockState = manager.m_142591_(ResType.BLOCKSTATES.getPath(res));
            JsonObject bsElement = RPUtils.deserializeJson(blockState.m_6679_());
            String modelPath = (String)RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject(), s -> s.equals("model")).stream().findAny().get();
            try {
                Resource model = manager.m_142591_(ResType.MODELS.getPath(modelPath));
                modelElement = RPUtils.deserializeJson(model.m_6679_());
            }
            catch (Exception e) {
                throw new Exception("Failed to parse model at " + modelPath);
            }
            Set<String> textures = RPUtils.findAllResourcesInJsonRecursive((JsonElement)modelElement.getAsJsonObject().getAsJsonObject("textures"));
            for (String t : textures) {
                TextureCache.add((ItemLike)block, t);
                if (!texturePredicate.test(t)) continue;
                return new ResourceLocation(t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException("Could not find any texture associated to the given block " + block.getRegistryName());
    }

    public static ResourceLocation findFirstItemTextureLocation(ResourceManager manager, Item block) throws FileNotFoundException {
        return RPUtils.findFirstItemTextureLocation(manager, block, t -> true);
    }

    public static ResourceLocation findFirstItemTextureLocation(ResourceManager manager, Item item, Predicate<String> texturePredicate) throws FileNotFoundException {
        String cached = TextureCache.getCached((ItemLike)item, texturePredicate);
        if (cached != null) {
            return new ResourceLocation(cached);
        }
        try {
            ResourceLocation res = item.getRegistryName();
            Resource itemModel = manager.m_142591_(ResType.ITEM_MODELS.getPath(res));
            JsonObject bsElement = RPUtils.deserializeJson(itemModel.m_6679_());
            Set<String> textures = RPUtils.findAllResourcesInJsonRecursive((JsonElement)bsElement.getAsJsonObject().getAsJsonObject("textures"));
            for (String t : textures) {
                TextureCache.add((ItemLike)item, t);
                if (!texturePredicate.test(t)) continue;
                return new ResourceLocation(t);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new FileNotFoundException("Could not find any texture associated to the given item " + item.getRegistryName());
    }

    public static String findFirstResourceInJsonRecursive(JsonElement element) throws NoSuchElementException {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            return RPUtils.findFirstResourceInJsonRecursive(array.get(0));
        }
        if (element instanceof JsonObject) {
            Set entries = element.getAsJsonObject().entrySet();
            JsonElement child = (JsonElement)((Map.Entry)entries.stream().findAny().get()).getValue();
            return RPUtils.findFirstResourceInJsonRecursive(child);
        }
        return element.getAsString();
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element) {
        return RPUtils.findAllResourcesInJsonRecursive(element, s -> true);
    }

    public static Set<String> findAllResourcesInJsonRecursive(JsonElement element, Predicate<String> filter) {
        if (element instanceof JsonArray) {
            JsonArray array = (JsonArray)element;
            HashSet<String> list = new HashSet<String>();
            array.forEach(e -> list.addAll(RPUtils.findAllResourcesInJsonRecursive(e, filter)));
            return list;
        }
        if (element instanceof JsonObject) {
            JsonObject json = (JsonObject)element;
            Set entries = json.entrySet();
            HashSet<String> list = new HashSet<String>();
            for (Map.Entry c : entries) {
                if (((JsonElement)c.getValue()).isJsonPrimitive() && !filter.test((String)c.getKey())) continue;
                Set<String> l = RPUtils.findAllResourcesInJsonRecursive((JsonElement)c.getValue(), filter);
                list.addAll(l);
            }
            return list;
        }
        return Set.of(element.getAsString());
    }

    public static Recipe<?> readRecipe(ResourceManager manager, String location) {
        return RPUtils.readRecipe(manager, ResType.RECIPES.getPath(location));
    }

    public static Recipe<?> readRecipe(ResourceManager manager, ResourceLocation location) {
        try {
            JsonObject element = RPUtils.deserializeJson(manager.m_142591_(location).m_6679_());
            return RecipeManager.fromJson((ResourceLocation)location, (JsonObject)element, (ICondition.IContext)ICondition.IContext.EMPTY);
        }
        catch (Exception e) {
            throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
        }
    }

    public static IRecipeTemplate<?> readRecipeAsTemplate(ResourceManager manager, String location) {
        return RPUtils.readRecipeAsTemplate(manager, ResType.RECIPES.getPath(location));
    }

    public static IRecipeTemplate<?> readRecipeAsTemplate(ResourceManager manager, ResourceLocation location) {
        try {
            JsonObject element = RPUtils.deserializeJson(manager.m_142591_(location).m_6679_());
            return TemplateRecipeManager.read(element);
        }
        catch (Exception e) {
            throw new InvalidOpenTypeException(String.format("Failed to get recipe at %s: %s", location, e));
        }
    }

    public static <T extends BlockType> Recipe<?> makeSimilarRecipe(Recipe<?> original, T originalMat, T destinationMat, String baseID) {
        if (original instanceof ShapedRecipe) {
            ShapedRecipe or = (ShapedRecipe)original;
            ArrayList<Ingredient> newList = new ArrayList<Ingredient>();
            for (Ingredient ingredient : or.m_7527_()) {
                ItemLike i;
                if (ingredient == null || ingredient.m_43908_().length <= 0 || (i = BlockType.changeItemBlockType((ItemLike)ingredient.m_43908_()[0].m_41720_(), originalMat, destinationMat)) == null) continue;
                newList.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{i}));
            }
            Item originalRes = or.m_8043_().m_41720_();
            ItemLike newRes = BlockType.changeItemBlockType((ItemLike)originalRes, originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException("Failed to convert recipe");
            }
            ItemStack result = newRes.m_5456_().m_7968_();
            ResourceLocation newId = new ResourceLocation(baseID + "/" + destinationMat.getAppendableId());
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])newList.toArray(Ingredient[]::new)));
            return new ShapedRecipe(newId, or.m_6076_(), or.m_44220_(), or.m_44221_(), ingredients, result);
        }
        if (original instanceof ShapelessRecipe) {
            ShapelessRecipe or = (ShapelessRecipe)original;
            ArrayList<Ingredient> newList = new ArrayList<Ingredient>();
            for (Ingredient ingredient : or.m_7527_()) {
                ItemLike i;
                if (ingredient == null || ingredient.m_43908_().length <= 0 || (i = BlockType.changeItemBlockType((ItemLike)ingredient.m_43908_()[0].m_41720_(), originalMat, destinationMat)) == null) continue;
                newList.add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{i}));
            }
            Iterator originalRes = or.m_8043_().m_41720_();
            ItemLike newRes = BlockType.changeItemBlockType((ItemLike)originalRes, originalMat, destinationMat);
            if (newRes == null) {
                throw new UnsupportedOperationException("Failed to convert recipe");
            }
            ItemStack result = newRes.m_5456_().m_7968_();
            ResourceLocation newId = new ResourceLocation(baseID + "/" + destinationMat.getAppendableId());
            NonNullList ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])newList.toArray(Ingredient[]::new)));
            return new ShapelessRecipe(newId, or.m_6076_(), result, ingredients);
        }
        throw new UnsupportedOperationException(String.format("Original recipe %s must be Shaped or Shapeless", original));
    }

    public static <T extends BlockType> void addSimpleBlockResources(String modId, ResourceManager manager, DynamicResourcePack pack, Map<T, Block> blocks, String replaceTarget, ResourceLocation ... jsonsLocations) {
        RPUtils.addBlockResources(manager, pack, blocks, BlockTypeResTransformer.create(modId, manager).replaceSimpleBlock(modId, replaceTarget).IDReplaceBlock(replaceTarget), jsonsLocations);
    }

    public static <T extends BlockType> void addBlockResources(ResourceManager manager, DynamicResourcePack pack, Map<T, Block> blocks, BlockTypeResTransformer<T> modifier, ResourceLocation ... jsonsLocations) {
        List original = Arrays.stream(jsonsLocations).map(s -> StaticResource.getOrLog(manager, s)).collect(Collectors.toList());
        blocks.forEach((wood, value) -> {
            for (StaticResource res : original) {
                try {
                    StaticResource newRes = modifier.transform(res, value.getRegistryName(), wood);
                    assert (newRes.location != res.location) : "ids cant be the same";
                    pack.addResource(newRes);
                }
                catch (Exception e) {
                    Selene.LOGGER.error("Failed to generate json from {}", (Object)res.location);
                }
            }
        });
    }
}

