/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import java.io.FileNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.resourcepack.RPUtils;
import net.mehvahdjukaar.selene.resourcepack.StaticResource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriFunction;

public class BlockTypeResTransformer<T extends BlockType> {
    private final ResourceManager manager;
    private final String modId;
    private final List<TextModification<T>> textModifiers = new ArrayList<TextModification<T>>();
    private TextModification<T> idModifiers = (s, id, w) -> s;

    private BlockTypeResTransformer(String modId, ResourceManager manager) {
        this.manager = manager;
        this.modId = modId;
    }

    public static <T extends BlockType> BlockTypeResTransformer<T> create(String modId, ResourceManager manager) {
        return new BlockTypeResTransformer<T>(modId, manager);
    }

    public static BlockTypeResTransformer<WoodType> wood(String modId, ResourceManager manager) {
        return new BlockTypeResTransformer<WoodType>(modId, manager);
    }

    public static BlockTypeResTransformer<LeavesType> leaves(String modId, ResourceManager manager) {
        return new BlockTypeResTransformer<LeavesType>(modId, manager);
    }

    public BlockTypeResTransformer<T> setIDModifier(TextModification<T> modifier) {
        this.idModifiers = modifier;
        return this;
    }

    public BlockTypeResTransformer<T> IDReplaceType(String oldTypeName) {
        return this.setIDModifier((s, id, w) -> BlockTypeResTransformer.replaceType(s, id, w, oldTypeName));
    }

    public BlockTypeResTransformer<T> IDReplaceBlock(String blockName) {
        return this.setIDModifier((s, id, w) -> s.replace(blockName, id.m_135815_()));
    }

    public BlockTypeResTransformer<T> addModifier(TextModification<T> modifier) {
        this.textModifiers.add(modifier);
        return this;
    }

    public BlockTypeResTransformer<T> addModifier(BiFunction<String, T, String> genericModifier) {
        return this.addModifier((String s, ResourceLocation id, T w) -> (String)genericModifier.apply(s, w));
    }

    public BlockTypeResTransformer<T> replaceBlockType(String oldTypeName) {
        this.addModifier((String s, ResourceLocation id, T w) -> BlockTypeResTransformer.replaceFullBlockType(s, id, w, oldTypeName, this.modId));
        return this;
    }

    public BlockTypeResTransformer<T> replaceSimpleBlock(Block block) {
        ResourceLocation res = block.getRegistryName();
        return this.replaceSimpleBlock(res.m_135827_(), res.m_135815_());
    }

    public BlockTypeResTransformer<T> replaceSimpleBlock(String blockNamespace, String blockName) {
        return this.replaceSimpleBlock(blockNamespace, blockName, ":block/", ":block/");
    }

    public BlockTypeResTransformer<T> replaceSimpleBlock(String blockNamespace, String blockName, String inBetween, String inBetween2) {
        return this.addModifier((String s, ResourceLocation id, T w) -> s.replace(blockNamespace + inBetween + blockName, id.m_135827_() + inBetween2 + id.m_135815_()));
    }

    public BlockTypeResTransformer<T> replaceString(String from, String to) {
        return this.addModifier((String s, ResourceLocation id, T w) -> s.replace(from, to));
    }

    public BlockTypeResTransformer<T> replaceOakLeaves() {
        return this.replaceWithTextureFromChild("minecraft:block/oak_leaves", "leaves", (String s) -> !s.contains("_snow"));
    }

    public BlockTypeResTransformer<T> replaceOakPlanks() {
        return this.replaceWithTextureFromChild("minecraft:block/oak_planks", "planks");
    }

    public BlockTypeResTransformer<T> replaceOakBark() {
        return this.replaceWithTextureFromChild("minecraft:block/oak_log", "log", (String s) -> !s.contains("_end") && !s.contains("_top")).replaceWithTextureFromChild("minecraft:block/oak_log_top", "log", (String s) -> s.contains("_top") || s.contains("_end"));
    }

    public BlockTypeResTransformer<T> replaceOakStripped() {
        return this.replaceWithTextureFromChild("minecraft:block/stripped_oak_log", "stripped_log", (String s) -> !s.contains("_end") && !s.contains("_top")).replaceWithTextureFromChild("minecraft:block/stripped_oak_log_top", "stripped_log", (String s) -> s.contains("_top") || s.contains("_end"));
    }

    public BlockTypeResTransformer<T> replaceWoodTextures(WoodType woodType) {
        String n = woodType.getTypeName();
        return this.replaceWithTextureFromChild("minecraft:block/" + n + "_planks", "planks").replaceWithTextureFromChild("minecraft:block/stripped_" + n + "_log", "stripped_log", (String s) -> !s.contains("_end") && !s.contains("_top")).replaceWithTextureFromChild("minecraft:block/stripped_" + n + "_log_top", "stripped_log", (String s) -> s.contains("_top") || s.contains("_end")).replaceWithTextureFromChild("minecraft:block/" + n + "_log", "log", (String s) -> !s.contains("_end") && !s.contains("_top")).replaceWithTextureFromChild("minecraft:block/" + n + "_log_top", "log", (String s) -> s.contains("_top") || s.contains("_end"));
    }

    public BlockTypeResTransformer<T> replaceWithTextureFromChild(String target, String textureFromChild) {
        return this.replaceWithTextureFromChild(target, textureFromChild, (String s) -> true);
    }

    public BlockTypeResTransformer<T> replaceWithTextureFromChild(String target, String textureFromChild, Predicate<String> texturePredicate) {
        return this.replaceWithTextureFromChild(target, (T w) -> w.getChild(textureFromChild), texturePredicate);
    }

    public BlockTypeResTransformer<T> replaceWithTextureFromChild(String target, Function<T, ItemLike> childProvider, Predicate<String> texturePredicate) {
        return this.addModifier((String s, ResourceLocation id, T w) -> {
            String r = s;
            try {
                ItemLike woodObject = (ItemLike)childProvider.apply(w);
                ResourceLocation newTexture = null;
                if (woodObject instanceof Block) {
                    Block b = (Block)woodObject;
                    newTexture = RPUtils.findFirstBlockTextureLocation(this.manager, b, texturePredicate);
                } else if (woodObject instanceof Item) {
                    Item i = (Item)woodObject;
                    newTexture = RPUtils.findFirstItemTextureLocation(this.manager, i);
                }
                if (newTexture != null) {
                    r = s.replace("\"block\\/", "minecraft:block\\/" + newTexture);
                    r = r.replace(target + "\"", newTexture + "\"");
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            return r;
        });
    }

    public StaticResource transform(StaticResource resource, ResourceLocation blockId, T type) {
        String newText = new String(resource.data, StandardCharsets.UTF_8);
        for (TextModification<T> m : this.textModifiers) {
            newText = m.apply(newText, blockId, type);
        }
        ResourceLocation oldPath = resource.location;
        String id = this.idModifiers.apply(oldPath.m_135815_(), blockId, type);
        ResourceLocation newLocation = new ResourceLocation(blockId.m_135827_(), id);
        return StaticResource.create(newText.getBytes(), newLocation);
    }

    public static String replaceType(String original, ResourceLocation blockId, BlockType blockType, String oldTypeName) {
        Object prefix = "";
        Pattern pattern = Pattern.compile("(.*(?=\\/))");
        Matcher matcher = pattern.matcher(blockId.m_135815_());
        if (matcher.find()) {
            prefix = "/" + matcher.group(1);
        }
        Pattern p2 = original.contains("block/") ? Pattern.compile("((?<=block)[\\w\\/]*?)" + oldTypeName) : Pattern.compile("(\\/\\w*?)" + oldTypeName);
        Matcher m2 = p2.matcher(original);
        Object finalPrefix = prefix;
        String newS = m2.replaceAll(arg_0 -> BlockTypeResTransformer.lambda$replaceType$19((String)finalPrefix, blockType, arg_0));
        return newS;
    }

    public static String replaceFullBlockType(String original, ResourceLocation blockId, BlockType blockType, String oldTypeName, String oldId) {
        Object prefix = "";
        Pattern pattern = Pattern.compile("(.*(?=\\/))");
        Matcher matcher = pattern.matcher(blockId.m_135815_());
        if (matcher.find()) {
            prefix = "/" + matcher.group(1);
        }
        Pattern p2 = Pattern.compile(oldId + ":block(.*\\/.*)" + oldTypeName);
        Matcher m2 = p2.matcher(original);
        Object finalPrefix = prefix;
        return m2.replaceAll(arg_0 -> BlockTypeResTransformer.lambda$replaceFullBlockType$20(blockId, (String)finalPrefix, blockType, arg_0));
    }

    private static /* synthetic */ String lambda$replaceFullBlockType$20(ResourceLocation blockId, String finalPrefix, BlockType blockType, MatchResult m) {
        return blockId.m_135827_() + ":block" + finalPrefix + m.group(1) + blockType.getTypeName();
    }

    private static /* synthetic */ String lambda$replaceType$19(String finalPrefix, BlockType blockType, MatchResult m) {
        return finalPrefix + m.group(1) + blockType.getTypeName();
    }

    @FunctionalInterface
    public static interface TextModification<T extends BlockType>
    extends TriFunction<String, ResourceLocation, T, String> {
        public String apply(String var1, ResourceLocation var2, T var3);
    }
}

