/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.client.asset_generators.textures;

import java.util.Objects;
import net.mehvahdjukaar.selene.math.colors.BaseColor;
import net.mehvahdjukaar.selene.math.colors.HCLColor;
import net.mehvahdjukaar.selene.math.colors.LABColor;
import net.mehvahdjukaar.selene.math.colors.RGBColor;
import org.jetbrains.annotations.NotNull;

public class PaletteColor
implements Comparable<PaletteColor> {
    private final int value;
    private final RGBColor color;
    private final LABColor lab;
    private final HCLColor hcl;
    public int occurrence = 0;

    public PaletteColor(int color) {
        this(new RGBColor(color));
    }

    public PaletteColor(BaseColor<?> color) {
        RGBColor c = color.asRGB();
        this.color = c.alpha() == 0.0f ? new RGBColor(0) : c;
        this.lab = this.color.asLAB();
        this.value = this.color.toInt();
        this.hcl = this.lab.asHCL();
    }

    public int value() {
        return this.value;
    }

    public RGBColor rgb() {
        return this.color;
    }

    public LABColor lab() {
        return this.lab;
    }

    public HCLColor hcl() {
        return this.hcl;
    }

    public float luminance() {
        return this.lab.luminance();
    }

    public float distanceTo(PaletteColor color) {
        return this.lab.distTo(color.lab);
    }

    @Override
    public int compareTo(@NotNull PaletteColor o) {
        return Float.compare(this.lab.luminance(), o.lab.luminance());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaletteColor that = (PaletteColor)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.color, this.lab, this.hcl, this.occurrence);
    }

    public String toString() {
        return "PaletteColor:" + this.value;
    }
}

