/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.client.asset_generators.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.mehvahdjukaar.selene.client.asset_generators.textures.PaletteColor;
import net.mehvahdjukaar.selene.client.asset_generators.textures.TextureImage;
import net.mehvahdjukaar.selene.math.MthUtils;
import net.mehvahdjukaar.selene.math.colors.BaseColor;
import net.mehvahdjukaar.selene.math.colors.HCLColor;
import net.mehvahdjukaar.selene.math.colors.LABColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class Palette {
    public static final float BASE_TOLERANCE = 0.0055555557f;
    private static final Palette EMPTY = new Palette(List.of());
    private float tolerance = 0.0f;
    private final ArrayList<PaletteColor> internal = new ArrayList();

    protected Palette(Collection<PaletteColor> colors) {
        this.internal.addAll(colors);
        this.sort();
    }

    protected Palette(Collection<PaletteColor> colors, float tolerance) {
        this.internal.addAll(colors);
        this.sort();
        this.updateTolerance(tolerance);
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public Palette copy() {
        return new Palette(this.internal, this.tolerance);
    }

    public void updateTolerance(float tolerance) {
        boolean recalculate;
        if (this.tolerance == tolerance) {
            return;
        }
        this.tolerance = tolerance;
        if (tolerance == 0.0f) {
            return;
        }
        do {
            recalculate = false;
            for (int i = 1; i < this.size(); ++i) {
                PaletteColor c1;
                PaletteColor c0 = this.get(i - 1);
                if (!(c0.distanceTo(c1 = this.get(i)) <= tolerance)) continue;
                Palette tempPal = new Palette(List.of(c0, c1));
                for (int after = i + 1; after < this.size() && tempPal.calculateAverage().distanceTo(this.get(after)) <= tolerance; ++after) {
                    tempPal.add(this.get(after));
                }
                tempPal.getValues().forEach(this::remove);
                this.add(tempPal.calculateAverage());
                recalculate = true;
            }
        } while (recalculate);
    }

    public int size() {
        return this.internal.size();
    }

    public List<PaletteColor> getValues() {
        return this.internal;
    }

    private void sort() {
        Collections.sort(this.internal);
    }

    private void addUnchecked(PaletteColor color) {
        if (color.rgb().alpha() == 0.0f) {
            return;
        }
        this.internal.add(color);
        this.sort();
    }

    public void add(PaletteColor color) {
        if (color.rgb().alpha() == 0.0f) {
            return;
        }
        if (!this.hasColor(color)) {
            this.internal.add(color);
            this.sort();
        }
    }

    public void set(int index, PaletteColor color) {
        if (color.rgb().alpha() == 0.0f) {
            return;
        }
        if (!this.hasColor(color)) {
            this.internal.set(index, color);
        }
    }

    public PaletteColor get(int index) {
        return this.internal.get(index);
    }

    public int indexOf(PaletteColor color) {
        return this.internal.indexOf(color);
    }

    public boolean hasColor(PaletteColor color) {
        return this.hasColor(color, this.tolerance);
    }

    public boolean hasColor(PaletteColor color, float tolerance) {
        if (color.rgb().alpha() != 0.0f) {
            for (PaletteColor c : this.getValues()) {
                if (!(c.distanceTo(color) <= tolerance)) continue;
                return true;
            }
        }
        return false;
    }

    public PaletteColor getDarkest() {
        return this.get(0);
    }

    public PaletteColor getLightest() {
        return this.get(this.internal.size() - 1);
    }

    public void remove(int index) {
        this.internal.remove(index);
        this.sort();
    }

    public void remove(PaletteColor color) {
        if (this.internal.remove(color)) {
            this.sort();
        }
    }

    public PaletteColor calculateAverage() {
        return new PaletteColor(LABColor.averageColors((LABColor[])this.getValues().stream().map(PaletteColor::lab).toArray(LABColor[]::new)));
    }

    public PaletteColor getColorAtSlope(float slope) {
        int index = Math.round((float)(this.internal.size() - 1) * slope);
        return this.internal.get(index);
    }

    public PaletteColor getCenterColor() {
        PaletteColor center = this.calculateAverage();
        return this.getColorClosestTo(center);
    }

    private PaletteColor getColorClosestTo(PaletteColor target) {
        PaletteColor bestMatch = target;
        float lastDist = Float.MAX_VALUE;
        for (PaletteColor c : this.getValues()) {
            float dist = target.distanceTo(c);
            if (!(dist < lastDist)) continue;
            lastDist = dist;
            bestMatch = c;
        }
        return bestMatch;
    }

    public void matchSize(int targetSize) {
        int currentSize;
        if (this.size() == 0 || targetSize <= 0) {
            throw new UnsupportedOperationException("Palette size can't be 0");
        }
        if (this.size() == 2) {
            PaletteColor lightest = this.getLightest();
            PaletteColor darkest = this.getDarkest();
            Palette other = Palette.fromArc(lightest.hcl(), darkest.hcl(), targetSize);
            this.internal.clear();
            this.internal.addAll(other.getValues());
        }
        while (this.size() > targetSize) {
            this.removeLeastUsed();
        }
        boolean down = true;
        boolean canIncreaseDown = true;
        boolean canIncreaseUp = true;
        while ((currentSize = this.size()) < targetSize) {
            if (this.hasLuminanceGap() || !canIncreaseDown && !canIncreaseUp) {
                this.increaseInner();
                continue;
            }
            if (down) {
                this.increaseDown();
            } else {
                this.increaseUp();
            }
            if (currentSize == this.size()) {
                if (down) {
                    canIncreaseDown = false;
                } else {
                    canIncreaseUp = false;
                }
                boolean bl = down = !down;
            }
            if (!canIncreaseDown || !canIncreaseUp) continue;
            down = !down;
        }
    }

    public void removeLeastUsed() {
        PaletteColor toRemove = this.internal.get(0);
        for (PaletteColor p : this.internal) {
            if (p.occurrence >= toRemove.occurrence) continue;
            toRemove = p;
        }
        this.remove(toRemove);
    }

    public void reduce() {
        int index = 0;
        float minDelta = 10000.0f;
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            float dl = l - lastLum;
            if (dl < minDelta) {
                index = i;
                minDelta = dl;
            }
            lastLum = l;
        }
        this.remove(this.get(index));
    }

    private boolean hasLuminanceGap() {
        return this.hasLuminanceGap(1.7f);
    }

    private boolean hasLuminanceGap(float cutoff) {
        List<Float> list = this.getLuminanceSteps();
        float mean = this.getAverageLuminanceStep();
        for (Float s : list) {
            if (!(s.floatValue() > cutoff * mean)) continue;
            return true;
        }
        return false;
    }

    public float getLuminanceStepVariationCoeff() {
        List<Float> list = this.getLuminanceSteps();
        float mean = this.getAverageLuminanceStep();
        float sum = 0.0f;
        for (Float s : list) {
            sum += (s.floatValue() - mean) * (s.floatValue() - mean);
        }
        return Mth.m_14116_((float)(sum / (float)(list.size() - 1))) / mean;
    }

    public List<Float> getLuminanceSteps() {
        ArrayList<Float> list = new ArrayList<Float>();
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            list.add(Float.valueOf(l - lastLum));
            lastLum = l;
        }
        return list;
    }

    public float getAverageLuminanceStep() {
        List<Float> list = this.getLuminanceSteps();
        float total = 0.0f;
        for (Float v : list) {
            total += v.floatValue();
        }
        return total / (float)list.size();
    }

    public PaletteColor increaseInner() {
        assert (this.size() < 2);
        int index = 1;
        float maxDelta = 0.0f;
        float lastLum = this.get(0).luminance();
        for (int i = 1; i < this.size(); ++i) {
            float l = this.get(i).luminance();
            float dl = l - lastLum;
            if (dl > maxDelta) {
                index = i;
                maxDelta = dl;
            }
            lastLum = l;
        }
        HCLColor c1 = this.get(index).hcl();
        HCLColor c2 = this.get(index - 1).hcl();
        PaletteColor newC = new PaletteColor(c1.mixWith(c2));
        this.addUnchecked(newC);
        return newC;
    }

    public PaletteColor increaseUp() {
        assert (this.size() < 2);
        float averageDeltaLum = this.getAverageLuminanceStep();
        HCLColor lightest = this.getLightest().hcl();
        HCLColor secondLightest = this.get(this.size() - 2).hcl();
        HCLColor cc = this.getNextColor(averageDeltaLum, lightest, secondLightest);
        PaletteColor pl = new PaletteColor(cc);
        this.add(pl);
        return pl;
    }

    public PaletteColor increaseDown() {
        assert (this.size() < 2);
        float averageDeltaLum = this.getAverageLuminanceStep();
        HCLColor darkest = this.getDarkest().hcl();
        HCLColor secondDarkest = this.get(1).hcl();
        HCLColor cc = this.getNextColor(-averageDeltaLum, darkest, secondDarkest);
        PaletteColor pl = new PaletteColor(cc);
        this.add(pl);
        return pl;
    }

    private HCLColor getNextColor(float lumIncrease, HCLColor source, HCLColor previous) {
        float newH;
        float newLum = source.luminance() + lumIncrease;
        float h1 = source.hue();
        float c1 = source.chroma();
        float a1 = source.alpha();
        float h2 = previous.hue();
        float c2 = previous.chroma();
        float a2 = previous.alpha();
        float hueIncrease = (float)((double)(-MthUtils.signedAngleDiff((double)h1 * Math.PI * 2.0, (double)h2 * Math.PI * 2.0)) / (Math.PI * 2));
        for (newH = h1 + hueIncrease * 0.5f; newH < 0.0f; newH += 1.0f) {
        }
        float newC = c1 + (c1 - c2);
        float newA = a1 + (a1 - a2);
        return new HCLColor(newH, newC, newLum, newA);
    }

    public static Palette merge(Palette ... palettes) {
        if (palettes.length == 1) {
            return new Palette(palettes[0].getValues());
        }
        HashMap<Integer, PaletteColor> map = new HashMap<Integer, PaletteColor>();
        for (Palette p : palettes) {
            for (PaletteColor c : p.getValues()) {
                int color = c.value();
                if (map.containsKey(color)) {
                    ((PaletteColor)map.get((Object)Integer.valueOf((int)color))).occurrence += c.occurrence;
                    continue;
                }
                map.put(color, c);
            }
        }
        if (map.values().size() == 0) {
            return EMPTY;
        }
        return new Palette(map.values());
    }

    public static Palette ofColors(Collection<BaseColor<?>> colors) {
        return new Palette(colors.stream().map(PaletteColor::new).collect(Collectors.toSet()));
    }

    public static <T extends BaseColor<T>> Palette fromArc(T light, T dark, int size) {
        ArrayList<T> colors = new ArrayList<T>();
        if (size <= 1) {
            throw new IllegalArgumentException("Size must be greater than one");
        }
        for (int i = 0; i < size; ++i) {
            colors.add(dark.mixWith(light, (float)i / ((float)size - 1.0f)));
        }
        return new Palette(colors.stream().map(PaletteColor::new).collect(Collectors.toSet()));
    }

    public static Palette fromImage(TextureImage image) {
        return Palette.fromImage(image, null);
    }

    public static Palette fromImage(TextureImage image, @Nullable TextureImage mask) {
        return Palette.fromImage(image, mask, 0.0055555557f);
    }

    public static Palette fromImage(TextureImage textureImage, @Nullable TextureImage textureMask, float tolerance) {
        List<Palette> palettes = Palette.fromAnimatedImage(textureImage, textureMask, 0.0f);
        Palette palette = Palette.merge(palettes.toArray(new Palette[0]));
        if (tolerance != 0.0f) {
            palette.updateTolerance(tolerance);
        }
        return palette;
    }

    public static List<Palette> fromAnimatedImage(TextureImage image) {
        return Palette.fromAnimatedImage(image, null);
    }

    public static List<Palette> fromAnimatedImage(TextureImage image, @Nullable TextureImage mask) {
        return Palette.fromAnimatedImage(image, mask, 0.0055555557f);
    }

    public static List<Palette> fromAnimatedImage(TextureImage textureImage, @Nullable TextureImage textureMask, float tolerance) {
        if (textureMask != null && (textureImage.framesSize() != textureMask.framesSize() || textureMask.frameWidth() < textureImage.frameWidth() || textureMask.frameHeight() < textureImage.frameHeight())) {
            throw new UnsupportedOperationException("Palette mask needs to be at least as large as the target image and have the same format");
        }
        ArrayList<Palette> palettes = new ArrayList<Palette>();
        NativeImage mask = textureMask == null ? null : textureMask.getImage();
        NativeImage image = textureImage.getImage();
        ArrayList paletteBuilders = new ArrayList();
        textureImage.forEachFrame((index, x, y) -> {
            int color;
            if (paletteBuilders.size() <= index) {
                paletteBuilders.add(new HashMap());
            }
            Map builder = (Map)paletteBuilders.get(index);
            if ((mask == null || NativeImage.m_84983_((int)mask.m_84985_(x.intValue(), y.intValue())) == 0) && NativeImage.m_84983_((int)(color = image.m_84985_(x.intValue(), y.intValue()))) != 0) {
                PaletteColor paletteColor = builder.computeIfAbsent(color, p -> new PaletteColor(color));
                ++paletteColor.occurrence;
            }
        });
        for (Map p : paletteBuilders) {
            Palette pal = p.size() == 0 ? EMPTY : new Palette(p.values(), tolerance);
            palettes.add(pal);
        }
        return palettes;
    }
}

