/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.wood;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends IBlockType {
    public static WoodType OAK_WOOD_TYPE = new WoodType(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_);
    public final Material material;
    public final Block planks;
    public final Block log;
    @Deprecated
    @Nullable
    public final Block strippedLog;
    @Deprecated
    @Nullable
    public final Block leaves;
    @Deprecated
    public final Lazy<Item> signItem;
    @Deprecated
    public final Lazy<Item> boatItem;
    @Nullable
    private final net.minecraft.world.level.block.state.properties.WoodType vanillaType;

    protected WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
        this.strippedLog = this.findLogRelatedBlock("stripped", "log");
        this.leaves = (Block)this.findRelatedEntry("leaves", ForgeRegistries.BLOCKS);
        this.signItem = Lazy.of(() -> (Item)this.findRelatedEntry("sign", ForgeRegistries.ITEMS));
        this.boatItem = Lazy.of(() -> (Item)this.findRelatedEntry("boat", ForgeRegistries.ITEMS));
        String i = id.m_135827_().equals("minecraft") ? "" : id.m_135827_() + "/" + id.m_135815_();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = net.minecraft.world.level.block.state.properties.WoodType.m_61843_().filter(v -> v.m_61846_().equals(i)).findAny();
        this.vanillaType = o.orElse(null);
    }

    @Nullable
    protected Block findLogRelatedBlock(String append, String postpend) {
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        ResourceLocation id = this.getId();
        String log = this.log.getRegistryName().m_135815_();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), log + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + log + (String)post), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + append + (String)post), new ResourceLocation(id.m_135827_(), append + "_" + id.m_135815_() + (String)post)};
        Block found = null;
        for (ResourceLocation r : targets) {
            if (!ForgeRegistries.BLOCKS.containsKey(r)) continue;
            found = (Block)ForgeRegistries.BLOCKS.getValue(r);
            break;
        }
        return found;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType;
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    @Deprecated
    private static String abbreviateString(String string) {
        if (string.length() <= 5) {
            return string;
        }
        String[] a = string.split("_");
        if (a.length > 2) {
            return "" + a[0].charAt(0) + a[1].charAt(0) + a[2].charAt(0) + (Serializable)(a.length > 3 ? Character.valueOf(a[3].charAt(0)) : "");
        }
        if (a.length > 1) {
            return a[0].substring(0, Math.min(2, a[0].length())) + a[1].substring(0, Math.min(2, a[0].length()));
        }
        return string.substring(0, 4);
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildren() {
        Block strippedWood = this.findLogRelatedBlock("stripped", "wood");
        Block wood = (Block)this.findRelatedEntry("wood", ForgeRegistries.BLOCKS);
        Block slab = (Block)this.findRelatedEntry("slab", ForgeRegistries.BLOCKS);
        Block stairs = (Block)this.findRelatedEntry("stairs", ForgeRegistries.BLOCKS);
        Block fence = (Block)this.findRelatedEntry("fence", ForgeRegistries.BLOCKS);
        Block fenceGate = (Block)this.findRelatedEntry("fence_gate", ForgeRegistries.BLOCKS);
        Block door = (Block)this.findRelatedEntry("door", ForgeRegistries.BLOCKS);
        Block trapdoor = (Block)this.findRelatedEntry("trapdoor", ForgeRegistries.BLOCKS);
        Block button = (Block)this.findRelatedEntry("button", ForgeRegistries.BLOCKS);
        Block pressurePlate = (Block)this.findRelatedEntry("pressure_plate", ForgeRegistries.BLOCKS);
        this.addChild("planks", (ItemLike)this.planks);
        this.addChild("log", (ItemLike)this.log);
        this.addChild("leaves", (ItemLike)this.leaves);
        this.addChild("stripped_log", (ItemLike)this.strippedLog);
        this.addChild("stripped_wood", (ItemLike)strippedWood);
        this.addChild("wood", (ItemLike)wood);
        this.addChild("slab", (ItemLike)slab);
        this.addChild("stairs", (ItemLike)stairs);
        this.addChild("fence", (ItemLike)fence);
        this.addChild("fence_gate", (ItemLike)fenceGate);
        this.addChild("door", (ItemLike)door);
        this.addChild("trapdoor", (ItemLike)trapdoor);
        this.addChild("button", (ItemLike)button);
        this.addChild("pressure_plate", (ItemLike)pressurePlate);
        this.addChild("sign", (ItemLike)this.signItem.get());
        this.addChild("boat", (ItemLike)this.boatItem.get());
    }

    public static class Finder
    extends BlockType.SetFinder<WoodType> {
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)ForgeRegistries.BLOCKS.getValue(planksName), () -> (Block)ForgeRegistries.BLOCKS.getValue(logName));
        }

        @Override
        public Optional<WoodType> get() {
            if (ModList.get().isLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.BLOCKS.getDefaultKey());
                    if (plank != d && log != d && plank != null && log != null) {
                        return Optional.of(new WoodType(this.id, plank, log));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Selene.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

