/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.block_set.leaves;

import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.block_set.BlockType;
import net.mehvahdjukaar.selene.block_set.IBlockType;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class LeavesType
extends IBlockType {
    public static LeavesType OAK_LEAVES_TYPE = new LeavesType(new ResourceLocation("oak"), Blocks.f_50050_, WoodType.OAK_WOOD_TYPE);
    public final Block leaves;
    public final WoodType woodType;

    protected LeavesType(ResourceLocation id, Block leaves, @Nullable WoodType woodType) {
        super(id);
        this.leaves = leaves;
        this.woodType = woodType;
    }

    @Override
    public ItemLike mainChild() {
        return this.leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    protected void initializeChildren() {
        this.addChild("leaves", (ItemLike)this.leaves);
    }

    public static class Finder
    extends BlockType.SetFinder<LeavesType> {
        private final Supplier<Block> leavesFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> leaves) {
            this.id = id;
            this.leavesFinder = leaves;
        }

        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(new ResourceLocation(modId, leavesTypeName), () -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modId, leavesName)));
        }

        @Override
        public Optional<LeavesType> get() {
            if (ModList.get().isLoaded(this.id.m_135827_())) {
                try {
                    Block leaves = this.leavesFinder.get();
                    Block d = (Block)ForgeRegistries.BLOCKS.getValue(ForgeRegistries.BLOCKS.getDefaultKey());
                    if (leaves != d && leaves != null) {
                        WoodType w = WoodTypeRegistry.WOOD_TYPES.get(this.id);
                        return Optional.of(new LeavesType(this.id, leaves, w));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Selene.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

