/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.world.gen.structure;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.PostPlacementProcessor;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.world.module.BigDungeonModule;

public class BigDungeonStructure
extends StructureFeature<JigsawConfiguration> {
    private static final String NAMESPACE = "big_dungeon";

    public BigDungeonStructure(Codec<JigsawConfiguration> codec) {
        super(codec, context -> {
            if (!BigDungeonStructure.checkLocation((PieceGeneratorSupplier.Context<JigsawConfiguration>)context)) {
                return Optional.empty();
            }
            return BigDungeonStructure.createGenerator((PieceGeneratorSupplier.Context<JigsawConfiguration>)context);
        }, PostPlacementProcessor.f_192427_);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    private static boolean checkLocation(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(BigDungeonModule.class)) {
            return false;
        }
        ChunkPos chunkpos = context.f_197355_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.setSeed((long)(i ^ j << 4) ^ context.f_197354_());
        worldgenrandom.nextInt();
        if (worldgenrandom.nextDouble() < BigDungeonModule.spawnChance) {
            return true;
        }
        return !context.f_197352_().m_212265_(BuiltinStructureSets.f_209820_, context.f_197354_(), chunkpos.f_45578_, chunkpos.f_45579_, 10);
    }

    public static Optional<PieceGenerator<JigsawConfiguration>> createGenerator(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int i = context.f_197355_().f_45578_ >> 4;
        int j = context.f_197355_().f_45579_ >> 4;
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.setSeed((long)(i ^ j << 4) ^ context.f_197354_());
        worldgenrandom.nextInt();
        int y = BigDungeonModule.minStartY + worldgenrandom.nextInt(BigDungeonModule.maxStartY - BigDungeonModule.minStartY);
        BlockPos blockpos = context.f_197355_().m_151394_(y);
        JigsawConfiguration newConfig = new JigsawConfiguration(Holder.m_205709_((Object)((StructureTemplatePool)context.f_197360_().m_206191_(Registry.f_122884_).m_7745_(new ResourceLocation("quark", "big_dungeon/starts")))), BigDungeonModule.maxRooms);
        PieceGeneratorSupplier.Context newContext = new PieceGeneratorSupplier.Context(context.f_197352_(), context.f_197353_(), context.f_197354_(), context.f_197355_(), (FeatureConfiguration)newConfig, context.f_197357_(), BigDungeonModule.biomeConfig::canSpawn, context.f_197359_(), context.f_197360_());
        Optional structurePiecesGenerator = JigsawPlacement.m_210284_((PieceGeneratorSupplier.Context)newContext, PoolElementStructurePiece::new, (BlockPos)blockpos, (boolean)false, (boolean)false);
        return structurePiecesGenerator;
    }
}

