/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import vazkii.quark.base.Quark;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.type.AbstractConfigType;
import vazkii.quark.content.tools.loot.InBiomeCondition;
import vazkii.quark.content.tools.loot.PathfinderMapFunction;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class PathfinderMapsModule
extends QuarkModule {
    private static final Object mutex = new Object();
    public static List<TradeInfo> builtinTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> customTrades = new LinkedList<TradeInfo>();
    public static List<TradeInfo> tradeList = new LinkedList<TradeInfo>();
    @Config(description="In this section you can add custom Pathfinder Maps. This works for both vanilla and modded biomes.\nEach custom map must be on its own line.\nThe format for a custom map is as follows:\n<id>,<level>,<min_price>,<max_price>,<color>,<name>\n\nWith the following descriptions:\n - <id> being the biome's ID NAME. You can find vanilla names here - https://minecraft.gamepedia.com/Biome#Biome_IDs\n - <level> being the Cartographer villager level required for the map to be unlockable\n - <min_price> being the cheapest (in Emeralds) the map can be\n - <max_price> being the most expensive (in Emeralds) the map can be\n - <color> being a hex color (without the #) for the map to display. You can generate one here - https://htmlcolorcodes.com/\n\nHere's an example of a map to locate Ice Mountains:\nminecraft:ice_mountains,2,8,14,7FE4FF")
    private List<String> customs = new LinkedList<String>();
    public static LootItemFunctionType pathfinderMapType;
    public static LootItemConditionType inBiomeConditionType;
    @Config
    public static int searchRadius;
    @Config
    public static int searchDistanceIncrement;
    @Config
    public static int xpFromTrade;

    @Override
    public void register() {
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186761_, true, 4, 8, 14, 8381695);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186765_, true, 4, 8, 14, 0x8A8A8A);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48151_, true, 4, 8, 14, 22794);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48203_, true, 4, 8, 14, 13416782);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48157_, true, 4, 8, 14, 10200418);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48207_, true, 4, 12, 18, 2242319);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_186763_, true, 4, 12, 18, 5980703);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48179_, true, 5, 12, 18, 13518562);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48222_, true, 5, 16, 22, 2274816);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48197_, true, 5, 16, 22, 4055575);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48159_, true, 5, 16, 22, 13008674);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48215_, true, 5, 20, 26, 5063283);
        this.loadTradeInfo((ResourceKey<Biome>)Biomes.f_48182_, true, 5, 20, 26, 2015433);
        pathfinderMapType = new LootItemFunctionType((Serializer)new PathfinderMapFunction.Serializer());
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("quark", "pathfinder_map"), (Object)pathfinderMapType);
        inBiomeConditionType = new LootItemConditionType((Serializer)new InBiomeCondition.InBiomeSerializer());
        Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("quark", "in_biome"), (Object)inBiomeConditionType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTradesLoaded(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.f_35588_) {
            Object object = mutex;
            synchronized (object) {
                Int2ObjectMap trades = event.getTrades();
                for (TradeInfo info : tradeList) {
                    if (info == null) continue;
                    ((List)trades.get(info.level)).add(new PathfinderMapTrade(info));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configChanged() {
        Object object = mutex;
        synchronized (object) {
            tradeList.clear();
            customTrades.clear();
            this.loadCustomMaps(this.customs);
            tradeList.addAll(builtinTrades);
            tradeList.addAll(customTrades);
        }
    }

    private void loadTradeInfo(ResourceKey<Biome> biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        builtinTrades.add(new TradeInfo(biome.m_135782_(), enabled, level, minPrice, maxPrice, color));
    }

    private void loadCustomTradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
        customTrades.add(new TradeInfo(biome, enabled, level, minPrice, maxPrice, color));
    }

    private void loadCustomTradeInfo(String line) throws IllegalArgumentException {
        String[] tokens = line.split(",");
        if (tokens.length != 5 && tokens.length != 6) {
            throw new IllegalArgumentException("Wrong number of parameters " + tokens.length + " (expected 5)");
        }
        ResourceLocation biomeName = new ResourceLocation(tokens[0]);
        int level = Integer.parseInt(tokens[1]);
        int minPrice = Integer.parseInt(tokens[2]);
        int maxPrice = Integer.parseInt(tokens[3]);
        int color = Integer.parseInt(tokens[4], 16);
        this.loadCustomTradeInfo(biomeName, true, level, minPrice, maxPrice, color);
    }

    private void loadCustomMaps(Iterable<String> lines) {
        for (String s : lines) {
            try {
                this.loadCustomTradeInfo(s);
            }
            catch (IllegalArgumentException e) {
                Quark.LOG.warn("[Custom Pathfinder Maps] Error while reading custom map string \"{}\"", (Object)s);
                Quark.LOG.warn("[Custom Pathfinder Maps] - {}", (Object)e.getMessage());
            }
        }
    }

    public static ItemStack createMap(Level world, BlockPos pos, Predicate<Holder<Biome>> predicate, int color) {
        if (!(world instanceof ServerLevel)) {
            return ItemStack.f_41583_;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Pair biomeInfo = serverLevel.m_207571_(predicate, pos, searchRadius, searchDistanceIncrement);
        if (biomeInfo == null) {
            return ItemStack.f_41583_;
        }
        BlockPos biomePos = (BlockPos)biomeInfo.getFirst();
        Either biome = ((Holder)biomeInfo.getSecond()).m_203439_();
        Optional key = (Optional)biome.map(Optional::of, arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getResourceKey(arg_0));
        Component biomeComponent = (Component)key.map(ResourceKey::m_135782_).map(it -> new TranslatableComponent("biome." + it.m_135827_() + "." + it.m_135815_())).orElse(new TranslatableComponent("item.quark.biome_map.unknown").m_130940_(ChatFormatting.RED));
        ItemStack stack = MapItem.m_42886_((Level)world, (int)biomePos.m_123341_(), (int)biomePos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
        MapItem.m_42850_((ServerLevel)serverLevel, (ItemStack)stack);
        MapItemSavedData.m_77925_((ItemStack)stack, (BlockPos)biomePos, (String)"+", (MapDecoration.Type)MapDecoration.Type.RED_X);
        stack.m_41714_((Component)new TranslatableComponent("item.quark.biome_map", new Object[]{biomeComponent}));
        stack.m_41698_("display").m_128405_("MapColor", color);
        return stack;
    }

    static {
        searchRadius = 6400;
        searchDistanceIncrement = 8;
        xpFromTrade = 5;
    }

    public static class TradeInfo
    extends AbstractConfigType
    implements Predicate<Holder<Biome>> {
        public final ResourceLocation biome;
        public final int color;
        @Config
        public boolean enabled;
        @Config
        public final int level;
        @Config
        public final int minPrice;
        @Config
        public final int maxPrice;

        TradeInfo(ResourceLocation biome, boolean enabled, int level, int minPrice, int maxPrice, int color) {
            this.biome = biome;
            this.enabled = enabled;
            this.level = level;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
            this.color = color;
        }

        @Override
        public boolean test(Holder<Biome> biomeHolder) {
            return biomeHolder.m_203373_(this.biome);
        }
    }

    private record PathfinderMapTrade(TradeInfo info) implements VillagerTrades.ItemListing
    {
        public MerchantOffer m_5670_(@Nonnull Entity entity, @Nonnull Random random) {
            if (!this.info.enabled) {
                return null;
            }
            int i = random.nextInt(this.info.maxPrice - this.info.minPrice + 1) + this.info.minPrice;
            ItemStack itemstack = PathfinderMapsModule.createMap(entity.f_19853_, entity.m_142538_(), this.info, this.info.color);
            if (itemstack.m_41619_()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, i), new ItemStack((ItemLike)Items.f_42522_), itemstack, 12, xpFromTrade * Math.max(1, this.info.level - 1), 0.2f);
        }
    }
}

