/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.module;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.api.IRuneColorProvider;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.content.tools.item.AncientTomeItem;
import vazkii.quark.content.tools.loot.EnchantTome;
import vazkii.quark.content.world.module.MonsterBoxModule;

@LoadModule(category=ModuleCategory.TOOLS, hasSubscriptions=true)
public class AncientTomesModule
extends QuarkModule {
    @Config(description="Format is lootTable,weight. i.e. \"minecraft:chests/stronghold_library,30\"")
    public static List<String> lootTables = Lists.newArrayList((Object[])new String[]{AncientTomesModule.loot(BuiltInLootTables.f_78761_, 30), AncientTomesModule.loot(BuiltInLootTables.f_78742_, 20), AncientTomesModule.loot(BuiltInLootTables.f_78697_, 25), AncientTomesModule.loot(BuiltInLootTables.f_78689_, 15), AncientTomesModule.loot(BuiltInLootTables.f_78760_, 0), AncientTomesModule.loot(BuiltInLootTables.f_78691_, 0), AncientTomesModule.loot(BuiltInLootTables.f_78690_, 0), AncientTomesModule.loot(MonsterBoxModule.MONSTER_BOX_LOOT_TABLE, 5)});
    private static final Object2IntMap<ResourceLocation> lootTableWeights = new Object2IntArrayMap();
    @Config
    public static int itemQuality = 2;
    @Config
    public static int normalUpgradeCost = 10;
    @Config
    public static int limitBreakUpgradeCost = 30;
    public static LootItemFunctionType tomeEnchantType;
    @Config(name="Valid Enchantments")
    public static List<String> enchantNames;
    @Config
    public static boolean overleveledBooksGlowRainbow;
    public static Item ancient_tome;
    public static final List<Enchantment> validEnchants;
    private static boolean initialized;
    private static final ResourceLocation OVERLEVEL_COLOR_HANDLER;

    private static String loot(ResourceLocation lootLoc, int defaultWeight) {
        return lootLoc.toString() + "," + defaultWeight;
    }

    @Override
    public void register() {
        ancient_tome = new AncientTomeItem(this);
        tomeEnchantType = new LootItemFunctionType((Serializer)new EnchantTome.Serializer());
        Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation("quark", "tome_enchant"), (Object)tomeEnchantType);
    }

    @Override
    public void configChanged() {
        lootTableWeights.clear();
        for (String table : lootTables) {
            int weight;
            String[] split = table.split(",");
            if (split.length != 2) continue;
            ResourceLocation loc = new ResourceLocation(split[0]);
            try {
                weight = Integer.parseInt(split[1]);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (weight <= 0) continue;
            lootTableWeights.put((Object)loc, weight);
        }
        if (initialized) {
            this.setupEnchantList();
        }
    }

    @Override
    public void setup() {
        this.setupEnchantList();
        initialized = true;
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        ResourceLocation res = event.getName();
        int weight = lootTableWeights.getOrDefault((Object)res, 0);
        if (weight > 0) {
            LootPoolEntryContainer entry = LootItem.m_79579_((ItemLike)ancient_tome).m_79707_(weight).m_79711_(itemQuality).m_5577_(() -> new EnchantTome(new LootItemCondition[0])).m_7512_();
            MiscUtil.addToLootTable(event.getTable(), entry);
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        ItemStack left = event.getLeft();
        ItemStack right = event.getRight();
        if (!left.m_41619_() && !right.m_41619_()) {
            if (right.m_150930_(ancient_tome)) {
                Enchantment ench = AncientTomesModule.getTomeEnchantment(right);
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)left);
                if (ench != null && enchants.containsKey(ench) && (Integer)enchants.get(ench) <= ench.m_6586_()) {
                    int lvl = (Integer)enchants.get(ench) + 1;
                    enchants.put(ench, lvl);
                    ItemStack copy = left.m_41777_();
                    EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)copy);
                    event.setOutput(copy);
                    event.setCost(lvl > ench.m_6586_() ? limitBreakUpgradeCost : normalUpgradeCost);
                }
            } else if (right.m_150930_(Items.f_42690_)) {
                Map enchants = EnchantmentHelper.m_44831_((ItemStack)right);
                Map currentEnchants = EnchantmentHelper.m_44831_((ItemStack)left);
                boolean hasOverLevel = false;
                boolean hasMatching = false;
                for (Map.Entry entry : enchants.entrySet()) {
                    Enchantment enchantment = (Enchantment)entry.getKey();
                    if (enchantment == null) continue;
                    int level = (Integer)entry.getValue();
                    if (level > enchantment.m_6586_()) {
                        hasOverLevel = true;
                        if (!enchantment.m_6081_(left) && !left.m_150930_(Items.f_42690_)) continue;
                        hasMatching = true;
                        Iterator iterator = currentEnchants.keySet().iterator();
                        while (iterator.hasNext()) {
                            Enchantment comparingEnchantment = (Enchantment)iterator.next();
                            if (comparingEnchantment == enchantment || comparingEnchantment.m_44695_(enchantment)) continue;
                            iterator.remove();
                        }
                        currentEnchants.put(enchantment, level);
                        continue;
                    }
                    if (!enchantment.m_6081_(left)) continue;
                    boolean compatible = true;
                    for (Enchantment comparingEnchantment : currentEnchants.keySet()) {
                        if (comparingEnchantment == enchantment || comparingEnchantment == null || comparingEnchantment.m_44695_(enchantment)) continue;
                        compatible = false;
                        break;
                    }
                    if (!compatible) continue;
                    currentEnchants.put(enchantment, level);
                }
                if (hasOverLevel && hasMatching) {
                    ItemStack out = left.m_41777_();
                    EnchantmentHelper.m_44865_((Map)currentEnchants, (ItemStack)out);
                    String name = event.getName();
                    int cost = normalUpgradeCost;
                    if (!(name == null || name.isEmpty() || out.m_41788_() && out.m_41786_().getString().equals(name))) {
                        out.m_41714_((Component)new TextComponent(name));
                        ++cost;
                    }
                    event.setOutput(out);
                    event.setCost(cost);
                }
            }
        }
    }

    private static boolean isOverlevel(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42690_) {
            Map enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            for (Map.Entry entry : enchants.entrySet()) {
                int level;
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (enchantment == null || (level = ((Integer)entry.getValue()).intValue()) <= enchantment.m_6586_()) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void attachRuneCapability(AttachCapabilitiesEvent<ItemStack> event) {
        if (((ItemStack)event.getObject()).m_41720_() == Items.f_42690_) {
            IRuneColorProvider provider = new IRuneColorProvider(){

                @Override
                @OnlyIn(value=Dist.CLIENT)
                public int getRuneColor(ItemStack stack) {
                    if (overleveledBooksGlowRainbow && AncientTomesModule.isOverlevel(stack)) {
                        return 16;
                    }
                    return -1;
                }
            };
            final LazyOptional holder = LazyOptional.of(() -> provider);
            event.addCapability(OVERLEVEL_COLOR_HANDLER, new ICapabilityProvider(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                    return QuarkCapabilities.RUNE_COLOR.orEmpty(cap, holder);
                }
            });
        }
    }

    public static Rarity shiftRarity(ItemStack itemStack, Rarity returnValue) {
        return ModuleLoader.INSTANCE.isModuleEnabled(AncientTomesModule.class) && overleveledBooksGlowRainbow && itemStack.m_41720_() == Items.f_42690_ && AncientTomesModule.isOverlevel(itemStack) ? Rarity.EPIC : returnValue;
    }

    private static List<String> generateDefaultEnchantmentList() {
        Enchantment[] enchants = new Enchantment[]{Enchantments.f_44967_, Enchantments.f_44972_, Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44982_, Enchantments.f_44983_, Enchantments.f_44984_, Enchantments.f_44986_, Enchantments.f_44987_, Enchantments.f_44988_, Enchantments.f_44989_, Enchantments.f_44953_, Enchantments.f_44954_, Enchantments.f_44955_, Enchantments.f_44957_, Enchantments.f_44956_, Enchantments.f_44961_};
        ArrayList<String> strings = new ArrayList<String>();
        for (Enchantment e : enchants) {
            if (e == null || e.getRegistryName() == null) continue;
            strings.add(e.getRegistryName().toString());
        }
        return strings;
    }

    private void setupEnchantList() {
        MiscUtil.initializeEnchantmentList(enchantNames, validEnchants);
        validEnchants.removeIf(ench -> ench.m_6586_() == 1);
    }

    public static Enchantment getTomeEnchantment(ItemStack stack) {
        if (stack.m_41720_() != ancient_tome) {
            return null;
        }
        ListTag listnbt = EnchantedBookItem.m_41163_((ItemStack)stack);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.m_128728_(i);
            Optional opt = Registry.f_122825_.m_6612_(ResourceLocation.m_135820_((String)compoundnbt.m_128461_("id")));
            if (!opt.isPresent()) continue;
            return opt.orElse(null);
        }
        return null;
    }

    static {
        enchantNames = AncientTomesModule.generateDefaultEnchantmentList();
        overleveledBooksGlowRainbow = true;
        validEnchants = new ArrayList<Enchantment>();
        initialized = false;
        OVERLEVEL_COLOR_HANDLER = new ResourceLocation("quark", "overlevel_rune");
    }
}

