/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.mobs.entity;

import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import vazkii.quark.base.handler.QuarkSounds;

public class SoulBead
extends Entity {
    private static final EntityDataAccessor<Integer> TARGET_X = SynchedEntityData.m_135353_(SoulBead.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TARGET_Z = SynchedEntityData.m_135353_(SoulBead.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int liveTicks = 0;
    private static final String TAG_TARGET_X = "targetX";
    private static final String TAG_TARGET_Z = "targetZ";

    public SoulBead(EntityType<? extends SoulBead> type, Level worldIn) {
        super(type, worldIn);
    }

    public void setTarget(int x, int z) {
        this.f_19804_.m_135381_(TARGET_X, (Object)x);
        this.f_19804_.m_135381_(TARGET_Z, (Object)z);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(TARGET_X, (Object)0);
        this.f_19804_.m_135372_(TARGET_Z, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        double posSpread = 0.4;
        double scale = 0.08;
        double rotateSpread = 1.5;
        double rise = 0.025;
        int maxLiveTime = 6000;
        int particles = 20;
        double trigArg = (double)this.liveTicks * 0.32;
        if (maxLiveTime - this.liveTicks < particles) {
            particles = maxLiveTime - this.liveTicks;
        }
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        Vec3 vec = new Vec3((double)((Integer)this.f_19804_.m_135370_(TARGET_X)).intValue(), posY, (double)((Integer)this.f_19804_.m_135370_(TARGET_Z)).intValue()).m_82492_(posX, posY, posZ).m_82541_().m_82490_(scale);
        double bpx = posX + vec.f_82479_ * (double)this.liveTicks + Math.cos(trigArg) * rotateSpread;
        double bpy = posY + vec.f_82480_ * (double)this.liveTicks + (double)this.liveTicks * rise;
        double bpz = posZ + vec.f_82481_ * (double)this.liveTicks + Math.sin(trigArg) * rotateSpread;
        for (int i = 0; i < particles; ++i) {
            double px = bpx + (Math.random() - 0.5) * posSpread;
            double py = bpy + (Math.random() - 0.5) * posSpread;
            double pz = bpz + (Math.random() - 0.5) * posSpread;
            this.f_19853_.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.12f, 0.1f), 1.0f), px, py, pz, 0.0, 0.0, 0.0);
            if (!(Math.random() < 0.05)) continue;
            this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50135_.m_49966_()), px, py, pz, 0.0, 0.0, 0.0);
        }
        if (Math.random() < 0.1) {
            this.f_19853_.m_6263_(null, bpx, bpy, bpz, QuarkSounds.ENTITY_SOUL_BEAD_IDLE, SoundSource.PLAYERS, 0.2f, 1.0f);
        }
        ++this.liveTicks;
        if (this.liveTicks > maxLiveTime) {
            this.m_6089_();
        }
    }

    public void m_7380_(@Nonnull CompoundTag compound) {
        this.f_19804_.m_135381_(TARGET_X, (Object)compound.m_128451_(TAG_TARGET_X));
        this.f_19804_.m_135381_(TARGET_Z, (Object)compound.m_128451_(TAG_TARGET_Z));
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        compound.m_128405_(TAG_TARGET_X, ((Integer)this.f_19804_.m_135370_(TARGET_X)).intValue());
        compound.m_128405_(TAG_TARGET_Z, ((Integer)this.f_19804_.m_135370_(TARGET_Z)).intValue());
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

