/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.block.be;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.util.MovableFakePlayer;
import vazkii.quark.content.automation.block.FeedingTroughBlock;
import vazkii.quark.content.automation.module.FeedingTroughModule;

public class FeedingTroughBlockEntity
extends RandomizableContainerBlockEntity {
    private static final GameProfile DUMMY_PROFILE = new GameProfile(UUID.randomUUID(), "[FeedingTrough]");
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private FakePlayer foodHolder = null;
    private int cooldown = 0;
    private long internalRng = 0L;

    public FeedingTroughBlockEntity(BlockPos pos, BlockState state) {
        super(FeedingTroughModule.blockEntityType, pos, state);
    }

    public FakePlayer getFoodHolder(TemptGoal goal) {
        if (this.foodHolder == null && this.f_58857_ instanceof ServerLevel) {
            this.foodHolder = new MovableFakePlayer((ServerLevel)this.f_58857_, DUMMY_PROFILE);
        }
        Animal entity = (Animal)goal.f_25924_;
        if (this.foodHolder != null) {
            for (int i = 0; i < this.m_6643_(); ++i) {
                ItemStack stack = this.m_8020_(i);
                if (!goal.f_25935_.test(stack) || !entity.m_6898_(stack)) continue;
                Inventory inventory = this.foodHolder.m_150109_();
                inventory.f_35974_.set(inventory.f_35977_, (Object)stack);
                Vec3 position = new Vec3((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_()).m_82520_(0.5, -1.0, 0.5);
                Vec3 direction = goal.f_25924_.m_20182_().m_82546_(position).m_82541_();
                Vec2 angles = MiscUtil.getMinecraftAngles(direction);
                Vec3 shift = direction.m_82490_(-0.5 / Math.max(Math.abs(direction.f_82479_), Math.max(Math.abs(direction.f_82480_), Math.abs(direction.f_82481_))));
                Vec3 truePos = position.m_82549_(shift);
                this.foodHolder.m_7678_(truePos.f_82479_, truePos.f_82480_, truePos.f_82481_, angles.f_82470_, angles.f_82471_);
                return this.foodHolder;
            }
        }
        return null;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FeedingTroughBlockEntity be) {
        if (level != null && !level.f_46443_) {
            if (be.cooldown > 0) {
                --be.cooldown;
            } else {
                be.cooldown = FeedingTroughModule.cooldown;
                List animals = level.m_45976_(Animal.class, new AABB(be.f_58858_).m_82377_(1.5, 0.0, 1.5).m_82310_(0.0, 0.75, 0.0));
                for (Animal creature : animals) {
                    if (!creature.m_5957_() || creature.m_146764_() != 0) continue;
                    for (int i = 0; i < be.m_6643_(); ++i) {
                        List animalsAround;
                        ItemStack stack = be.m_8020_(i);
                        if (!creature.m_6898_(stack)) continue;
                        creature.m_5496_(creature.m_7866_(stack), 0.5f + 0.5f * (float)level.f_46441_.nextInt(2), (level.f_46441_.nextFloat() - level.f_46441_.nextFloat()) * 0.2f + 1.0f);
                        be.addItemParticles((Entity)creature, stack, 16);
                        if (be.getSpecialRand().nextDouble() < FeedingTroughModule.loveChance && (animalsAround = level.m_45976_(Animal.class, new AABB(be.f_58858_).m_82400_(FeedingTroughModule.range))).size() <= FeedingTroughModule.maxAnimals) {
                            creature.m_27595_(null);
                        }
                        stack.m_41774_(1);
                        be.m_6596_();
                        return;
                    }
                }
            }
        }
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.m_58900_();
        if (this.f_58857_ != null && state.m_60734_() instanceof FeedingTroughBlock) {
            boolean shouldBeFull;
            boolean full = (Boolean)state.m_61143_((Property)FeedingTroughBlock.FULL);
            boolean bl = shouldBeFull = !this.m_7983_();
            if (full != shouldBeFull) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)FeedingTroughBlock.FULL, (Comparable)Boolean.valueOf(shouldBeFull)), 2);
            }
        }
    }

    private void addItemParticles(Entity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 direction = new Vec3(((double)entity.f_19853_.f_46441_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            direction = direction.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            direction = direction.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            double yVelocity = (double)(-entity.f_19853_.f_46441_.nextFloat()) * 0.6 - 0.3;
            Vec3 position = new Vec3(((double)entity.f_19853_.f_46441_.nextFloat() - 0.5) * 0.3, yVelocity, 0.6);
            Vec3 entityPos = entity.m_20182_();
            position = position.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            position = position.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            position = position.m_82520_(entityPos.f_82479_, entityPos.f_82480_ + (double)entity.m_20192_(), entityPos.f_82481_);
            if (this.f_58857_ instanceof ServerLevel) {
                ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), position.f_82479_, position.f_82480_, position.f_82481_, 1, direction.f_82479_, direction.f_82480_ + 0.05, direction.f_82481_, 0.0);
                continue;
            }
            if (this.f_58857_ == null) continue;
            this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), position.f_82479_, position.f_82480_, position.f_82481_, direction.f_82479_, direction.f_82480_ + 0.05, direction.f_82481_);
        }
    }

    private Random getSpecialRand() {
        Random specialRand = new Random(this.internalRng);
        this.internalRng = specialRand.nextLong();
        return specialRand;
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    protected Component m_6820_() {
        return new TranslatableComponent("quark.container.feeding_trough");
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.cooldown = nbt.m_128451_("Cooldown");
        this.internalRng = nbt.m_128454_("rng");
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.stacks);
        }
    }

    protected void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Cooldown", this.cooldown);
        nbt.m_128356_("rng", this.internalRng);
        if (!this.m_59634_(nbt)) {
            ContainerHelper.m_18973_((CompoundTag)nbt, this.stacks);
        }
    }

    @Nonnull
    protected NonNullList<ItemStack> m_7086_() {
        return this.stacks;
    }

    protected void m_6520_(@Nonnull NonNullList<ItemStack> items) {
        this.stacks = items;
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int id, @Nonnull Inventory playerInventory) {
        return new DispenserMenu(id, playerInventory, (Container)this);
    }
}

