/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator.multichunk;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;
import vazkii.quark.base.handler.GeneralConfig;
import vazkii.quark.base.module.config.type.ClusterSizeConfig;
import vazkii.quark.base.module.config.type.IBiomeConfig;

public record ClusterShape(BlockPos src, Vec3 radius, PerlinSimplexNoise noiseGenerator) {
    public boolean isInside(BlockPos pos) {
        return this.noiseDiff(pos) > 0.0;
    }

    public double noiseDiff(BlockPos pos) {
        double dz;
        double dy;
        double dx = (double)(pos.m_123341_() - this.src.m_123341_()) / this.radius.f_82479_;
        double r = Math.sqrt(dx * dx + (dy = (double)(pos.m_123342_() - this.src.m_123342_()) / this.radius.f_82480_) * dy + (dz = (double)(pos.m_123343_() - this.src.m_123343_()) / this.radius.f_82481_) * dz);
        if (r > 1.0) {
            return -1.0;
        }
        if (GeneralConfig.useFastWorldgen) {
            return 1.0;
        }
        double phi = Math.atan2(dz, dx);
        double theta = r == 0.0 ? 0.0 : Math.acos(dy / r);
        double xn = phi + (double)this.src.m_123341_();
        double yn = theta + (double)this.src.m_123343_();
        double noise = this.noiseGenerator.m_75449_(xn, yn, false);
        double cutoff = 2.356194490192345;
        if (phi > cutoff) {
            double noise0 = this.noiseGenerator.m_75449_(-Math.PI + (double)this.src.m_123341_(), yn, false);
            noise = Mth.m_14139_((double)((phi - cutoff) / (Math.PI - cutoff)), (double)noise, (double)noise0);
        }
        double maxR = noise + 0.5;
        return maxR - r;
    }

    public int getUpperBound() {
        return (int)Math.ceil((double)this.src.m_123342_() + this.radius.m_7098_());
    }

    public int getLowerBound() {
        return (int)Math.floor((double)this.src.m_123342_() - this.radius.m_7098_());
    }

    public static class Provider {
        private final ClusterSizeConfig config;
        private final PerlinSimplexNoise noiseGenerator;

        public Provider(ClusterSizeConfig config, long seed) {
            this.config = config;
            this.noiseGenerator = new PerlinSimplexNoise((RandomSource)new LegacyRandomSource(seed), (List)ImmutableList.of((Object)-4, (Object)-3, (Object)-2, (Object)-1, (Object)0, (Object)1, (Object)2, (Object)3, (Object)4));
        }

        public ClusterShape around(BlockPos src) {
            Random rand = this.randAroundBlockPos(src);
            int radiusX = this.config.horizontalSize + rand.nextInt(this.config.horizontalVariation);
            int radiusY = this.config.verticalSize + rand.nextInt(this.config.verticalVariation);
            int radiusZ = this.config.horizontalSize + rand.nextInt(this.config.horizontalVariation);
            return new ClusterShape(src, new Vec3((double)radiusX, (double)radiusY, (double)radiusZ), this.noiseGenerator);
        }

        public int getRadius() {
            return this.config.horizontalSize + this.config.horizontalVariation;
        }

        public int getRarity() {
            return this.config.rarity;
        }

        public int getRandomYLevel(Random rand) {
            return this.config.minYLevel + (this.config.minYLevel == this.config.maxYLevel ? 0 : rand.nextInt(Math.max(this.config.maxYLevel, this.config.minYLevel) - Math.min(this.config.maxYLevel, this.config.minYLevel)));
        }

        public IBiomeConfig getBiomeTypes() {
            return this.config.biomes;
        }

        public Random randAroundBlockPos(BlockPos pos) {
            return new Random(31L * (31L * (long)(31 + pos.m_123341_()) + (long)pos.m_123342_()) + (long)pos.m_123343_());
        }
    }
}

