/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type.inputtable;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.api.config.IConfigElement;
import vazkii.quark.base.client.config.screen.CategoryScreen;
import vazkii.quark.base.client.config.screen.WidgetWrapper;
import vazkii.quark.base.client.config.screen.inputtable.ConvulsionMatrixInputScreen;
import vazkii.quark.base.client.config.screen.inputtable.IInputtableConfigType;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class ConvulsionMatrixConfig
extends AbstractConfigType
implements IInputtableConfigType<ConvulsionMatrixConfig> {
    @Config
    public List<Double> r;
    @Config
    public List<Double> g;
    @Config
    public List<Double> b;
    public final double[] defaultMatrix;
    public double[] colorMatrix;

    public ConvulsionMatrixConfig(double[] defaultMatrix) {
        assert (defaultMatrix.length == 9);
        this.defaultMatrix = defaultMatrix;
        this.colorMatrix = Arrays.copyOf(defaultMatrix, defaultMatrix.length);
        this.r = Arrays.asList(defaultMatrix[0], defaultMatrix[1], defaultMatrix[2]);
        this.g = Arrays.asList(defaultMatrix[3], defaultMatrix[4], defaultMatrix[5]);
        this.b = Arrays.asList(defaultMatrix[6], defaultMatrix[7], defaultMatrix[8]);
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
        try {
            this.colorMatrix = new double[]{this.r.get(0), this.r.get(1), this.r.get(2), this.g.get(0), this.g.get(1), this.g.get(2), this.b.get(0), this.b.get(1), this.b.get(2)};
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            e.printStackTrace();
            this.colorMatrix = Arrays.copyOf(this.defaultMatrix, this.defaultMatrix.length);
        }
    }

    @Override
    public void inherit(ConvulsionMatrixConfig other, boolean committing) {
        this.r = other.r;
        this.g = other.g;
        this.b = other.b;
        this.colorMatrix = Arrays.copyOf(other.colorMatrix, other.colorMatrix.length);
        if (committing && this.category != null) {
            this.category.refresh();
            this.category.updateDirty();
        }
    }

    @Override
    public void inheritDefaults(ConvulsionMatrixConfig other) {
        this.colorMatrix = Arrays.copyOf(other.defaultMatrix, other.defaultMatrix.length);
    }

    @Override
    public ConvulsionMatrixConfig copy() {
        ConvulsionMatrixConfig newMatrix = new ConvulsionMatrixConfig(this.colorMatrix);
        newMatrix.inherit(this, false);
        return newMatrix;
    }

    public int convolve(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int outR = this.clamp((int)((double)r * this.colorMatrix[0] + (double)g * this.colorMatrix[1] + (double)b * this.colorMatrix[2]));
        int outG = this.clamp((int)((double)r * this.colorMatrix[3] + (double)g * this.colorMatrix[4] + (double)b * this.colorMatrix[5]));
        int outB = this.clamp((int)((double)r * this.colorMatrix[6] + (double)g * this.colorMatrix[7] + (double)b * this.colorMatrix[8]));
        return 0xFF000000 | ((outR & 0xFF) << 16) + ((outG & 0xFF) << 8) + (outB & 0xFF);
    }

    private int clamp(int val) {
        return Math.min(255, Math.max(0, val));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ConvulsionMatrixConfig && Arrays.equals(((ConvulsionMatrixConfig)obj).colorMatrix, this.colorMatrix);
    }

    public int hashCode() {
        return Arrays.hashCode(this.colorMatrix);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addWidgets(CategoryScreen parent, IConfigElement element, List<WidgetWrapper> widgets) {
        IInputtableConfigType.addPencil(parent, element, widgets, () -> new ConvulsionMatrixInputScreen((Screen)parent, this, element, parent.category));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getSubtitle() {
        return "[" + Arrays.stream(this.colorMatrix).boxed().map(d -> String.format("%.1f", d)).collect(Collectors.joining(", ")) + "]";
    }
}

