/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.api.ITransferManager;
import vazkii.quark.api.QuarkCapabilities;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.management.module.EasyTransferingModule;

public class InventoryTransferHandler {
    public static void transfer(Player player, boolean isRestock, boolean smart) {
        if (!ModuleLoader.INSTANCE.isModuleEnabled(EasyTransferingModule.class) || player.m_5833_() || !InventoryTransferHandler.accepts(player.f_36096_, player)) {
            return;
        }
        Transfer transfer = isRestock ? new Restock(player, smart) : new Transfer(player, smart);
        transfer.execute();
    }

    private static boolean hasProvider(Object te) {
        return te instanceof BlockEntity && ((BlockEntity)te).getCapability(QuarkCapabilities.TRANSFER).isPresent();
    }

    private static ITransferManager getProvider(Object te) {
        return (ITransferManager)((BlockEntity)te).getCapability(QuarkCapabilities.TRANSFER).orElse(null);
    }

    public static boolean accepts(AbstractContainerMenu container, Player player) {
        if (InventoryTransferHandler.hasProvider(container)) {
            return InventoryTransferHandler.getProvider(container).acceptsTransfer(player);
        }
        return container.f_38839_.size() - player.m_150109_().f_35974_.size() >= 27;
    }

    public static class Restock
    extends Transfer {
        public Restock(Player player, boolean filtered) {
            super(player, filtered);
        }

        @Override
        public void transfer(TransferPredicate predicate) {
            IItemHandler inv = (IItemHandler)((Pair)this.itemHandlers.get(0)).getLeft();
            PlayerInvWrapper playerInv = new PlayerInvWrapper((Container)this.player.m_150109_());
            for (int i = inv.getSlots() - 1; i >= 0; --i) {
                ItemStack copy;
                ItemStack ret;
                ItemStack stackAt = inv.getStackInSlot(i);
                if (stackAt.m_41619_() || ItemStack.m_41728_((ItemStack)stackAt, (ItemStack)(ret = this.insertInHandler((IItemHandler)playerInv, copy = stackAt.m_41777_(), predicate)))) continue;
                inv.extractItem(i, stackAt.m_41613_() - ret.m_41613_(), false);
            }
        }
    }

    public static class Transfer {
        public final Player player;
        public final boolean smart;
        public final List<Pair<IItemHandler, Double>> itemHandlers = new ArrayList<Pair<IItemHandler, Double>>();

        public Transfer(Player player, boolean smart) {
            this.player = player;
            this.smart = smart;
        }

        public void execute() {
            this.locateItemHandlers();
            if (this.itemHandlers.isEmpty()) {
                return;
            }
            if (this.smart) {
                this.smartTransfer();
            } else {
                this.roughTransfer();
            }
            this.player.f_36095_.m_38946_();
            this.player.f_36096_.m_38946_();
        }

        public void smartTransfer() {
            this.transfer((stack, handler) -> {
                int slots = handler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack stackAt = handler.getStackInSlot(i);
                    if (stackAt.m_41619_()) continue;
                    boolean itemEqual = stack.m_41720_() == stackAt.m_41720_();
                    boolean damageEqual = stack.m_41773_() == stackAt.m_41773_();
                    boolean nbtEqual = ItemStack.m_41658_((ItemStack)stackAt, (ItemStack)stack);
                    if (itemEqual && damageEqual && nbtEqual) {
                        return true;
                    }
                    if (!stack.m_41763_() || stack.m_41741_() != 1 || !itemEqual || !nbtEqual) continue;
                    return true;
                }
                return false;
            });
        }

        public void roughTransfer() {
            this.transfer((stack, handler) -> true);
        }

        public void locateItemHandlers() {
            AbstractContainerMenu c = this.player.f_36096_;
            for (Slot s : c.f_38839_) {
                Container inv = s.f_40218_;
                if (inv == this.player.m_150109_()) continue;
                this.itemHandlers.add((Pair<IItemHandler, Double>)Pair.of((Object)ContainerWrapper.provideWrapper(s, c), (Object)0.0));
                break;
            }
        }

        public void transfer(TransferPredicate predicate) {
            Inventory inv = this.player.m_150109_();
            for (int i = Inventory.m_36059_(); i < inv.f_35974_.size(); ++i) {
                ItemStack ret;
                ItemStack stackAt = inv.m_8020_(i);
                if (stackAt.m_41619_() || ItemStack.m_41728_((ItemStack)stackAt, (ItemStack)(ret = this.insert(stackAt, predicate)))) continue;
                inv.m_6836_(i, ret);
            }
        }

        public ItemStack insert(ItemStack stack, TransferPredicate predicate) {
            ItemStack ret = stack.m_41777_();
            for (Pair<IItemHandler, Double> pair : this.itemHandlers) {
                IItemHandler handler = (IItemHandler)pair.getLeft();
                ret = this.insertInHandler(handler, ret, predicate);
                if (!ret.m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            return ret;
        }

        public ItemStack insertInHandler(IItemHandler handler, ItemStack stack, TransferPredicate predicate) {
            if (predicate.test(stack, handler)) {
                ItemStack retStack = ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                if (retStack.m_41619_()) {
                    return retStack;
                }
                retStack = retStack.m_41777_();
                return retStack;
            }
            return stack;
        }
    }

    public static interface TransferPredicate
    extends BiPredicate<ItemStack, IItemHandler> {
    }

    public static class ContainerWrapper
    extends InvWrapper {
        private final AbstractContainerMenu container;

        public static IItemHandler provideWrapper(Slot slot, AbstractContainerMenu container) {
            if (slot instanceof SlotItemHandler) {
                IItemHandler handler = ((SlotItemHandler)slot).getItemHandler();
                if (InventoryTransferHandler.hasProvider(handler)) {
                    return InventoryTransferHandler.getProvider(handler).getTransferItemHandler(() -> handler);
                }
                return handler;
            }
            return ContainerWrapper.provideWrapper(slot.f_40218_, container);
        }

        public static IItemHandler provideWrapper(Container inv, AbstractContainerMenu container) {
            if (InventoryTransferHandler.hasProvider(inv)) {
                return InventoryTransferHandler.getProvider(inv).getTransferItemHandler(() -> new ContainerWrapper(inv, container));
            }
            return new ContainerWrapper(inv, container);
        }

        private ContainerWrapper(Container inv, AbstractContainerMenu container) {
            super(inv);
            this.container = container;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            Slot containerSlot = this.getSlot(slot);
            if (containerSlot == null || !containerSlot.m_5857_(stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        private Slot getSlot(int slotId) {
            Container inv = this.getInv();
            for (Slot slot : this.container.f_38839_) {
                if (slot.f_40218_ != inv || slot.getSlotIndex() != slotId) continue;
                return slot;
            }
            return null;
        }
    }

    public static class PlayerInvWrapper
    extends InvWrapper {
        public PlayerInvWrapper(Container inv) {
            super(inv);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (stack.m_41619_()) {
                stack = stack.m_41777_();
            }
            return super.insertItem(slot, stack, simulate);
        }

        public int getSlots() {
            return super.getSlots() - 5;
        }
    }
}

