/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.inventory;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;
import vazkii.quark.content.experimental.module.EnchantmentsBegoneModule;

public class EnchantmentMatrix {
    public static final int MATRIX_WIDTH = 5;
    public static final int MATRIX_HEIGHT = 5;
    private static final int PIECE_VARIANTS = 8;
    private static final String TAG_PIECES = "pieces";
    private static final String TAG_PIECE_ID = "id";
    private static final String TAG_BENCHED_PIECES = "benchedPieces";
    private static final String TAG_PLACED_PIECES = "placedPieces";
    private static final String TAG_COUNT = "count";
    private static final String TAG_TYPE_COUNT = "typeCount";
    public final Map<Enchantment, Integer> totalValue = new HashMap<Enchantment, Integer>();
    public final Map<Integer, Piece> pieces = new HashMap<Integer, Piece>();
    public List<Integer> benchedPieces = new ArrayList<Integer>();
    public List<Integer> placedPieces = new ArrayList<Integer>();
    public int[][] matrix;
    public int count;
    public int typeCount;
    public final boolean book;
    public final ItemStack target;
    public final Random rng;

    public EnchantmentMatrix(ItemStack target, Random rng) {
        this.target = target;
        this.rng = rng;
        this.book = target.m_41720_() == Items.f_42517_;
        this.computeMatrix();
    }

    public boolean canGeneratePiece(int bookshelfPower, int enchantability) {
        int enchantabilityCount;
        if (enchantability == 0) {
            return false;
        }
        if (this.book) {
            if (!MatrixEnchantingModule.allowBooks) {
                return false;
            }
            int bookshelfCount = Math.max(0, Math.min(bookshelfPower - 1, MatrixEnchantingModule.maxBookshelves)) / 7;
            int maxCount = MatrixEnchantingModule.baseMaxPieceCountBook + bookshelfCount;
            return this.count < maxCount;
        }
        int bookshelfCount = Math.min(bookshelfPower, MatrixEnchantingModule.maxBookshelves);
        int maxCount = MatrixEnchantingModule.baseMaxPieceCount + (bookshelfCount + 1) / 2 + (enchantabilityCount = Math.round((float)enchantability * ((float)bookshelfCount / (float)MatrixEnchantingModule.maxBookshelves))) / 2;
        return this.count < maxCount;
    }

    public boolean validateXp(Player player, int bookshelfPower) {
        return player.m_150110_().f_35937_ || player.f_36078_ >= this.getMinXpLevel(bookshelfPower) && player.f_36078_ >= this.getNewPiecePrice();
    }

    public int getMinXpLevel(int bookshelfPower) {
        float scale = (float)MatrixEnchantingModule.minLevelScaleFactor;
        int cutoff = MatrixEnchantingModule.minLevelCutoff;
        if (this.book) {
            return (int)((double)Math.min(bookshelfPower, MatrixEnchantingModule.maxBookshelves) * MatrixEnchantingModule.minLevelScaleFactorBook);
        }
        return this.count > cutoff ? (int)((float)cutoff * scale) - cutoff + this.count : (int)((float)this.count * scale);
    }

    public int getNewPiecePrice() {
        return 1 + (MatrixEnchantingModule.piecePriceScale == 0 ? 0 : this.count / MatrixEnchantingModule.piecePriceScale);
    }

    public boolean generatePiece(Map<Enchantment, Integer> influences, int bookshelfPower) {
        EnchantmentDataWrapper data = this.generateRandomEnchantment(influences, bookshelfPower);
        if (data == null) {
            return false;
        }
        int type = -1;
        for (Piece p : this.pieces.values()) {
            if (p.enchant != data.f_44947_) continue;
            type = p.type;
        }
        if (type == -1) {
            type = this.typeCount % 8;
            ++this.typeCount;
        }
        Piece piece = new Piece(data, type);
        piece.generateBlocks();
        this.pieces.put(this.count, piece);
        this.totalValue.put(piece.enchant, this.totalValue.getOrDefault(piece.enchant, 0) + piece.getValue());
        this.benchedPieces.add(this.count);
        ++this.count;
        if (this.book && this.count == 1) {
            for (int i = 0; i < 2; ++i) {
                if (!this.rng.nextBoolean()) continue;
                ++this.count;
            }
        }
        return true;
    }

    private EnchantmentDataWrapper generateRandomEnchantment(Map<Enchantment, Integer> influences, int bookshelfPower) {
        int level = this.book ? MatrixEnchantingModule.bookEnchantability + this.rng.nextInt(Math.max(1, bookshelfPower) * 2) : 0;
        List marked = this.pieces.values().stream().filter(p -> p.marked).collect(Collectors.toList());
        ArrayList validEnchants = new ArrayList();
        ForgeRegistries.ENCHANTMENTS.forEach(enchantment -> {
            if ((!enchantment.m_6591_() || MatrixEnchantingModule.allowTreasures) && !EnchantmentsBegoneModule.shouldBegone(enchantment) && !MatrixEnchantingModule.disallowedEnchantments.contains(Objects.toString(enchantment.getRegistryName())) && (enchantment.canApplyAtEnchantingTable(this.target) || this.book && enchantment.isAllowedOnBooks())) {
                int currentValue;
                int valueAdded;
                int enchantLevel = 1;
                if (this.book) {
                    for (int i = enchantment.m_6586_(); i > enchantment.m_44702_() - 1; --i) {
                        if (level < enchantment.m_6183_(i) || level > enchantment.m_6175_(i)) continue;
                        enchantLevel = i;
                        break;
                    }
                }
                if ((valueAdded = EnchantmentMatrix.getValue(enchantment, enchantLevel)) + (currentValue = this.totalValue.getOrDefault(enchantment, 0).intValue()) > EnchantmentMatrix.getValue(enchantment, enchantment.m_6586_()) + EnchantmentMatrix.getMaxXP(enchantment, enchantment.m_6586_())) {
                    return;
                }
                EnchantmentDataWrapper wrapper = new EnchantmentDataWrapper((Enchantment)enchantment, enchantLevel);
                wrapper.normalizeRarity(influences, marked);
                validEnchants.add(wrapper);
            }
        });
        if (validEnchants.isEmpty()) {
            return null;
        }
        int total = 0;
        for (EnchantmentDataWrapper wrapper : validEnchants) {
            total += wrapper.mutableWeight.val;
        }
        if (total == 0) {
            for (EnchantmentDataWrapper wrapper : validEnchants) {
                ++wrapper.mutableWeight.val;
            }
        }
        return WeightedRandom.m_146317_((Random)this.rng, validEnchants).orElse(null);
    }

    public boolean place(int id, int x, int y) {
        Piece p = this.pieces.get(id);
        if (p != null && this.benchedPieces.contains(id) && this.canPlace(p, x, y)) {
            p.x = x;
            p.y = y;
            this.benchedPieces.remove((Object)id);
            this.placedPieces.add(id);
            this.computeMatrix();
            return true;
        }
        return false;
    }

    public boolean remove(int id) {
        Piece p = this.pieces.get(id);
        if (p != null && this.placedPieces.contains(id)) {
            this.placedPieces.remove((Object)id);
            this.benchedPieces.add(id);
            this.computeMatrix();
            return true;
        }
        return false;
    }

    public boolean rotate(int id) {
        Piece p = this.pieces.get(id);
        if (p != null && this.benchedPieces.contains(id)) {
            p.rotate();
            return true;
        }
        return false;
    }

    public boolean merge(int placed, int hover) {
        Enchantment enchant;
        Piece placedPiece = this.pieces.get(placed);
        Piece hoveredPiece = this.pieces.get(hover);
        if (placedPiece != null && hoveredPiece != null && this.placedPieces.contains(placed) && this.benchedPieces.contains(hover) && hoveredPiece.enchant == (enchant = placedPiece.enchant) && placedPiece.level < enchant.m_6586_()) {
            placedPiece.xp += hoveredPiece.getValue();
            int max = placedPiece.getMaxXP();
            while (placedPiece.xp >= max && placedPiece.level < enchant.m_6586_()) {
                ++placedPiece.level;
                placedPiece.xp -= max;
                max = placedPiece.getMaxXP();
            }
            if (hoveredPiece.marked) {
                placedPiece.marked = true;
            }
            this.benchedPieces.remove((Object)hover);
            this.pieces.remove(hover);
            return true;
        }
        return false;
    }

    public void writeToNBT(CompoundTag cmp) {
        ListTag list = new ListTag();
        for (Integer i : this.pieces.keySet()) {
            CompoundTag pieceTag = new CompoundTag();
            pieceTag.m_128405_(TAG_PIECE_ID, i.intValue());
            if (this.pieces.get((Object)i).enchant == null) continue;
            this.pieces.get(i).writeToNBT(pieceTag);
            list.add((Object)pieceTag);
        }
        cmp.m_128365_(TAG_PIECES, (Tag)list);
        cmp.m_128385_(TAG_BENCHED_PIECES, this.packList(this.benchedPieces));
        cmp.m_128385_(TAG_PLACED_PIECES, this.packList(this.placedPieces));
        cmp.m_128405_(TAG_COUNT, this.count);
        cmp.m_128405_(TAG_TYPE_COUNT, this.typeCount);
    }

    public void readFromNBT(CompoundTag cmp) {
        this.pieces.clear();
        this.totalValue.clear();
        ListTag plist = cmp.m_128437_(TAG_PIECES, (int)cmp.m_7060_());
        for (int i = 0; i < plist.size(); ++i) {
            CompoundTag pieceTag = plist.m_128728_(i);
            int id = pieceTag.m_128451_(TAG_PIECE_ID);
            Piece piece = new Piece();
            piece.readFromNBT(pieceTag);
            this.pieces.put(id, piece);
            this.totalValue.put(piece.enchant, this.totalValue.getOrDefault(piece.enchant, 0) + piece.getValue());
        }
        this.benchedPieces = this.unpackList(cmp.m_128465_(TAG_BENCHED_PIECES));
        this.placedPieces = this.unpackList(cmp.m_128465_(TAG_PLACED_PIECES));
        this.count = cmp.m_128451_(TAG_COUNT);
        this.typeCount = cmp.m_128451_(TAG_TYPE_COUNT);
        this.computeMatrix();
    }

    private void computeMatrix() {
        this.matrix = new int[5][5];
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.matrix[i][j] = -1;
            }
        }
        for (Integer i : this.placedPieces) {
            Piece p = this.pieces.get(i);
            for (int[] b : p.blocks) {
                this.matrix[p.x + b[0]][p.y + b[1]] = i;
            }
        }
    }

    public boolean canPlace(Piece p, int x, int y) {
        for (int[] b : p.blocks) {
            int bx = b[0] + x;
            int by = b[1] + y;
            if (bx < 0 || by < 0 || bx >= 5 || by >= 5) {
                return false;
            }
            if (this.matrix[bx][by] == -1) continue;
            return false;
        }
        return true;
    }

    private int[] packList(List<Integer> list) {
        int[] arr = new int[list.size()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = list.get(i);
        }
        return arr;
    }

    private List<Integer> unpackList(int[] arr) {
        ArrayList<Integer> list = new ArrayList<Integer>(arr.length);
        for (int anArr : arr) {
            list.add(anArr);
        }
        return list;
    }

    public static int getMaxXP(Enchantment enchantment, int level) {
        if (level >= enchantment.m_6586_()) {
            return 0;
        }
        return switch (enchantment.m_44699_()) {
            case Enchantment.Rarity.COMMON -> level;
            case Enchantment.Rarity.UNCOMMON -> level / 2 + 1;
            default -> 1;
        };
    }

    public static int getValue(Enchantment enchantment, int level) {
        int total = 1;
        for (int i = 1; i < level; ++i) {
            total += EnchantmentMatrix.getMaxXP(enchantment, i);
        }
        return total;
    }

    private static class EnchantmentDataWrapper
    extends EnchantmentInstance {
        private boolean marked;
        private int influence;
        private final MutableWeight mutableWeight;

        public EnchantmentDataWrapper(Enchantment enchantmentObj, int enchLevel) {
            super(enchantmentObj, enchLevel);
            this.mutableWeight = new MutableWeight(this.f_44947_.m_44699_().m_44716_());
        }

        public void normalizeRarity(Map<Enchantment, Integer> influences, List<Piece> markedEnchants) {
            if (MatrixEnchantingModule.normalizeRarity) {
                switch (this.f_44947_.m_44699_()) {
                    case COMMON: {
                        this.mutableWeight.val = 80000;
                        break;
                    }
                    case UNCOMMON: {
                        this.mutableWeight.val = 40000;
                        break;
                    }
                    case RARE: {
                        this.mutableWeight.val = 25000;
                        break;
                    }
                    case VERY_RARE: {
                        this.mutableWeight.val = 5000;
                        break;
                    }
                }
                this.influence = influences.getOrDefault(this.f_44947_, 0);
                float multiplier = 1.0f + (float)this.influence * (float)MatrixEnchantingModule.influencePower;
                this.mutableWeight.val = (int)((float)this.mutableWeight.val * multiplier);
                boolean mark = true;
                for (Piece other : markedEnchants) {
                    if (other.enchant == this.f_44947_) {
                        this.mutableWeight.val = (int)((double)this.mutableWeight.val * MatrixEnchantingModule.dupeMultiplier);
                        mark = false;
                        break;
                    }
                    if (other.enchant.m_44695_(this.f_44947_) && this.f_44947_.m_44695_(other.enchant)) continue;
                    this.mutableWeight.val = (int)((double)this.mutableWeight.val * MatrixEnchantingModule.incompatibleMultiplier);
                    mark = false;
                    break;
                }
                if (mark) {
                    this.marked = true;
                }
            }
        }

        @Nonnull
        public Weight m_142631_() {
            return this.mutableWeight;
        }
    }

    public static class Piece {
        private static final int[][][] PIECE_TYPES = new int[][][]{new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {0, -1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {0, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {-1, 1}, {1, -1}}, new int[][]{{0, 0}, {-1, 0}, {0, -1}, {-1, -1}, {-1, 1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {-1, -1}, {1, -1}, {1, 1}}, new int[][]{{0, 0}, {-1, 0}, {1, 0}, {0, -1}, {-1, -1}, {1, 1}}};
        private static final String TAG_COLOR = "color";
        private static final String TAG_TYPE = "type";
        private static final String TAG_ENCHANTMENT = "enchant";
        private static final String TAG_LEVEL = "level";
        private static final String TAG_BLOCK_COUNT = "blockCount";
        private static final String TAG_BLOCK = "block";
        private static final String TAG_X = "x";
        private static final String TAG_Y = "y";
        private static final String TAG_XP = "xp";
        private static final String TAG_MARKED = "marked";
        private static final String TAG_INFLUENCE = "influence";
        public Enchantment enchant;
        public int level;
        public int color;
        public int type;
        public int x;
        public int y;
        public int xp;
        public int[][] blocks;
        public boolean marked;
        public int influence;

        public Piece() {
        }

        public Piece(EnchantmentDataWrapper wrapper, int type) {
            this.enchant = wrapper.f_44947_;
            this.level = wrapper.f_44948_;
            this.marked = wrapper.marked;
            this.influence = wrapper.influence;
            this.type = type;
            Random rng = new Random(Objects.toString(this.enchant.getRegistryName()).hashCode());
            float h = rng.nextFloat();
            float s = rng.nextFloat() * 0.2f + 0.8f;
            float b = rng.nextFloat() * 0.25f + 0.75f;
            this.color = Color.HSBtoRGB(h, s, b);
        }

        public void generateBlocks() {
            int type = (int)(Math.random() * (double)PIECE_TYPES.length);
            int[][] copyPieces = PIECE_TYPES[type];
            this.blocks = new int[copyPieces.length][2];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i][0] = copyPieces[i][0];
                this.blocks[i][1] = copyPieces[i][1];
            }
            int rotations = (int)(Math.random() * 4.0);
            for (int i = 0; i < rotations; ++i) {
                this.rotate();
            }
        }

        public void rotate() {
            for (int[] b : this.blocks) {
                int y;
                int x = b[0];
                b[0] = y = b[1];
                b[1] = -x;
            }
        }

        public int getMaxXP() {
            return EnchantmentMatrix.getMaxXP(this.enchant, this.level);
        }

        public int getValue() {
            return EnchantmentMatrix.getValue(this.enchant, this.level) + this.xp;
        }

        public void writeToNBT(CompoundTag cmp) {
            cmp.m_128405_(TAG_COLOR, this.color);
            cmp.m_128405_(TAG_TYPE, this.type);
            if (this.enchant != null) {
                cmp.m_128359_(TAG_ENCHANTMENT, Objects.toString(this.enchant.getRegistryName()));
            }
            cmp.m_128405_(TAG_LEVEL, this.level);
            cmp.m_128405_(TAG_X, this.x);
            cmp.m_128405_(TAG_Y, this.y);
            cmp.m_128405_(TAG_XP, this.xp);
            cmp.m_128379_(TAG_MARKED, this.marked);
            cmp.m_128405_(TAG_INFLUENCE, this.influence);
            cmp.m_128405_(TAG_BLOCK_COUNT, this.blocks.length);
            for (int i = 0; i < this.blocks.length; ++i) {
                cmp.m_128385_(TAG_BLOCK + i, this.blocks[i]);
            }
        }

        public void readFromNBT(CompoundTag cmp) {
            this.color = cmp.m_128451_(TAG_COLOR);
            this.type = cmp.m_128451_(TAG_TYPE);
            this.enchant = (Enchantment)Registry.f_122825_.m_7745_(new ResourceLocation(cmp.m_128461_(TAG_ENCHANTMENT)));
            this.level = cmp.m_128451_(TAG_LEVEL);
            this.x = cmp.m_128451_(TAG_X);
            this.y = cmp.m_128451_(TAG_Y);
            this.xp = cmp.m_128451_(TAG_XP);
            this.marked = cmp.m_128471_(TAG_MARKED);
            this.influence = cmp.m_128451_(TAG_INFLUENCE);
            this.blocks = new int[cmp.m_128451_(TAG_BLOCK_COUNT)][2];
            for (int i = 0; i < this.blocks.length; ++i) {
                this.blocks[i] = cmp.m_128465_(TAG_BLOCK + i);
            }
        }
    }

    private static class MutableWeight
    extends Weight {
        protected int val;

        public MutableWeight(int val) {
            super(val);
        }

        public int m_146281_() {
            return this.val;
        }
    }
}

