/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block;

import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vazkii.quark.addons.oddities.block.be.PipeBlockEntity;
import vazkii.quark.addons.oddities.module.PipesModule;
import vazkii.quark.base.block.QuarkBlock;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.module.QuarkModule;

public class PipeBlock
extends QuarkBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final VoxelShape CENTER_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.0, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape UP_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)1.0, (double)0.6875);
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.0, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)1.0);
    private static final VoxelShape WEST_SHAPE = Shapes.m_83048_((double)0.0, (double)0.3125, (double)0.3125, (double)0.6875, (double)0.6875, (double)0.6875);
    private static final VoxelShape EAST_SHAPE = Shapes.m_83048_((double)0.3125, (double)0.3125, (double)0.3125, (double)1.0, (double)0.6875, (double)0.6875);
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BooleanProperty[] CONNECTIONS = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final VoxelShape[] SIDE_BOXES = new VoxelShape[]{DOWN_SHAPE, UP_SHAPE, NORTH_SHAPE, SOUTH_SHAPE, WEST_SHAPE, EAST_SHAPE};
    private static final VoxelShape[] shapeCache = new VoxelShape[64];

    public PipeBlock(QuarkModule module) {
        super("pipe", module, CreativeModeTab.f_40751_, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(3.0f, 10.0f).m_60918_(SoundType.f_56744_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        RenderLayerHandler.setRenderType((Block)this, RenderLayerHandler.RenderTypeSkeleton.CUTOUT);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand handIn, @Nonnull BlockHitResult hit) {
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41720_() == Items.f_42398_) {
            HashSet found = new HashSet();
            boolean fixedAny = false;
            HashSet<BlockPos> candidates = new HashSet<BlockPos>();
            HashSet<BlockPos> newCandidates = new HashSet<BlockPos>();
            candidates.add(pos);
            do {
                for (BlockPos cand : candidates) {
                    for (Direction d : Direction.values()) {
                        BlockPos offPos = cand.m_142300_(d);
                        BlockState offState = worldIn.m_8055_(offPos);
                        if (offState.m_60734_() != this || candidates.contains(offPos) || found.contains(offPos)) continue;
                        newCandidates.add(offPos);
                    }
                    BlockState curr = worldIn.m_8055_(cand);
                    BlockState target = this.getTargetState(worldIn, cand, (Boolean)curr.m_61143_((Property)WATERLOGGED));
                    if (target.equals(curr)) continue;
                    fixedAny = true;
                    worldIn.m_7731_(cand, target, 6);
                }
                found.addAll(candidates);
                candidates = newCandidates;
                newCandidates = new HashSet();
            } while (!candidates.isEmpty());
            if (fixedAny) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public void m_6861_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        BlockState targetState = this.getTargetState(worldIn, pos, (Boolean)state.m_61143_((Property)WATERLOGGED));
        if (!targetState.equals(state)) {
            worldIn.m_7731_(pos, targetState, 6);
        }
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getTargetState(context.m_43725_(), context.m_8083_(), context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_);
    }

    private BlockState getTargetState(Level worldIn, BlockPos pos, boolean waterlog) {
        BlockState newState = this.m_49966_();
        newState = (BlockState)newState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlog));
        for (Direction facing : Direction.values()) {
            BooleanProperty prop = CONNECTIONS[facing.ordinal()];
            PipeBlockEntity.ConnectionType type = PipeBlockEntity.getConnectionTo((BlockGetter)worldIn, pos, facing);
            newState = (BlockState)newState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(type.isSolid));
        }
        return newState;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        int index = 0;
        for (Direction dir : Direction.values()) {
            int ord = dir.ordinal();
            if (!((Boolean)state.m_61143_((Property)CONNECTIONS[ord])).booleanValue()) continue;
            index += 1 << ord;
        }
        VoxelShape cached = shapeCache[index];
        if (cached == null) {
            VoxelShape currShape = CENTER_SHAPE;
            for (Direction dir : Direction.values()) {
                boolean connected = PipeBlock.isConnected(state, dir);
                if (!connected) continue;
                currShape = Shapes.m_83110_((VoxelShape)currShape, (VoxelShape)SIDE_BOXES[dir.ordinal()]);
            }
            PipeBlock.shapeCache[index] = currShape;
            cached = currShape;
        }
        return cached;
    }

    public static boolean isConnected(BlockState state, Direction side) {
        BooleanProperty prop = CONNECTIONS[side.ordinal()];
        return (Boolean)state.m_61143_((Property)prop);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, WEST, EAST, WATERLOGGED});
    }

    public boolean m_7278_(@Nonnull BlockState state) {
        return true;
    }

    public int m_6782_(@Nonnull BlockState blockState, Level worldIn, @Nonnull BlockPos pos) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof PipeBlockEntity) {
            return ((PipeBlockEntity)tile).getComparatorOutput();
        }
        return 0;
    }

    public void m_6810_(@Nonnull BlockState state, Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        BlockEntity tileentity = worldIn.m_7702_(pos);
        if (tileentity instanceof PipeBlockEntity) {
            ((PipeBlockEntity)tileentity).dropAllItems();
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return PipeBlock.createTickerHelper(type, PipesModule.blockEntityType, PipeBlockEntity::tick);
    }
}

