/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common;

import dev.architectury.event.CompoundEventResult;
import dev.architectury.hooks.fluid.FluidStackHooks;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.injectables.annotations.PlatformOnly;
import dev.architectury.platform.Platform;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.EntryComparator;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.simple.RecipeBookGridMenuInfo;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleMenuInfoProvider;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidationScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultOxidizingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultTillingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxScrapingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultWaxingDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.forge.DefaultPluginImpl;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class DefaultPlugin
implements BuiltinPlugin,
REIServerPlugin {
    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        EntryComparator<Tag> nbtHasher = EntryComparator.nbt(new String[0]);
        Function<ItemStack, ListTag> enchantmentTag = stack -> {
            CompoundTag tag = stack.m_41783_();
            if (tag == null) {
                return null;
            }
            if (!tag.m_128425_("Enchantments", 9)) {
                if (tag.m_128425_("StoredEnchantments", 9)) {
                    return tag.m_128437_("StoredEnchantments", 10);
                }
                return null;
            }
            return tag.m_128437_("Enchantments", 10);
        };
        registry.register((context, stack) -> nbtHasher.hash(context, (Tag)enchantmentTag.apply((ItemStack)stack)), Items.f_42690_);
        registry.registerNbt(Items.f_42589_);
        registry.registerNbt(Items.f_42736_);
        registry.registerNbt(Items.f_42739_);
        registry.registerNbt(Items.f_42738_);
    }

    @Override
    public void registerFluidSupport(FluidSupportProvider support) {
        support.register(entry -> {
            BucketItem bucketItem;
            Fluid fluid;
            ItemStack stack = (ItemStack)entry.getValue();
            Item item = stack.m_41720_();
            if (item instanceof BucketItem && (fluid = DefaultPlugin.getFluidFromBucket(bucketItem = (BucketItem)item)) != null) {
                return CompoundEventResult.interruptTrue(Stream.of(EntryStacks.of(fluid, FluidStackHooks.bucketAmount())));
            }
            return CompoundEventResult.pass();
        });
        if (Platform.isForge()) {
            DefaultPlugin.registerForgeFluidSupport(support);
        }
    }

    @ExpectPlatform
    @PlatformOnly(value={"forge"})
    @ExpectPlatform.Transformed
    private static void registerForgeFluidSupport(FluidSupportProvider support) {
        DefaultPluginImpl.registerForgeFluidSupport(support);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Fluid getFluidFromBucket(BucketItem item) {
        return DefaultPluginImpl.getFluidFromBucket(item);
    }

    @Override
    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(CRAFTING, DefaultCraftingDisplay.serializer());
        registry.register(SMELTING, DefaultCookingDisplay.serializer(DefaultSmeltingDisplay::new));
        registry.register(SMOKING, DefaultCookingDisplay.serializer(DefaultSmokingDisplay::new));
        registry.register(BLASTING, DefaultCookingDisplay.serializer(DefaultBlastingDisplay::new));
        registry.register(CAMPFIRE, DefaultCampfireDisplay.serializer());
        registry.register(STONE_CUTTING, DefaultStoneCuttingDisplay.serializer());
        registry.register(STRIPPING, DefaultStrippingDisplay.serializer());
        registry.register(BREWING, DefaultBrewingDisplay.serializer());
        registry.register(COMPOSTING, DefaultCompostingDisplay.serializer());
        registry.register(FUEL, DefaultFuelDisplay.serializer());
        registry.register(SMITHING, DefaultSmithingDisplay.serializer());
        registry.register(BEACON_BASE, DefaultBeaconDisplay.serializer(DefaultBeaconBaseDisplay::new));
        registry.register(BEACON_PAYMENT, DefaultBeaconDisplay.serializer(DefaultBeaconPaymentDisplay::new));
        registry.register(TILLING, DefaultTillingDisplay.serializer());
        registry.register(PATHING, DefaultPathingDisplay.serializer());
        registry.register(WAXING, DefaultWaxingDisplay.serializer());
        registry.register(WAX_SCRAPING, DefaultWaxScrapingDisplay.serializer());
        registry.register(OXIDIZING, DefaultOxidizingDisplay.serializer());
        registry.register(OXIDATION_SCRAPING, DefaultOxidationScrapingDisplay.serializer());
        registry.register(INFO, DefaultInformationDisplay.serializer());
    }

    @Override
    public void registerMenuInfo(MenuInfoRegistry registry) {
        registry.register(BuiltinPlugin.CRAFTING, CraftingMenu.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.CRAFTING, InventoryMenu.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.SMELTING, FurnaceMenu.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.SMOKING, SmokerMenu.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
        registry.register(BuiltinPlugin.BLASTING, BlastFurnaceMenu.class, SimpleMenuInfoProvider.of(RecipeBookGridMenuInfo::new));
    }

    @Override
    public double getPriority() {
        return -100.0;
    }
}

