/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemEntryDefinition
implements EntryDefinition<ItemStack>,
EntrySerializer<ItemStack> {
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<ItemStack> renderer;
    private static final ReferenceSet<Item> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> Client.init(this));
    }

    @Override
    public Class<ItemStack> getValueType() {
        return ItemStack.class;
    }

    @Override
    public EntryType<ItemStack> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<ItemStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<ItemStack> entry, ItemStack value) {
        return Registry.f_122827_.m_7981_((Object)value.m_41720_());
    }

    @Override
    public boolean isEmpty(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41619_();
    }

    @Override
    public ItemStack copy(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41777_();
    }

    @Override
    public ItemStack normalize(EntryStack<ItemStack> entry, ItemStack value) {
        ItemStack copy = value.m_41777_();
        copy.m_41764_(1);
        return copy;
    }

    @Override
    public ItemStack wildcard(EntryStack<ItemStack> entry, ItemStack value) {
        return new ItemStack((ItemLike)value.m_41720_(), 1);
    }

    @Override
    @Nullable
    public ItemStack cheatsAs(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41777_();
    }

    @Override
    public long hash(EntryStack<ItemStack> entry, ItemStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.m_41720_());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(ItemStack o1, ItemStack o2, ComparisonContext context) {
        if (o1.m_41720_() != o2.m_41720_()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, o1) == ItemComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<ItemStack> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public CompoundTag save(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_41739_(new CompoundTag());
    }

    @Override
    public ItemStack read(CompoundTag tag) {
        return ItemStack.m_41712_((CompoundTag)tag);
    }

    @Override
    public Component asFormattedText(EntryStack<ItemStack> entry, ItemStack value) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.m_41720_())) {
            try {
                return value.m_41786_();
            }
            catch (Throwable e) {
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.m_41720_());
            }
        }
        try {
            return new ImmutableTextComponent(I18n.m_118938_((String)("item." + Registry.f_122827_.m_7981_((Object)value.m_41720_()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ImmutableTextComponent("ERROR");
        }
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<ItemStack> entry, ItemStack value) {
        return value.m_204131_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private List<Component> tryGetItemStackToolTip(EntryStack<ItemStack> entry, ItemStack value, TooltipContext context) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.m_41720_())) {
            try {
                return value.m_41651_((Player)Minecraft.m_91087_().f_91074_, context.getFlag());
            }
            catch (Throwable e) {
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.m_41720_());
            }
        }
        return Lists.newArrayList((Object[])new Component[]{this.asFormattedText(entry, value)});
    }

    @Override
    public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<ItemStack> entry) {
        EntryDefinition.super.fillCrashReport(report, category, entry);
        ItemStack stack = entry.getValue();
        category.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
        category.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
        category.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
        category.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        private static void init(ItemEntryDefinition definition) {
            definition.renderer = definition.new ItemEntryRenderer();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ItemEntryRenderer
    extends AbstractEntryRenderer<ItemStack>
    implements BatchedEntryRenderer<ItemStack, BakedModel> {
        private static final float SCALE = 20.0f;
        public static final int ITEM_LIGHT = 0xF000F0;

        @Override
        public BakedModel getExtraData(EntryStack<ItemStack> entry) {
            return Minecraft.m_91087_().m_91291_().m_174264_(entry.getValue(), null, null, 0);
        }

        @Override
        public void render(EntryStack<ItemStack> entry, PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            BakedModel model = this.getExtraData(entry);
            this.setupGL(entry, model);
            if (!entry.isEmpty()) {
                ItemStack value = entry.getValue();
                matrices.m_85836_();
                matrices.m_166854_(RenderSystem.m_157190_());
                matrices.m_85837_((double)bounds.getCenterX(), (double)bounds.getCenterY(), (double)entry.getZ());
                matrices.m_85841_((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, 1.0f);
                PoseStack modelViewStack = RenderSystem.m_157191_();
                modelViewStack.m_85836_();
                modelViewStack.m_85850_().m_85861_().m_162210_(matrices.m_85850_().m_85861_());
                RenderSystem.m_157182_();
                MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
                Minecraft.m_91087_().m_91291_().m_115143_(value, ItemTransforms.TransformType.GUI, false, new PoseStack(), (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.f_118083_, model);
                immediate.m_109911_();
                matrices.m_85849_();
                modelViewStack.m_85849_();
                RenderSystem.m_157182_();
            }
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_166854_(matrices.m_85850_().m_85861_());
            modelViewStack.m_85837_((double)bounds.x, (double)bounds.y, 0.0);
            modelViewStack.m_85841_((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            RenderSystem.m_157182_();
            this.renderOverlay(entry, bounds);
            modelViewStack.m_85849_();
            this.endGL(entry, model);
            RenderSystem.m_157182_();
        }

        @Override
        public int getBatchIdentifier(EntryStack<ItemStack> entry, Rectangle bounds, BakedModel model) {
            return 1738923 + (model.m_7547_() ? 1 : 0);
        }

        @Override
        public void startBatch(EntryStack<ItemStack> entry, BakedModel model, PoseStack matrices, float delta) {
            this.setupGL(entry, model);
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_85841_(20.0f, -20.0f, 1.0f);
            RenderSystem.m_157182_();
        }

        public void setupGL(EntryStack<ItemStack> entry, BakedModel model) {
            Minecraft.m_91087_().m_91097_().m_118506_(TextureAtlas.f_118259_).m_117960_(false, false);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean sideLit = model.m_7547_();
            if (!sideLit) {
                Lighting.m_84930_();
            }
        }

        @Override
        public void renderBase(EntryStack<ItemStack> entry, BakedModel model, PoseStack matrices, MultiBufferSource.BufferSource immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                ItemStack value = entry.getValue();
                matrices.m_85836_();
                matrices.m_85837_((double)((float)bounds.getCenterX() / 20.0f), (double)((float)bounds.getCenterY() / -20.0f), (double)entry.getZ());
                matrices.m_85841_((float)bounds.getWidth() / 20.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 20.0f, 1.0f);
                Minecraft.m_91087_().m_91291_().m_115143_(value, ItemTransforms.TransformType.GUI, false, matrices, (MultiBufferSource)immediate, 0xF000F0, OverlayTexture.f_118083_, model);
                matrices.m_85849_();
            }
        }

        @Override
        public void afterBase(EntryStack<ItemStack> entry, BakedModel model, PoseStack matrices, float delta) {
            this.endGL(entry, model);
            RenderSystem.m_157191_().m_85849_();
            RenderSystem.m_157182_();
        }

        @Override
        public void renderOverlay(EntryStack<ItemStack> entry, BakedModel model, PoseStack matrices, MultiBufferSource.BufferSource immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_166854_(matrices.m_85850_().m_85861_());
            modelViewStack.m_85837_((double)bounds.x, (double)bounds.y, 0.0);
            modelViewStack.m_85841_((float)bounds.width / 16.0f, (float)(bounds.getWidth() + bounds.getHeight()) / 2.0f / 16.0f, 1.0f);
            RenderSystem.m_157182_();
            this.renderOverlay(entry, bounds);
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
        }

        public void renderOverlay(EntryStack<ItemStack> entry, Rectangle bounds) {
            if (!entry.isEmpty()) {
                Minecraft.m_91087_().m_91291_().f_115093_ = entry.getZ();
                Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, entry.getValue(), 0, 0, null);
                Minecraft.m_91087_().m_91291_().f_115093_ = 0.0f;
            }
        }

        @Override
        public void endBatch(EntryStack<ItemStack> entry, BakedModel model, PoseStack matrices, float delta) {
        }

        public void endGL(EntryStack<ItemStack> entry, BakedModel model) {
            RenderSystem.m_69482_();
            boolean sideLit = model.m_7547_();
            if (!sideLit) {
                Lighting.m_84931_();
            }
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<ItemStack> entry, TooltipContext context) {
            if (entry.isEmpty()) {
                return null;
            }
            Tooltip tooltip = Tooltip.create(new Component[0]);
            Optional component = entry.getValue().m_150921_();
            List<Component> components = ItemEntryDefinition.this.tryGetItemStackToolTip(entry, entry.getValue(), context);
            if (!components.isEmpty()) {
                tooltip.add(components.get(0));
            }
            component.ifPresent(tooltip::add);
            for (int i = 1; i < components.size(); ++i) {
                tooltip.add(components.get(i));
            }
            return tooltip;
        }
    }
}

