/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories.beacon;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Slot;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class DefaultBeaconBaseCategory
implements DisplayCategory<DefaultBeaconBaseDisplay> {
    @Override
    public CategoryIdentifier<? extends DefaultBeaconBaseDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.BEACON_BASE;
    }

    @Override
    public Component getTitle() {
        return new TranslatableComponent("category.rei.beacon_base");
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)Blocks.f_50273_);
    }

    @Override
    public DisplayRenderer getDisplayRenderer(DefaultBeaconBaseDisplay display) {
        final Component name = this.getTitle();
        return new DisplayRenderer(){

            @Override
            public int getHeight() {
                Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
                return 10 + 9;
            }

            @Override
            public void render(PoseStack matrices, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                Minecraft.m_91087_().f_91062_.m_92889_(matrices, name, (float)(rectangle.x + 5), (float)(rectangle.y + 6), -1);
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(DefaultBeaconBaseDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 8, bounds.y + 3)).entry(EntryStacks.of((ItemLike)Blocks.f_50273_)));
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - bounds.width / 2 - 1, bounds.y + 23, bounds.width + 2, bounds.height - 28);
        widgets.add(Widgets.createSlotBase(rectangle));
        widgets.add(new ScrollableSlotsWidget(rectangle, CollectionUtils.map(display.getEntries(), t -> Widgets.createSlot(new Point(0, 0)).disableBackground().entry((EntryStack<?>)t))));
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }

    private static class ScrollableSlotsWidget
    extends WidgetWithBounds {
        private Rectangle bounds;
        private List<Slot> widgets;
        private final ScrollingContainer scrolling = new ScrollingContainer(){

            public Rectangle getBounds() {
                Rectangle bounds = this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }

            public int getMaxScrollHeight() {
                return Mth.m_14167_((float)((float)widgets.size() / 8.0f)) * 18;
            }
        };

        public ScrollableSlotsWidget(Rectangle bounds, List<Slot> widgets) {
            this.bounds = Objects.requireNonNull(bounds);
            this.widgets = Lists.newArrayList(widgets);
        }

        public boolean m_6050_(double double_1, double double_2, double double_3) {
            if (this.containsMouse(double_1, double_2)) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            this.scrolling.updatePosition(delta);
            Rectangle innerBounds = this.scrolling.getScissorBounds();
            ScissorsHandler.INSTANCE.scissor(innerBounds);
            block0: for (int y = 0; y < Mth.m_14167_((float)((float)this.widgets.size() / 8.0f)); ++y) {
                for (int x = 0; x < 8; ++x) {
                    int index = y * 8 + x;
                    if (this.widgets.size() <= index) continue block0;
                    Slot widget = this.widgets.get(index);
                    widget.getBounds().setLocation(this.bounds.x + 1 + x * 18, this.bounds.y + 1 + y * 18 - this.scrolling.scrollAmountInt());
                    widget.m_6305_(matrices, mouseX, mouseY, delta);
                }
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            ScissorsHandler.INSTANCE.scissor(this.scrolling.getBounds());
            this.scrolling.renderScrollBar(-16777216, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            ScissorsHandler.INSTANCE.removeLastScissor();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.widgets;
        }
    }
}

