/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.Collection;
import java.util.Locale;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.imitator.JEiColorGetterImitator;
import me.shedaniel.rei.jeicompat.wrap.JEIEntryDefinition;
import me.shedaniel.rei.jeicompat.wrap.JEISubtypeManager;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.ISubtypeManager;
import mezz.jei.api.registration.IModIngredientRegistration;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JEIModIngredientRegistration
implements IModIngredientRegistration {
    private final JEIPluginDetector.JEIPluginWrapper wrapper;
    private final EntryTypeRegistry registry;

    public JEIModIngredientRegistration(JEIPluginDetector.JEIPluginWrapper wrapper, EntryTypeRegistry registry) {
        this.wrapper = wrapper;
        this.registry = registry;
    }

    @Override
    @NotNull
    public ISubtypeManager getSubtypeManager() {
        return JEISubtypeManager.INSTANCE;
    }

    @Override
    @NotNull
    public IColorHelper getColorHelper() {
        return JEiColorGetterImitator.INSTANCE;
    }

    @Override
    public <V> void register(@NotNull IIngredientType<V> ingredientType, @NotNull Collection<V> allIngredients, @NotNull IIngredientHelper<V> ingredientHelper, @NotNull IIngredientRenderer<V> ingredientRenderer) {
        ResourceLocation location = new ResourceLocation(this.wrapper.backingPlugin.getPluginUid() + "_" + ingredientType.getIngredientClass().getSimpleName().toLowerCase(Locale.ROOT));
        this.registry.register(location, new JEIEntryDefinition(EntryType.deferred(location), ingredientType, ingredientHelper, ingredientRenderer));
        this.wrapper.entryRegistry.add(() -> EntryRegistry.getInstance().addEntries(CollectionUtils.map(allIngredients, JEIPluginDetector::unwrapStack)));
    }
}

