/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;

public class JEIEntryDefinition<T>
implements EntryDefinition<T> {
    private final EntryType<T> type;
    private final IIngredientType<T> ingredientType;
    private final IIngredientHelper<T> ingredientHelper;
    private final Renderer<T> renderer;

    public JEIEntryDefinition(EntryType<T> type, IIngredientType<T> ingredientType, IIngredientHelper<T> ingredientHelper, IIngredientRenderer<T> ingredientRenderer) {
        this.type = type;
        this.ingredientType = ingredientType;
        this.ingredientHelper = ingredientHelper;
        this.renderer = new Renderer<T>(ingredientRenderer);
    }

    @Override
    public Class<T> getValueType() {
        return this.ingredientType.getIngredientClass();
    }

    @Override
    public EntryType<T> getType() {
        return this.type;
    }

    @Override
    public EntryRenderer<T> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<T> entry, T value) {
        return this.ingredientHelper.getResourceLocation(value);
    }

    @Override
    @Nullable
    public String getContainingNamespace(EntryStack<T> entry, T value) {
        return this.ingredientHelper.getDisplayModId(value);
    }

    @Override
    public boolean isEmpty(EntryStack<T> entry, T value) {
        return !this.ingredientHelper.isValidIngredient(value);
    }

    @Override
    public T copy(EntryStack<T> entry, T value) {
        return this.ingredientHelper.copyIngredient(value);
    }

    @Override
    public T normalize(EntryStack<T> entry, T value) {
        return this.ingredientHelper.normalizeIngredient(value);
    }

    @Override
    public T wildcard(EntryStack<T> entry, T value) {
        return this.ingredientHelper.normalizeIngredient(value);
    }

    @Override
    public long hash(EntryStack<T> entry, T value, ComparisonContext context) {
        return JEIEntryDefinition.hashCode(this.ingredientHelper.getUniqueId(value, JEIPluginDetector.wrapContext(context)));
    }

    private static long hashCode(String id) {
        long h = 0L;
        for (int i = 0; i < id.length(); ++i) {
            h = 31L * h + (long)id.charAt(i);
        }
        return h;
    }

    @Override
    public boolean equals(T o1, T o2, ComparisonContext context) {
        return Objects.equals(this.ingredientHelper.getUniqueId(o1, JEIPluginDetector.wrapContext(context)), this.ingredientHelper.getUniqueId(o2, JEIPluginDetector.wrapContext(context)));
    }

    @Override
    @Nullable
    public EntrySerializer<T> getSerializer() {
        return null;
    }

    @Override
    public Component asFormattedText(EntryStack<T> entry, T value) {
        return new ImmutableTextComponent(this.ingredientHelper.getDisplayName(value));
    }

    @Override
    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<T> entry, T value) {
        ResourceKey key;
        if (value instanceof IForgeRegistryEntry) {
            Class type = ((IForgeRegistryEntry)value).getRegistryType();
            IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(type);
            key = ResourceKey.m_135788_((ResourceLocation)registry.getRegistryName());
        } else {
            key = null;
        }
        return this.ingredientHelper.getTags(value).stream().map(loc -> TagKey.m_203882_((ResourceKey)key, (ResourceLocation)loc));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Renderer<T>
    implements EntryRenderer<T> {
        private final IIngredientRenderer<T> ingredientRenderer;

        public Renderer(IIngredientRenderer<T> ingredientRenderer) {
            this.ingredientRenderer = ingredientRenderer;
        }

        @Override
        public void render(EntryStack<T> entry, PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            Object value = entry.getValue();
            if (value instanceof FluidStack) {
                value = FluidStackHooksForge.toForge((FluidStack)((FluidStack)value));
            }
            matrices.m_85836_();
            matrices.m_85837_((double)(bounds.getCenterX() - this.ingredientRenderer.getWidth() / 2), (double)(bounds.getCenterY() - this.ingredientRenderer.getHeight() / 2), 0.0);
            this.ingredientRenderer.render(matrices, value);
            matrices.m_85849_();
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<T> entry, Point mouse) {
            List<Component> components;
            Object value = entry.getValue();
            if (value instanceof FluidStack) {
                value = FluidStackHooksForge.toForge((FluidStack)((FluidStack)value));
            }
            if ((components = this.ingredientRenderer.getTooltip(value, (TooltipFlag)(Minecraft.m_91087_().f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL))) != null && !components.isEmpty()) {
                return Tooltip.create(mouse, components);
            }
            return null;
        }
    }
}

