/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.unwrap;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIIngredientRenderer<T>
implements IIngredientRenderer<T> {
    private final IIngredientType<T> type;
    private final EntryRenderer<T> renderer;

    public JEIIngredientRenderer(IIngredientType<T> type, EntryRenderer<T> renderer) {
        this.type = type;
        this.renderer = renderer;
    }

    @Override
    public void render(@NotNull PoseStack matrices, int xPosition, int yPosition, @Nullable T ingredient) {
        Point point = PointHelper.ofMouse();
        this.renderer.render(JEIPluginDetector.unwrapStack(ingredient, this.type), matrices, new Rectangle(xPosition, yPosition, 16, 16), point.x, point.y, Minecraft.m_91087_().m_91297_());
    }

    @Override
    @NotNull
    public List<Component> getTooltip(@NotNull T ingredient, @NotNull TooltipFlag tooltipFlag) {
        Tooltip tooltip = this.renderer.getTooltip(JEIPluginDetector.unwrapStack(ingredient, this.type), PointHelper.ofMouse());
        if (tooltip != null) {
            return CollectionUtils.filterAndMap(tooltip.entries(), Tooltip.Entry::isText, Tooltip.Entry::getAsText);
        }
        return new ArrayList<Component>();
    }
}

