/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.transfer;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JEIRecipeTransferData<C extends AbstractContainerMenu, R> {
    private final ResourceLocation recipeCategoryUid;
    private final List<Slot> recipeSlots;
    private final List<Slot> inventorySlots;
    private final boolean requireCompleteSets;

    public JEIRecipeTransferData(ResourceLocation recipeCategoryUid, List<Slot> recipeSlots, List<Slot> inventorySlots, boolean requireCompleteSets) {
        this.recipeCategoryUid = recipeCategoryUid;
        this.recipeSlots = recipeSlots;
        this.inventorySlots = inventorySlots;
        this.requireCompleteSets = requireCompleteSets;
    }

    @OnlyIn(value=Dist.CLIENT)
    public JEIRecipeTransferData(IRecipeTransferInfo<C, R> info, C container, R recipe) {
        this(info.getRecipeCategoryUid(), info.getRecipeSlots(container, recipe), info.getInventorySlots(container, recipe), info.requireCompleteSets(container, recipe));
    }

    public static <C extends AbstractContainerMenu, R> JEIRecipeTransferData<C, R> read(C menu, CompoundTag tag) {
        ResourceLocation recipeCategoryUid = ResourceLocation.m_135820_((String)tag.m_128461_("recipeCategoryUid"));
        List<Slot> recipeSlots = JEIRecipeTransferData.readSlots(menu, tag.m_128437_("recipeSlots", 10));
        List<Slot> inventorySlots = JEIRecipeTransferData.readSlots(menu, tag.m_128437_("inventorySlots", 10));
        boolean requireCompleteSets = tag.m_128471_("requireCompleteSets");
        return new JEIRecipeTransferData<C, R>(recipeCategoryUid, recipeSlots, inventorySlots, requireCompleteSets);
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("recipeCategoryUid", this.recipeCategoryUid.toString());
        tag.m_128365_("recipeSlots", (Tag)this.writeSlots(this.recipeSlots));
        tag.m_128365_("inventorySlots", (Tag)this.writeSlots(this.inventorySlots));
        tag.m_128379_("requireCompleteSets", this.requireCompleteSets);
        return tag;
    }

    public static <C extends AbstractContainerMenu> List<Slot> readSlots(C menu, ListTag tag) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (Tag entry : tag) {
            slots.add(menu.m_38853_(((CompoundTag)entry).m_128451_("Index")));
        }
        return slots;
    }

    public ListTag writeSlots(List<Slot> slots) {
        ListTag listTag = new ListTag();
        for (Slot slot : slots) {
            CompoundTag entry = new CompoundTag();
            entry.m_128405_("Index", slot.f_40219_);
            listTag.add((Object)entry);
        }
        return listTag;
    }

    public ResourceLocation getRecipeCategoryUid() {
        return this.recipeCategoryUid;
    }

    public List<Slot> getRecipeSlots() {
        return this.recipeSlots;
    }

    public List<Slot> getInventorySlots() {
        return this.inventorySlots;
    }

    public boolean isRequireCompleteSets() {
        return this.requireCompleteSets;
    }
}

