/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.util;

import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public enum Weather {
    CLEAR(0, "text.rei.weather.clear"),
    RAIN(1, "text.rei.weather.rain"),
    THUNDER(2, "text.rei.weather.thunder");

    private final int id;
    private final String translateKey;

    private Weather(int id, String translateKey) {
        this.id = id;
        this.translateKey = translateKey;
    }

    public static Weather byId(int id) {
        return Weather.byId(id, CLEAR);
    }

    public static Weather byId(int id, Weather defaultWeather) {
        for (Weather weather : Weather.values()) {
            if (weather.id != id) continue;
            return weather;
        }
        return defaultWeather;
    }

    public int getId() {
        return this.id;
    }

    public String getTranslateKey() {
        return this.translateKey;
    }
}

