/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.Objects;
import java.util.stream.Stream;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.config.SearchMode;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class TagArgumentType
extends ArgumentType<Unit, String[]> {
    public static final TagArgumentType INSTANCE = new TagArgumentType();
    private static final String[] EMPTY_ARRAY = new String[0];
    private static final Style STYLE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)10420212));

    @Override
    public String getName() {
        return "tag";
    }

    @Override
    @Nullable
    public String getPrefix() {
        return "$";
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public SearchMode getSearchMode() {
        return ConfigObject.getInstance().getTagSearchMode();
    }

    @Override
    public String[] cacheData(EntryStack<?> stack) {
        Stream<TagKey<?>> tags = stack.getTagsFor();
        return (String[])tags.map(TagArgumentType::toString).toArray(String[]::new);
    }

    @Override
    public boolean matches(String[] data, EntryStack<?> stack, String searchText, Unit filterData) {
        for (String tag : data) {
            if (tag.isEmpty() || !tag.contains(searchText)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Unit prepareSearchFilter(String searchText) {
        return Unit.INSTANCE;
    }

    private static String toString(TagKey<?> tagKey) {
        return Objects.toString(tagKey.f_203868_());
    }

    private TagArgumentType() {
    }
}

