/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.search.argument.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.search.argument.type.ArgumentType;
import me.shedaniel.rei.impl.client.search.result.ArgumentApplicableResult;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public final class RegexArgumentType
extends ArgumentType<Pattern, String> {
    public static final RegexArgumentType INSTANCE = new RegexArgumentType();
    private static final String EMPTY = "";
    private static final Style STYLE = Style.f_131099_.m_131148_(TextColor.m_131266_((int)12582824));

    @Override
    public String getName() {
        return "regex";
    }

    @Override
    public ArgumentApplicableResult checkApplicable(String text, boolean forceGrammar) {
        boolean inverted = false;
        String matchText = text;
        if (matchText.startsWith("-")) {
            inverted = true;
            matchText = matchText.substring(1);
        }
        if (matchText.length() >= 3 && matchText.startsWith("r/") && matchText.endsWith("/")) {
            return ArgumentApplicableResult.result(matchText.substring(2, matchText.length() - 1), true, inverted).grammar(0, inverted ? 3 : 2).grammar(text.length() - 1, text.length());
        }
        return ArgumentApplicableResult.notApplicable();
    }

    @Override
    @Nullable
    public Pattern prepareSearchFilter(String searchText) {
        try {
            return Pattern.compile(searchText);
        }
        catch (PatternSyntaxException ignored) {
            return null;
        }
    }

    @Override
    public Style getHighlightedStyle() {
        return STYLE;
    }

    @Override
    public String cacheData(EntryStack<?> stack) {
        return stack.asFormatStrippedText().getString();
    }

    @Override
    public boolean matches(String data, EntryStack<?> stack, String searchText, @Nullable Pattern filterData) {
        if (filterData == null) {
            return false;
        }
        Matcher matcher = filterData.matcher(data);
        return matcher != null && matcher.matches();
    }

    private RegexArgumentType() {
    }
}

