/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.registry.screen;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.platform.Window;
import dev.architectury.event.CompoundEventResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.config.DisplayPanelLocation;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProvider;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitor;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProvider;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitor;
import me.shedaniel.rei.api.client.gui.drag.component.DraggableComponentVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.screen.ClickArea;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.FocusedStackProvider;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.screen.SimpleClickArea;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.registry.screen.ExclusionZonesImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class ScreenRegistryImpl
implements ScreenRegistry {
    private Multimap<Class<? extends Screen>, ClickArea<?>> clickAreas = HashMultimap.create();
    private List<DraggableComponentProvider<Screen, Object>> draggableProviders = new ArrayList<DraggableComponentProvider<Screen, Object>>();
    private List<DraggableComponentVisitor<Screen>> draggableVisitors = new ArrayList<DraggableComponentVisitor<Screen>>();
    private List<FocusedStackProvider> focusedStackProviders = new ArrayList<FocusedStackProvider>();
    private List<OverlayDecider> deciders = new CopyOnWriteArrayList<OverlayDecider>();
    private Map<Class<?>, List<OverlayDecider>> cache = new HashMap();
    private ExclusionZones exclusionZones = new ExclusionZonesImpl();
    private Class<? extends Screen> tmpScreen;

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerScreens(this);
        plugin.registerExclusionZones(this.exclusionZones());
    }

    @Override
    public <R extends Screen> List<OverlayDecider> getDeciders(R screen) {
        if (screen == null) {
            return Collections.emptyList();
        }
        Class<?> screenClass = screen.getClass();
        List<OverlayDecider> possibleCached = this.cache.get(screenClass);
        if (possibleCached != null) {
            return possibleCached;
        }
        this.tmpScreen = screenClass;
        List<OverlayDecider> deciders = CollectionUtils.filterToList(this.deciders, this::filterResponsible);
        this.cache.put(screenClass, deciders);
        this.tmpScreen = null;
        return deciders;
    }

    private boolean filterResponsible(OverlayDecider handler) {
        return handler.isHandingScreen(this.tmpScreen);
    }

    @Override
    public List<OverlayDecider> getDeciders() {
        return Collections.unmodifiableList(this.deciders);
    }

    @Override
    public <T extends Screen> Rectangle getScreenBounds(T screen) {
        for (OverlayDecider decider : this.getDeciders(screen)) {
            Rectangle bounds;
            if (!(decider instanceof DisplayBoundsProvider) || (bounds = ((DisplayBoundsProvider)decider).getScreenBounds(screen)) == null) continue;
            return bounds;
        }
        return new Rectangle();
    }

    @Override
    public <T extends Screen> Rectangle getOverlayBounds(DisplayPanelLocation location, T screen) {
        Window window = Minecraft.m_91087_().m_91268_();
        int scaledWidth = window.m_85445_();
        int scaledHeight = window.m_85446_();
        Rectangle screenBounds = this.getScreenBounds(screen);
        if (screenBounds.isEmpty()) {
            return new Rectangle();
        }
        if (location == DisplayPanelLocation.LEFT) {
            if (screenBounds.x < 10) {
                return new Rectangle();
            }
            return new Rectangle(2, 0, screenBounds.x - 2, scaledHeight);
        }
        if (scaledWidth - screenBounds.getMaxX() < 10) {
            return new Rectangle();
        }
        return new Rectangle(screenBounds.getMaxX() + 2, 0, scaledWidth - screenBounds.getMaxX() - 4, scaledHeight);
    }

    @Override
    @Nullable
    public <T extends Screen> EntryStack<?> getFocusedStack(T screen, Point mouse) {
        for (FocusedStackProvider provider : this.focusedStackProviders) {
            CompoundEventResult<EntryStack<?>> result = Objects.requireNonNull(provider.provide(screen, mouse));
            if (result.isTrue()) {
                if (result != null && !((EntryStack)result.object()).isEmpty()) {
                    return (EntryStack)result.object();
                }
                return null;
            }
            if (!result.isFalse()) continue;
            return null;
        }
        return null;
    }

    @Override
    public void registerDecider(OverlayDecider decider) {
        this.deciders.add(decider);
        this.deciders.sort(Comparator.reverseOrder());
        this.cache.clear();
        this.tmpScreen = null;
        this.registerDraggableComponentProvider(DraggableComponentProviderWidget.from(context -> Widgets.walk(context.getScreen().m_6702_(), DraggableComponentProviderWidget.class::isInstance)));
        this.registerDraggableComponentVisitor(DraggableComponentVisitorWidget.from(context -> Widgets.walk(context.getScreen().m_6702_(), DraggableComponentVisitorWidget.class::isInstance)));
    }

    @Override
    public void registerFocusedStack(FocusedStackProvider provider) {
        this.focusedStackProviders.add(provider);
        this.focusedStackProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends Screen> void registerDraggableStackProvider(DraggableStackProvider<T> provider) {
        this.registerDraggableComponentProvider(provider);
    }

    @Override
    public <T extends Screen> void registerDraggableStackVisitor(DraggableStackVisitor<T> visitor) {
        this.registerDraggableComponentVisitor(visitor);
    }

    @Override
    public <T extends Screen, A> void registerDraggableComponentProvider(DraggableComponentProvider<T, A> provider) {
        this.draggableProviders.add(provider);
        this.draggableProviders.sort(Comparator.reverseOrder());
    }

    @Override
    public <T extends Screen> void registerDraggableComponentVisitor(DraggableComponentVisitor<T> visitor) {
        this.draggableVisitors.add(visitor);
        this.draggableVisitors.sort(Comparator.reverseOrder());
    }

    @Override
    public Iterable<DraggableStackProvider<Screen>> getDraggableProviders() {
        return Iterables.filter(Collections.unmodifiableList(this.draggableProviders), DraggableStackVisitor.class);
    }

    @Override
    public Iterable<DraggableStackVisitor<Screen>> getDraggableVisitors() {
        return Iterables.filter(Collections.unmodifiableList(this.draggableVisitors), DraggableStackVisitor.class);
    }

    @Override
    public Iterable<DraggableComponentProvider<Screen, Object>> getDraggableComponentProviders() {
        return Collections.unmodifiableList(this.draggableProviders);
    }

    @Override
    public Iterable<DraggableComponentVisitor<Screen>> getDraggableComponentVisitors() {
        return Collections.unmodifiableList(this.draggableVisitors);
    }

    @Override
    public ExclusionZones exclusionZones() {
        return this.exclusionZones;
    }

    @Override
    public <C extends AbstractContainerMenu, T extends AbstractContainerScreen<C>> void registerContainerClickArea(SimpleClickArea<T> area, Class<? extends T> screenClass, CategoryIdentifier<?> ... categories) {
        this.registerClickArea(screen -> {
            Rectangle rectangle = area.provide(screen).clone();
            rectangle.translate(screen.f_97735_, screen.f_97736_);
            return rectangle;
        }, screenClass, categories);
    }

    @Override
    public <T extends Screen> void registerClickArea(Class<? extends T> screenClass, ClickArea<T> area) {
        this.clickAreas.put(screenClass, area);
    }

    @Override
    public <T extends Screen> List<ClickArea.Result> evaluateClickArea(Class<T> screenClass, ClickArea.ClickAreaContext<T> context) {
        ArrayList<ClickArea.Result> results = new ArrayList<ClickArea.Result>();
        for (ClickArea area : this.clickAreas.get(screenClass)) {
            ClickArea.Result result = area.handle(context);
            if (!result.isSuccessful()) continue;
            results.add(result);
        }
        return results;
    }

    @Override
    public void startReload() {
        this.clickAreas.clear();
        this.deciders.clear();
        this.cache.clear();
        this.focusedStackProviders.clear();
        this.draggableProviders.clear();
        this.draggableVisitors.clear();
        this.tmpScreen = null;
        this.registerDefault();
    }

    private void registerDefault() {
        this.exclusionZones = new ExclusionZonesImpl();
        this.registerDecider(this.exclusionZones);
        this.registerDecider(new DisplayBoundsProvider<AbstractContainerScreen<?>>(){

            @Override
            public Rectangle getScreenBounds(AbstractContainerScreen<?> screen) {
                return new Rectangle(screen.f_97735_, screen.f_97736_, screen.f_97726_, screen.f_97727_);
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return AbstractContainerScreen.class.isAssignableFrom(screen);
            }

            @Override
            public <R extends Screen> InteractionResult shouldScreenBeOverlaid(R screen) {
                return screen instanceof AbstractContainerScreen ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
        this.registerDecider(new DisplayBoundsProvider<AbstractDisplayViewingScreen>(){

            @Override
            public Rectangle getScreenBounds(AbstractDisplayViewingScreen screen) {
                return screen.getBounds();
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return AbstractDisplayViewingScreen.class.isAssignableFrom(screen);
            }

            @Override
            public <R extends Screen> InteractionResult shouldScreenBeOverlaid(R screen) {
                return InteractionResult.SUCCESS;
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
        this.registerFocusedStack(new FocusedStackProvider(){

            @Override
            public CompoundEventResult<EntryStack<?>> provide(Screen screen, Point mouse) {
                if (screen instanceof AbstractContainerScreen) {
                    AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                    if (containerScreen.f_97734_ != null && !containerScreen.f_97734_.m_7993_().m_41619_()) {
                        return CompoundEventResult.interruptTrue(EntryStacks.of(containerScreen.f_97734_.m_7993_()));
                    }
                }
                return CompoundEventResult.pass();
            }

            @Override
            public double getPriority() {
                return -10.0;
            }
        });
    }
}

