/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.FloatingPoint;
import me.shedaniel.math.Point;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.gui.widget.DisplayedEntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListWidget;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.FavoritesPanel;
import me.shedaniel.rei.impl.client.gui.widget.favorites.panel.rows.FavoritesPanelRow;
import me.shedaniel.rei.impl.client.gui.widget.region.RealRegionEntry;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionDraggableStack;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FavoritesPanelEntriesRow
extends FavoritesPanelRow {
    private final FavoritesPanel panel;
    private final List<FavoriteEntry> entries;
    private final List<SectionFavoriteWidget> widgets;
    private int blockedCount;
    private int lastY;

    public FavoritesPanelEntriesRow(FavoritesPanel panel, List<FavoriteEntry> entries) {
        this.panel = panel;
        this.entries = entries;
        int entrySize = EntryListWidget.entrySize();
        this.widgets = CollectionUtils.map(this.entries, entry -> new SectionFavoriteWidget(new Point(0, 0), entrySize, (FavoriteEntry)entry));
        for (SectionFavoriteWidget widget2 : this.widgets) {
            widget2.size.setTo(entrySize * 100, 300L);
        }
        this.lastY = panel.getInnerBounds().y;
        this.updateEntriesPosition(widget -> false);
    }

    @Override
    public int getRowHeight() {
        return Mth.m_14167_((float)((float)(this.entries.size() + this.blockedCount) / ((float)this.panel.getInnerBounds().width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
    }

    @Override
    public void render(PoseStack matrices, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, float delta) {
        this.lastY = y;
        int entrySize = EntryListWidget.entrySize();
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        this.updateEntriesPosition(entry -> true);
        for (SectionFavoriteWidget widget : this.widgets) {
            widget.update(delta);
            if (widget.getBounds().getMaxY() <= this.lastY || widget.getBounds().getY() > this.lastY + rowHeight || widget.getCurrentEntry().isEmpty()) continue;
            widget.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.widgets;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY + this.panel.getScrolledAmount(), button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.m_7979_(mouseX, mouseY + this.panel.getScrolledAmount(), button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        return super.m_6348_(mouseX, mouseY + this.panel.getScrolledAmount(), button);
    }

    @Nullable
    public DraggableStack getHoveredStack(double mouseX, double mouseY) {
        for (SectionFavoriteWidget widget : this.widgets) {
            if (!widget.containsMouse(mouseX, mouseY + this.panel.getScrolledAmount())) continue;
            RealRegionEntry<FavoriteEntry> entry = new RealRegionEntry<FavoriteEntry>(this.panel.getParent().getRegion(), widget.entry.copy(), EntryListWidget.entrySize());
            entry.size.setAs(EntryListWidget.entrySize() * 100);
            return new RegionDraggableStack<FavoriteEntry>(entry, widget);
        }
        return null;
    }

    @Nullable
    public EntryStack<?> getFocusedStack(Point mouse) {
        for (SectionFavoriteWidget widget : this.widgets) {
            if (!widget.containsMouse(mouse)) continue;
            return ClientEntryStacks.of(widget.entry.getRenderer(false)).copy();
        }
        return null;
    }

    public void updateEntriesPosition(Predicate<SectionFavoriteWidget> animated) {
        int entrySize = EntryListWidget.entrySize();
        this.blockedCount = 0;
        int width = this.panel.getInnerBounds().width / entrySize;
        int currentX = 0;
        int currentY = 0;
        boolean slotIndex = false;
        block0: for (SectionFavoriteWidget widget : this.widgets) {
            while (true) {
                int xPos = currentX * entrySize + this.panel.getInnerBounds().x - 1;
                int yPos = currentY * entrySize;
                if (++currentX >= width) {
                    currentX = 0;
                    ++currentY;
                }
                if (EntryListWidget.notSteppingOnExclusionZones(xPos, yPos + this.lastY - this.panel.getScrolledAmountInt(), entrySize, entrySize)) {
                    widget.moveTo(animated.test(widget), xPos, yPos);
                    continue block0;
                }
                ++this.blockedCount;
            }
        }
    }

    private class SectionFavoriteWidget
    extends DisplayedEntryWidget {
        private ValueAnimator<FloatingPoint> pos;
        private NumberAnimator<Double> size;
        private FavoriteEntry entry;

        protected SectionFavoriteWidget(Point point, int entrySize, FavoriteEntry entry) {
            super(point, entrySize);
            this.pos = ValueAnimator.ofFloatingPoint();
            this.size = ValueAnimator.ofDouble();
            this.entry = entry;
            this.entry((EntryStack)ClientEntryStacks.of(entry.getRenderer(true)));
            this.noBackground();
        }

        public void moveTo(boolean animated, int xPos, int yPos) {
            this.pos.setTo((Object)new FloatingPoint((double)xPos, (double)yPos), animated ? 200L : -1L);
        }

        public void update(float delta) {
            this.pos.update((double)delta);
            this.size.update((double)delta);
            this.getBounds().width = this.getBounds().height = (int)Math.round(this.size.doubleValue() / 100.0);
            double offsetSize = ((double)EntryListWidget.entrySize() - this.size.doubleValue() / 100.0) / 2.0;
            this.getBounds().x = (int)Math.round(((FloatingPoint)this.pos.value()).x + offsetSize);
            this.getBounds().y = (int)Math.round(((FloatingPoint)this.pos.value()).y + offsetSize) + FavoritesPanelEntriesRow.this.lastY;
        }

        @Override
        @Nullable
        public Tooltip getCurrentTooltip(Point point) {
            point = PointHelper.ofMouse();
            if (!FavoritesPanelEntriesRow.this.panel.getInnerBounds().contains(point)) {
                return null;
            }
            Tooltip tooltip = super.getCurrentTooltip(point);
            if (tooltip != null) {
                tooltip.add((Component)ImmutableTextComponent.EMPTY);
                tooltip.add((Component)new TranslatableComponent("tooltip.rei.drag_to_add_favorites"));
            }
            return tooltip;
        }
    }
}

