/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.favorites.history;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector4f;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.clothconfig2.api.LazyResettable;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.math.Dimension;
import me.shedaniel.math.FloatingRectangle;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Button;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.widget.AutoCraftingEvaluator;
import me.shedaniel.rei.impl.client.gui.widget.favorites.history.DisplayHistoryWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class DisplayEntry
extends WidgetWithBounds {
    private final LazyResettable<List<Widget>> widgets = new LazyResettable(this::setupWidgets);
    private final DisplayHistoryWidget parent;
    private final Display display;
    private final Dimension size = new Dimension(1, 1);
    private final ValueAnimator<FloatingRectangle> bounds = ValueAnimator.ofFloatingRectangle();
    private final Button plusButton;
    private double xOffset = 0.0;
    private boolean reachedStable = false;

    public DisplayEntry(DisplayHistoryWidget parent, Display display, Rectangle initialBounds) {
        this.display = display;
        this.parent = parent;
        this.bounds.setAs((Object)initialBounds.getFloatingBounds());
        this.plusButton = Widgets.createButton(new Rectangle(initialBounds.getMaxX() - 16, initialBounds.getMaxY() - 16, 10, 10), (Component)new TextComponent("+"));
    }

    public void markBoundsDirty() {
        this.widgets.reset();
    }

    private List<Widget> setupWidgets() {
        Rectangle parentBounds = this.parent.getBounds();
        CategoryRegistry.CategoryConfiguration<?> configuration = CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier());
        DisplayCategory<?> category = configuration.getCategory();
        Rectangle displayBounds = new Rectangle(0, 0, category.getDisplayWidth(this.display), category.getDisplayHeight());
        List<Widget> widgets = configuration.getView(this.display).setupDisplay(this.display, displayBounds);
        float scale = 1.0f;
        if ((float)parentBounds.width * scale < (float)displayBounds.width) {
            scale = Math.min(scale, (float)parentBounds.width * scale / (float)displayBounds.width);
        }
        if ((float)parentBounds.height * scale < (float)displayBounds.height) {
            scale = Math.min(scale, (float)parentBounds.height * scale / (float)displayBounds.height);
        }
        float x = (float)parentBounds.getCenterX() - (float)(displayBounds.width / 2) * scale;
        float y = (float)parentBounds.getCenterY() - (float)(displayBounds.height / 2) * scale;
        FloatingRectangle newBounds = new Rectangle((double)x, (double)y, (double)((float)displayBounds.width * scale), (double)((float)displayBounds.height * scale)).getFloatingBounds();
        if (this.size.width == 1 && this.size.height == 1) {
            this.bounds.setTo((Object)newBounds, 700L);
        } else {
            this.bounds.setAs((Object)newBounds);
        }
        this.size.setSize(displayBounds.getSize());
        return widgets;
    }

    @Override
    public Rectangle getBounds() {
        return ((FloatingRectangle)this.bounds.value()).getBounds();
    }

    public Dimension getSize() {
        return this.size;
    }

    public boolean isStable() {
        this.widgets.get();
        FloatingRectangle target = (FloatingRectangle)this.bounds.target();
        FloatingRectangle value = (FloatingRectangle)this.bounds.value();
        return this.reachedStable || Math.abs(value.x - target.x) <= 0.5 && Math.abs(value.y - target.y) <= 0.5 && Math.abs(value.width - target.width) <= 0.5 && Math.abs(value.height - target.height) <= 0.5;
    }

    public void setReachedStable(boolean reachedStable) {
        this.reachedStable = reachedStable;
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        boolean stable = this.isStable();
        this.bounds.update((double)delta);
        FloatingRectangle target = (FloatingRectangle)this.bounds.target();
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        if (!this.reachedStable && Math.abs(bounds.x - target.x) <= 0.5 && Math.abs(bounds.y - target.y) <= 0.5 && Math.abs(bounds.width - target.width) <= 0.5 && Math.abs(bounds.height - target.height) <= 0.5) {
            this.reachedStable = true;
        }
        if (stable && (bounds.getMaxX() + this.xOffset < (double)this.parent.getBounds().x || bounds.x + this.xOffset > (double)this.parent.getBounds().getMaxX())) {
            return;
        }
        poses.m_85836_();
        if (!stable || !target.equals((Object)bounds)) {
            poses.m_85837_(0.0, 0.0, 600.0);
        }
        poses.m_85837_((double)this.xOffset(), (double)this.yOffset(), 0.0);
        poses.m_85841_(this.xScale(), this.yScale(), 1.0f);
        for (Widget widget : (List)this.widgets.get()) {
            widget.m_6305_(poses, this.transformMouseX(mouseX), this.transformMouseY(mouseY), delta);
        }
        poses.m_85849_();
        poses.m_85836_();
        if (stable && target.equals((Object)bounds)) {
            poses.m_85837_(this.xOffset, 0.0, 200.0);
        } else {
            poses.m_85837_(0.0, 0.0, 800.0);
        }
        Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
        mouse.m_123607_(poses.m_85850_().m_85861_());
        AutoCraftingEvaluator.AutoCraftingResult result = AutoCraftingEvaluator.evaluateAutoCrafting(false, false, this.display, this.display::provideInternalDisplayIds);
        this.plusButton.setEnabled(result.successful);
        this.plusButton.setTint(result.tint);
        this.plusButton.getBounds().setBounds(new Rectangle(bounds.getMaxX() - 14.0, bounds.getMaxY() - 14.0, 10.0, 10.0));
        if (result.hasApplicable) {
            this.plusButton.setText((Component)new TextComponent("+"));
            this.plusButton.m_6305_(poses, Math.round(mouse.m_123601_()), Math.round(mouse.m_123615_()), delta);
            poses.m_85849_();
            if (this.plusButton.containsMouse(Math.round(mouse.m_123601_()), Math.round(mouse.m_123615_()))) {
                result.tooltipRenderer.accept(new Point(mouseX, mouseY), Tooltip::queue);
                if (result.renderer != null) {
                    poses.m_85836_();
                    if (!stable || !target.equals((Object)bounds)) {
                        poses.m_85837_(0.0, 0.0, 600.0);
                    }
                    poses.m_85837_((double)this.xOffset(), (double)this.yOffset(), 0.0);
                    poses.m_85841_(this.xScale(), this.yScale(), 1.0f);
                    result.renderer.render(poses, mouseX, mouseY, delta, (List)this.widgets.get(), this.getBounds(), this.display);
                    poses.m_85849_();
                }
            }
        } else {
            poses.m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX + this.xOffset, mouseY)) {
            for (Widget widget : (List)this.widgets.get()) {
                if (!widget.m_6375_(this.transformMouseX(mouseX), this.transformMouseY(mouseY), button)) continue;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.containsMouse(mouseX + this.xOffset, mouseY)) {
            for (Widget widget : (List)this.widgets.get()) {
                if (!widget.m_6348_(this.transformMouseX(mouseX), this.transformMouseY(mouseY), button)) continue;
                return true;
            }
            if (button == 0 && this.plusButton.containsMouse(mouseX + this.xOffset, mouseY)) {
                AutoCraftingEvaluator.evaluateAutoCrafting(true, Screen.m_96638_(), this.display, this.display::provideInternalDisplayIds);
                Widgets.produceClickSound();
                return true;
            }
            ClientHelperImpl.getInstance().openDisplayViewingScreen(Map.of(CategoryRegistry.getInstance().get(this.display.getCategoryIdentifier()).getCategory(), List.of(this.display)), null, List.of(), List.of());
            Widgets.produceClickSound();
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        try {
            Widget.pushMouse(new Point(this.transformMouseX(DisplayEntry.mouse().x), this.transformMouseY(DisplayEntry.mouse().y)));
            for (Widget widget : (List)this.widgets.get()) {
                if (!widget.m_7933_(keyCode, scanCode, modifiers)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Widget.popMouse();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    private float xOffset() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        FloatingRectangle target = (FloatingRectangle)this.bounds.target();
        float xOffset = (float)bounds.x;
        if (this.isStable() && target.equals((Object)bounds)) {
            xOffset = (float)((double)xOffset + this.xOffset);
        }
        return xOffset;
    }

    private float yOffset() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        return (float)bounds.y;
    }

    private float xScale() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        return (float)bounds.width / (float)this.size.width;
    }

    private float yScale() {
        FloatingRectangle bounds = (FloatingRectangle)this.bounds.value();
        return (float)bounds.height / (float)this.size.height;
    }

    private int transformMouseX(int mouseX) {
        return Math.round(((float)mouseX - this.xOffset()) / this.xScale());
    }

    private int transformMouseY(int mouseY) {
        return Math.round(((float)mouseY - this.yOffset()) / this.yScale());
    }

    private double transformMouseX(double mouseX) {
        return (mouseX - (double)this.xOffset()) / (double)this.xScale();
    }

    private double transformMouseY(double mouseY) {
        return (mouseY - (double)this.yOffset()) / (double)this.yScale();
    }

    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    public void setScrolled(double xOffset) {
        this.xOffset = xOffset;
    }

    public List<Widget> getWidgets() {
        return (List)this.widgets.get();
    }

    public Display getDisplay() {
        return this.display;
    }
}

