/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.entrylist;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.animator.NumberAnimator;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStack;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggedAcceptorResult;
import me.shedaniel.rei.api.client.gui.drag.DraggingContext;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.overlay.OverlayListWidget;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.screen.OverlayDecider;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.config.ConfigManagerImpl;
import me.shedaniel.rei.impl.client.config.ConfigObjectImpl;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.widget.BatchedEntryRendererManager;
import me.shedaniel.rei.impl.client.gui.widget.CachedEntryListRender;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListSearchManager;
import me.shedaniel.rei.impl.client.gui.widget.entrylist.EntryListStackEntry;
import me.shedaniel.rei.impl.client.gui.widget.favorites.FavoritesListWidget;
import me.shedaniel.rei.impl.client.gui.widget.region.RegionRenderingDebugger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class EntryListWidget
extends WidgetWithBounds
implements OverlayListWidget,
DraggableStackVisitorWidget {
    private static final int SIZE = 18;
    private int page;
    protected final ScrollingContainer scrolling = new ScrollingContainer(){

        public Rectangle getBounds() {
            return EntryListWidget.this.getBounds();
        }

        public int getMaxScrollHeight() {
            return Mth.m_14167_((float)((float)(EntryListWidget.this.allStacks.size() + EntryListWidget.this.blockedCount) / ((float)EntryListWidget.this.innerBounds.width / (float)EntryListWidget.entrySize()))) * EntryListWidget.entrySize();
        }
    };
    protected int blockedCount;
    private final RegionRenderingDebugger debugger = new RegionRenderingDebugger();
    private Rectangle bounds;
    private Rectangle innerBounds;
    private List<EntryStack<?>> allStacks = null;
    private List<EntryListStackEntry> entries = Collections.emptyList();
    private List<Widget> renders = Collections.emptyList();
    private List<Widget> children = Collections.emptyList();
    public final NumberAnimator<Double> scaleIndicator = ValueAnimator.ofDouble((double)0.0).withConvention(() -> 0.0, 8000L);

    public static int entrySize() {
        return Mth.m_14165_((double)(18.0 * ConfigObject.getInstance().getEntrySize()));
    }

    public static boolean notSteppingOnExclusionZones(int left, int top, int width, int height) {
        Minecraft instance = Minecraft.m_91087_();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.f_91080_)) {
            InteractionResult fit = EntryListWidget.canItemSlotWidgetFit(left, top, width, height, decider);
            if (fit == InteractionResult.PASS) continue;
            return fit == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static InteractionResult canItemSlotWidgetFit(int left, int top, int width, int height, OverlayDecider decider) {
        InteractionResult fit = decider.isInZone(left, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left, top + height);
        if (fit != InteractionResult.PASS) {
            return fit;
        }
        fit = decider.isInZone(left + width, top + height);
        return fit;
    }

    private boolean containsChecked(Point point, boolean inner) {
        return this.containsChecked(point.x, point.y, inner);
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && super.containsMouse(mouseX, mouseY);
    }

    public boolean innerContainsMouse(double mouseX, double mouseY) {
        return this.hasSpace() && this.innerBounds.contains(mouseX, mouseY);
    }

    public boolean containsChecked(double x, double y, boolean inner) {
        if (inner ? !this.innerContainsMouse(x, y) : !this.containsMouse(x, y)) {
            return false;
        }
        Minecraft instance = Minecraft.m_91087_();
        for (OverlayDecider decider : ScreenRegistry.getInstance().getDeciders(instance.f_91080_)) {
            InteractionResult result = decider.isInZone(x, y);
            if (result == InteractionResult.PASS) continue;
            return result == InteractionResult.SUCCESS;
        }
        return true;
    }

    private static Rectangle updateInnerBounds(Rectangle bounds) {
        bounds = bounds.clone();
        int heightReduction = (int)Math.round((double)bounds.height * (1.0 - ConfigObject.getInstance().getVerticalEntriesBoundariesPercentage()));
        bounds.y += heightReduction / 2;
        bounds.height -= heightReduction;
        int maxHeight = (int)Math.ceil((double)EntryListWidget.entrySize() * ConfigObject.getInstance().getVerticalEntriesBoundariesRows());
        if (bounds.height > maxHeight) {
            bounds.y += (bounds.height - maxHeight) / 2;
            bounds.height = maxHeight;
        }
        int entrySize = EntryListWidget.entrySize();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2 - 6) / (float)entrySize)), 1);
            if (ConfigObject.getInstance().isLeftHandSidePanel()) {
                return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) + 3.0f), bounds.y, width * entrySize, bounds.height);
            }
            return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f) - 3.0f), bounds.y, width * entrySize, bounds.height);
        }
        int width = Math.max(Mth.m_14143_((float)((float)(bounds.width - 2) / (float)entrySize)), 1);
        int height = Math.max(Mth.m_14143_((float)((float)(bounds.height - 2) / (float)entrySize)), 1);
        return new Rectangle((int)((float)bounds.getCenterX() - (float)width * ((float)entrySize / 2.0f)), (int)((float)bounds.getCenterY() - (float)height * ((float)entrySize / 2.0f)), width * entrySize, height * entrySize);
    }

    @Override
    public DraggedAcceptorResult acceptDraggedStack(DraggingContext<Screen> context, DraggableStack stack) {
        if (this.innerBounds.contains(context.getCurrentPosition())) {
            context.renderToVoid(stack);
            return DraggedAcceptorResult.CONSUMED;
        }
        return DraggedAcceptorResult.PASS;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            if (Screen.m_96637_()) {
                ConfigObjectImpl config = ConfigManagerImpl.getInstance().getConfig();
                this.scaleIndicator.setAs(10.0);
                if (config.setEntrySize(config.getEntrySize() + amount * 0.075)) {
                    ConfigManager.getInstance().saveConfig();
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    return true;
                }
            } else if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -amount, true);
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void previousPage() {
        --this.page;
    }

    public void nextPage() {
        ++this.page;
    }

    public int getTotalPages() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            return 1;
        }
        return Mth.m_14167_((float)((float)this.allStacks.size() / (float)this.entries.size()));
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (!this.hasSpace()) {
            return;
        }
        boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            this.blockedCount = 0;
            BatchedEntryRendererManager batchedEntryRendererManager = new BatchedEntryRendererManager();
            int i = nextIndex;
            for (int cont = nextIndex; cont < this.entries.size(); ++cont) {
                EntryListStackEntry entry = this.entries.get(cont);
                Rectangle entryBounds = entry.getBounds();
                entryBounds.y = entry.backupY - this.scrolling.scrollAmountInt();
                if (entryBounds.y > this.bounds.getMaxY() || this.allStacks.size() <= i) break;
                if (EntryListWidget.notSteppingOnExclusionZones(entryBounds.x, entryBounds.y, entryBounds.width, entryBounds.height)) {
                    EntryStack<?> stack2 = this.allStacks.get(i++);
                    entry.clearStacks();
                    if (stack2.isEmpty()) continue;
                    entry.entry((EntryStack)stack2);
                    batchedEntryRendererManager.add(entry);
                    continue;
                }
                ++this.blockedCount;
            }
            batchedEntryRendererManager.render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
            this.scrolling.updatePosition(delta);
            ScissorsHandler.INSTANCE.removeLastScissor();
            if (this.scrolling.getMaxScroll() > 0) {
                this.scrolling.renderScrollBar(0, 1.0f, REIRuntime.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            }
        } else {
            for (Widget widget : this.renders) {
                widget.m_6305_(matrices, mouseX, mouseY, delta);
            }
            if (ConfigObject.getInstance().doesCacheEntryRendering()) {
                for (EntryListStackEntry entry : this.entries) {
                    CachedEntryListRender.Sprite sprite;
                    if (entry.our != null || (sprite = CachedEntryListRender.get(entry.getCurrentEntry())) == null) continue;
                    entry.our = ClientEntryStacks.setRenderer(entry.getCurrentEntry().copy().cast(), stack -> new EntryRenderer<Object>(){

                        @Override
                        public void render(EntryStack<Object> entry, PoseStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                            RenderSystem.m_157456_((int)0, (ResourceLocation)CachedEntryListRender.cachedTextureLocation);
                            GuiComponent.m_93112_((Matrix4f)matrices.m_85850_().m_85861_(), (int)bounds.x, (int)bounds.getMaxX(), (int)bounds.y, (int)bounds.getMaxY(), (int)EntryListWidget.this.m_93252_(), (float)sprite.u0, (float)sprite.u1, (float)sprite.v0, (float)sprite.v1);
                        }

                        @Override
                        @Nullable
                        public Tooltip getTooltip(EntryStack<Object> entry, TooltipContext context) {
                            return stack.getDefinition().getRenderer().getTooltip(entry.cast(), context);
                        }
                    });
                }
                BatchedEntryRendererManager.renderSlow(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta, this.entries);
            } else {
                new BatchedEntryRendererManager(this.entries).render(this.debugger.debugTime, this.debugger.size, this.debugger.time, matrices, mouseX, mouseY, delta);
            }
        }
        this.debugger.render(matrices, this.bounds.x, this.bounds.y, delta);
        if (this.containsChecked(mouseX, mouseY, false) && ClientHelper.getInstance().isCheating() && !(Minecraft.m_91087_().f_91080_ instanceof DisplayScreen) && !this.minecraft.f_91074_.f_36096_.m_142621_().m_41619_() && ClientHelperImpl.getInstance().canDeleteItems()) {
            EntryStack<ItemStack> stack3 = EntryStacks.of(this.minecraft.f_91074_.f_36096_.m_142621_().m_41777_());
            if (stack3.getType() != VanillaEntryTypes.ITEM) {
                EntryStack<ItemStack> cheatsAs = stack3.cheatsAs();
                stack3 = cheatsAs.isEmpty() ? stack3 : cheatsAs;
            }
            for (Widget widget : this.m_6702_()) {
                EntryWidget widget2;
                if (!widget.containsMouse(mouseX, mouseY) || !(widget instanceof EntryWidget) || !(widget2 = (EntryWidget)widget).cancelDeleteItems(stack3)) continue;
                return;
            }
            Tooltip.create(new Component[]{new TranslatableComponent("text.rei.delete_items")}).queue();
        }
        this.scaleIndicator.update((double)delta);
        if ((Double)this.scaleIndicator.value() > 0.04) {
            TextComponent component = new TextComponent(Math.round(ConfigObject.getInstance().getEntrySize() * 100.0) + "%");
            int width = this.font.m_92852_((FormattedText)component);
            int n = (int)Math.round(160.0 * Mth.m_14008_((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            int textColor = (int)Math.round(221.0 * Mth.m_14008_((double)((Double)this.scaleIndicator.value()), (double)0.0, (double)1.0)) << 24;
            this.m_93179_(matrices, this.bounds.getCenterX() - width / 2 - 2, this.bounds.getCenterY() - 6, this.bounds.getCenterX() + width / 2 + 2, this.bounds.getCenterY() + 6, n, n);
            this.font.m_92889_(matrices, (Component)component, (float)(this.bounds.getCenterX() - width / 2), (float)(this.bounds.getCenterY() - 4), 0xFFFFFF | textColor);
        }
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.hasSpace() && this.scrolling.mouseDragged(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.containsChecked(EntryListWidget.mouse(), false)) {
            for (Widget widget : this.children) {
                if (!widget.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateArea(Rectangle bounds, String searchTerm) {
        this.bounds = REIRuntime.getInstance().calculateEntryListArea(bounds);
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.updateFavoritesBounds(searchTerm);
        }
        if (this.allStacks == null || ConfigObject.getInstance().isFavoritesEnabled() && favoritesListWidget == null) {
            this.updateSearch(searchTerm, true);
        } else {
            this.updateEntriesPosition();
        }
    }

    public boolean hasSpace() {
        int height;
        int entrySize = EntryListWidget.entrySize();
        int width = this.innerBounds.width / entrySize;
        return width * (height = this.innerBounds.height / entrySize) > 0;
    }

    public void updateEntriesPosition() {
        int entrySize = EntryListWidget.entrySize();
        boolean zoomed = ConfigObject.getInstance().isFocusModeZoomed();
        this.innerBounds = EntryListWidget.updateInnerBounds(this.bounds);
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            this.updateScrolledEntries(entrySize, zoomed);
        } else {
            this.updatePaginatedEntries(entrySize, zoomed);
        }
        FavoritesListWidget favoritesListWidget = ScreenOverlayImpl.getFavoritesListWidget();
        if (favoritesListWidget != null) {
            favoritesListWidget.getSystemRegion().updateEntriesPosition(entry -> true);
            favoritesListWidget.getRegion().updateEntriesPosition(entry -> true);
        }
    }

    private void updateScrolledEntries(int entrySize, boolean zoomed) {
        this.page = 0;
        int width = this.innerBounds.width / entrySize;
        int pageHeight = this.innerBounds.height / entrySize;
        int slotsToPrepare = Math.max(this.allStacks.size() * 3, width * pageHeight * 3);
        int currentX = 0;
        int currentY = 0;
        ArrayList entries = Lists.newArrayList();
        for (int i = 0; i < slotsToPrepare; ++i) {
            int xPos = currentX * entrySize + this.innerBounds.x;
            int yPos = currentY * entrySize + this.innerBounds.y;
            entries.add((EntryListStackEntry)new EntryListStackEntry(this, xPos, yPos, entrySize, zoomed).noBackground());
            if (++currentX < width) continue;
            currentX = 0;
            ++currentY;
        }
        this.entries = entries;
        this.children = Lists.newArrayList(this.renders);
        this.children.addAll(entries);
    }

    private void updatePaginatedEntries(int entrySize, boolean zoomed) {
        this.renders = Lists.newArrayList();
        this.page = Math.max(this.page, 0);
        ArrayList entries = Lists.newArrayList();
        int width = this.innerBounds.width / entrySize;
        int height = this.innerBounds.height / entrySize;
        for (int currentY = 0; currentY < height; ++currentY) {
            for (int currentX = 0; currentX < width; ++currentX) {
                int slotX = currentX * entrySize + this.innerBounds.x;
                int slotY = currentY * entrySize + this.innerBounds.y;
                if (!EntryListWidget.notSteppingOnExclusionZones(slotX - 1, slotY - 1, entrySize, entrySize)) continue;
                entries.add((EntryListStackEntry)new EntryListStackEntry(this, slotX, slotY, entrySize, zoomed).noBackground());
            }
        }
        this.page = Math.max(Math.min(this.page, this.getTotalPages() - 1), 0);
        List subList = this.allStacks.stream().skip(Math.max(0, this.page * entries.size())).limit(Math.max(0, entries.size() - Math.max(0, -this.page * entries.size()))).collect(Collectors.toList());
        for (int i = 0; i < subList.size(); ++i) {
            EntryStack stack = (EntryStack)subList.get(i);
            ((EntryListStackEntry)entries.get(i + Math.max(0, -this.page * entries.size()))).clearStacks().entry(stack);
        }
        this.entries = entries;
        this.children = Lists.newArrayList(this.renders);
        this.children.addAll(entries);
    }

    @ApiStatus.Internal
    public List<EntryStack<?>> getAllStacks() {
        return this.allStacks;
    }

    public void updateSearch(String searchTerm, boolean ignoreLastSearch) {
        EntryListSearchManager.INSTANCE.update(searchTerm, ignoreLastSearch, stacks -> {
            this.allStacks = stacks;
            this.updateEntriesPosition();
        });
        this.debugger.debugTime = ConfigObject.getInstance().doDebugRenderTimeRequired();
        FavoritesListWidget favorites = ScreenOverlayImpl.getFavoritesListWidget();
        if (favorites != null) {
            favorites.updateSearch();
        }
    }

    public List<? extends Widget> m_6702_() {
        return this.children;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.hasSpace()) {
            return false;
        }
        if (ConfigObject.getInstance().isEntryListWidgetScrolled() && this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
            return true;
        }
        for (Widget widget : this.m_6702_()) {
            if (!widget.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.containsChecked(mouseX, mouseY, false)) {
            LocalPlayer player = this.minecraft.f_91074_;
            if (ClientHelper.getInstance().isCheating() && !(Minecraft.m_91087_().f_91080_ instanceof DisplayScreen) && player != null && player.f_36096_ != null && !player.f_36096_.m_142621_().m_41619_() && ClientHelperImpl.getInstance().canDeleteItems()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            for (Widget widget : this.m_6702_()) {
                if (!widget.m_6348_(mouseX, mouseY, button)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public EntryStack<?> getFocusedStack() {
        Point mouse = EntryListWidget.mouse();
        if (this.containsChecked(mouse, false)) {
            for (EntryListStackEntry entry : this.entries) {
                EntryStack<?> currentEntry = entry.getCurrentEntry();
                if (currentEntry.isEmpty() || !entry.containsMouse(mouse)) continue;
                return currentEntry.copy();
            }
        }
        return EntryStack.empty();
    }

    @Override
    public Stream<EntryStack<?>> getEntries() {
        if (ConfigObject.getInstance().isEntryListWidgetScrolled()) {
            int skip = Math.max(0, Mth.m_14107_((double)(this.scrolling.scrollAmount() / (double)EntryListWidget.entrySize())));
            int nextIndex = skip * this.innerBounds.width / EntryListWidget.entrySize();
            return this.entries.stream().skip(nextIndex).filter(entry -> entry.getBounds().y <= this.bounds.getMaxY()).map(EntryWidget::getCurrentEntry).filter((Predicate<EntryStack>)Predicates.not(EntryStack::isEmpty));
        }
        return this.entries.stream().map(EntryWidget::getCurrentEntry);
    }
}

