/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget.basewidgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.clothconfig2.api.TickableWidget;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.TextField;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class TextFieldWidget
extends WidgetWithBounds
implements TickableWidget,
TextField {
    public Function<String, String> stripInvalid;
    protected int frame;
    protected boolean editable = true;
    protected int firstCharacterIndex;
    protected int cursorPos;
    protected int highlightPos;
    protected int editableColor = 0xE0E0E0;
    protected int notEditableColor = 0x707070;
    protected TextFormatter formatter;
    private Rectangle bounds;
    private String text = "";
    private int maxLength = 32;
    private boolean hasBorder = true;
    private boolean focusUnlocked = true;
    private boolean focused;
    private boolean visible = true;
    private boolean selecting;
    private String suggestion;
    private Consumer<String> responder;
    private Predicate<String> filter = s -> true;

    public TextFieldWidget(Rectangle rectangle) {
        this.formatter = TextFormatter.DEFAULT;
        this.bounds = rectangle;
        this.stripInvalid = SharedConstants::m_136190_;
    }

    public TextFieldWidget(int x, int y, int width, int height) {
        this(new Rectangle(x, y, width, height));
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setResponder(Consumer<String> responder) {
        this.responder = responder;
    }

    public void setFormatter(TextFormatter formatter) {
        this.formatter = formatter;
    }

    public void tick() {
        ++this.frame;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text) {
        if (this.filter.test(text)) {
            this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
            this.onChanged(text);
            this.moveCursorToEnd();
        }
    }

    @Override
    public String getSelectedText() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.text.substring(i, j);
    }

    public void setFilter(Predicate<String> filter) {
        this.filter = filter;
    }

    @Override
    public void addText(String text) {
        String result;
        String textFiltered;
        int l;
        int highlightStart = Math.min(this.cursorPos, this.highlightPos);
        int highlightEnd = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.text.length() - (highlightStart - highlightEnd);
        if (k < (l = (textFiltered = this.stripInvalid.apply(text)).length())) {
            textFiltered = textFiltered.substring(0, k);
            l = k;
        }
        if (this.filter.test(result = new StringBuilder(this.text).replace(highlightStart, highlightEnd, textFiltered).toString())) {
            this.text = result;
            this.setCursorPosition(highlightStart + l);
            this.setHighlightPos(this.cursorPos);
            this.onChanged(this.text);
        }
    }

    public void onChanged(String string_1) {
        if (this.responder != null) {
            this.responder.accept(string_1);
        }
    }

    private void erase(int int_1) {
        if (Screen.m_96637_()) {
            this.eraseWords(int_1);
        } else {
            this.eraseCharacters(int_1);
        }
    }

    public void eraseWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.addText("");
            } else {
                this.eraseCharacters(this.getWordPosition(wordOffset) - this.cursorPos);
            }
        }
    }

    public void eraseCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.highlightPos != this.cursorPos) {
                this.addText("");
            } else {
                String string;
                int k;
                int i = this.getCursorPos(characterOffset);
                int j = Math.min(i, this.cursorPos);
                if (j != (k = Math.max(i, this.cursorPos)) && this.filter.test(string = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = string;
                    this.moveCursorTo(j);
                }
                this.onChanged(this.text);
            }
        }
    }

    public int getWordPosition(int int_1) {
        return this.getWordPosition(int_1, this.getCursor());
    }

    public int getWordPosition(int int_1, int int_2) {
        return this.getWordPosition(int_1, int_2, true);
    }

    public int getWordPosition(int wordOffset, int cursorPosition, boolean skipOverSpaces) {
        int i = cursorPosition;
        boolean bl = wordOffset < 0;
        int j = Math.abs(wordOffset);
        for (int k = 0; k < j; ++k) {
            if (!bl) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipOverSpaces && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipOverSpaces && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursor(int int_1) {
        this.moveCursorTo(this.cursorPos + int_1);
    }

    private int getCursorPos(int i) {
        return Util.m_137479_((String)this.text, (int)this.cursorPos, (int)i);
    }

    @Override
    public void moveCursorTo(int cursor) {
        this.setCursorPosition(cursor);
        if (!this.selecting) {
            this.setHighlightPos(this.cursorPos);
        }
    }

    @Override
    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    @Override
    public void moveCursorToEnd() {
        this.moveCursorTo(this.text.length());
    }

    public boolean m_7933_(int int_1, int int_2, int int_3) {
        if (this.isVisible() && this.isFocused()) {
            this.selecting = Screen.m_96638_();
            if (Screen.m_96634_((int)int_1)) {
                this.moveCursorToEnd();
                this.setHighlightPos(0);
                return true;
            }
            if (Screen.m_96632_((int)int_1)) {
                this.minecraft.f_91068_.m_90911_(this.getSelectedText());
                return true;
            }
            if (Screen.m_96630_((int)int_1)) {
                if (this.editable) {
                    this.addText(this.minecraft.f_91068_.m_90876_());
                }
                return true;
            }
            if (Screen.m_96628_((int)int_1)) {
                this.minecraft.f_91068_.m_90911_(this.getSelectedText());
                if (this.editable) {
                    this.addText("");
                }
                return true;
            }
            switch (int_1) {
                case 259: {
                    if (this.editable) {
                        this.selecting = false;
                        this.erase(-1);
                        this.selecting = Screen.m_96638_();
                    }
                    return true;
                }
                default: {
                    return int_1 != 256;
                }
                case 261: {
                    if (this.editable) {
                        this.selecting = false;
                        this.erase(1);
                        this.selecting = Screen.m_96638_();
                    }
                    return true;
                }
                case 262: {
                    if (Screen.m_96637_()) {
                        this.moveCursorTo(this.getWordPosition(1));
                    } else {
                        this.moveCursor(1);
                    }
                    return true;
                }
                case 263: {
                    if (Screen.m_96637_()) {
                        this.moveCursorTo(this.getWordPosition(-1));
                    } else {
                        this.moveCursor(-1);
                    }
                    return true;
                }
                case 268: {
                    this.moveCursorToStart();
                    return true;
                }
                case 269: 
            }
            this.moveCursorToEnd();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char char_1, int int_1) {
        if (this.isVisible() && this.isFocused()) {
            if (SharedConstants.m_136188_((char)char_1) && (!Screen.m_96637_() || Screen.m_96638_() || Screen.m_96639_() || char_1 != 'a' && char_1 != 'c' && char_1 != 'v')) {
                if (this.editable) {
                    this.addText(Character.toString(char_1));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public List<Widget> m_6702_() {
        return Collections.emptyList();
    }

    public boolean m_6375_(double double_1, double double_2, int int_1) {
        boolean boolean_1;
        if (!this.isVisible()) {
            return false;
        }
        boolean bl = boolean_1 = double_1 >= (double)this.bounds.x && double_1 < (double)(this.bounds.x + this.bounds.width) && double_2 >= (double)this.bounds.y && double_2 < (double)(this.bounds.y + this.bounds.height);
        if (this.focusUnlocked) {
            this.setFocused(boolean_1);
        }
        if (this.focused && boolean_1 && int_1 == 0) {
            int int_2 = Mth.m_14107_((double)double_1) - this.bounds.x;
            if (this.hasBorder) {
                int_2 -= 4;
            }
            String string_1 = this.font.m_92834_(this.text.substring(this.firstCharacterIndex), this.getWidth());
            this.moveCursorTo(this.font.m_92834_(string_1, int_2).length() + this.firstCharacterIndex);
            return true;
        }
        return false;
    }

    public void renderBorder(PoseStack matrices) {
        if (this.hasBorder()) {
            if (this.containsMouse(TextFieldWidget.mouse()) || this.focused) {
                TextFieldWidget.m_93172_((PoseStack)matrices, (int)(this.bounds.x - 1), (int)(this.bounds.y - 1), (int)(this.bounds.x + this.bounds.width + 1), (int)(this.bounds.y + this.bounds.height + 1), (int)-1);
            } else {
                TextFieldWidget.m_93172_((PoseStack)matrices, (int)(this.bounds.x - 1), (int)(this.bounds.y - 1), (int)(this.bounds.x + this.bounds.width + 1), (int)(this.bounds.y + this.bounds.height + 1), (int)-6250336);
            }
            TextFieldWidget.m_93172_((PoseStack)matrices, (int)this.bounds.x, (int)this.bounds.y, (int)(this.bounds.x + this.bounds.width), (int)(this.bounds.y + this.bounds.height), (int)-16777216);
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            this.renderBorder(matrices);
            int color = this.editable ? this.editableColor : this.notEditableColor;
            int int_4 = this.cursorPos - this.firstCharacterIndex;
            int int_5 = this.highlightPos - this.firstCharacterIndex;
            String textClipped = this.font.m_92834_(this.text.substring(this.firstCharacterIndex), this.getWidth());
            boolean boolean_1 = int_4 >= 0 && int_4 <= textClipped.length();
            boolean boolean_2 = this.focused && this.frame / 6 % 2 == 0 && boolean_1;
            int x = this.hasBorder ? this.bounds.x + 4 : this.bounds.x;
            int y = this.hasBorder ? this.bounds.y + (this.bounds.height - 8) / 2 : this.bounds.y;
            int int_8 = x;
            int_5 = Math.min(textClipped.length(), int_5);
            if (!textClipped.isEmpty()) {
                String string_2 = boolean_1 ? textClipped.substring(0, int_4) : textClipped;
                int_8 = this.font.m_92744_(matrices, this.formatter.format(this, string_2, this.firstCharacterIndex), (float)x, (float)y, color);
            }
            boolean isCursorInsideText = this.cursorPos < this.text.length() || this.text.length() >= this.getMaxLength();
            int selectionLeft = int_8--;
            if (!boolean_1) {
                selectionLeft = int_4 > 0 ? x + this.bounds.width : x;
            } else if (isCursorInsideText) {
                // empty if block
            }
            --selectionLeft;
            if (!textClipped.isEmpty() && boolean_1 && int_4 < textClipped.length()) {
                this.font.m_92744_(matrices, this.formatter.format(this, textClipped.substring(int_4), this.cursorPos), (float)int_8, (float)y, color);
            }
            if (!isCursorInsideText && this.text.isEmpty() && this.suggestion != null) {
                this.renderSuggestion(matrices, x, y);
            }
            if (boolean_2) {
                TextFieldWidget.m_93172_((PoseStack)matrices, (int)(selectionLeft + 1), (int)y, (int)(selectionLeft + 2), (int)(y + 9), (int)(0xFF000000 | ((color >> 16 & 0xFF) / 4 & 0xFF) << 16 | ((color >> 8 & 0xFF) / 4 & 0xFF) << 8 | (color & 0xFF) / 4 & 0xFF));
                TextFieldWidget.m_93172_((PoseStack)matrices, (int)selectionLeft, (int)(y - 1), (int)(selectionLeft + 1), (int)(y + 8), (int)(0xFF000000 | color));
            }
            if (int_5 != int_4) {
                int selectionRight = x + this.font.m_92895_(textClipped.substring(0, int_5));
                this.renderSelection(matrices, selectionLeft, y - 1, selectionRight - 1, y + 9, color);
            }
        }
    }

    protected void renderSuggestion(PoseStack matrices, int x, int y) {
        this.font.m_92750_(matrices, this.font.m_92834_(this.suggestion, this.getWidth()), (float)x, (float)y, -8355712);
    }

    protected void renderSelection(PoseStack matrices, int x1, int y1, int x2, int y2, int color) {
        int tmp;
        if (x1 < x2) {
            tmp = x1;
            x1 = x2;
            x2 = tmp;
        }
        if (y1 < y2) {
            tmp = y1;
            y1 = y2;
            y2 = tmp;
        }
        if (x2 > this.bounds.x + this.bounds.width) {
            x2 = this.bounds.x + this.bounds.width;
        }
        if (x1 > this.bounds.x + this.bounds.width) {
            x1 = this.bounds.x + this.bounds.width;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)0);
        Matrix4f matrix = matrices.m_85850_().m_85861_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(matrix, (float)x1, (float)y2, (float)this.m_93252_() + 50.0f).m_6122_(r, g, b, 120).m_5752_();
        buffer.m_85982_(matrix, (float)x2, (float)y2, (float)this.m_93252_() + 50.0f).m_6122_(r, g, b, 120).m_5752_();
        buffer.m_85982_(matrix, (float)x2, (float)y1, (float)this.m_93252_() + 50.0f).m_6122_(r, g, b, 120).m_5752_();
        buffer.m_85982_(matrix, (float)x1, (float)y1, (float)this.m_93252_() + 50.0f).m_6122_(r, g, b, 120).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public void setMaxLength(int int_1) {
        this.maxLength = int_1;
        if (this.text.length() > int_1) {
            this.text = this.text.substring(0, int_1);
            this.onChanged(this.text);
        }
    }

    @Override
    public int getCursor() {
        return this.cursorPos;
    }

    @Override
    public void setCursorPosition(int cursor) {
        this.cursorPos = Mth.m_14045_((int)cursor, (int)0, (int)this.text.length());
    }

    @Override
    public boolean hasBorder() {
        return this.hasBorder;
    }

    @Override
    public void setHasBorder(boolean boolean_1) {
        this.hasBorder = boolean_1;
    }

    @Override
    public void setEditableColor(int int_1) {
        this.editableColor = int_1;
    }

    @Override
    public void setNotEditableColor(int notEditableColor) {
        this.notEditableColor = notEditableColor;
    }

    public boolean m_5755_(boolean boolean_1) {
        if (this.visible && this.editable) {
            this.setFocused(!this.focused);
            return this.focused;
        }
        return false;
    }

    @Override
    public boolean isFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(boolean focused) {
        if (focused && !this.focused) {
            this.frame = 0;
        }
        this.focused = focused;
    }

    public void setIsEditable(boolean boolean_1) {
        this.editable = boolean_1;
    }

    public int getWidth() {
        return this.hasBorder() ? this.bounds.width - 8 : this.bounds.width;
    }

    public void setHighlightPos(int i) {
        int j = this.text.length();
        this.highlightPos = Mth.m_14045_((int)i, (int)0, (int)j);
        if (this.font != null) {
            if (this.firstCharacterIndex > j) {
                this.firstCharacterIndex = j;
            }
            int int_3 = this.getWidth();
            String string_1 = this.font.m_92834_(this.text.substring(this.firstCharacterIndex), int_3);
            int int_4 = string_1.length() + this.firstCharacterIndex;
            if (this.highlightPos == this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.font.m_92837_(this.text, int_3, true).length();
            }
            if (this.highlightPos > int_4) {
                this.firstCharacterIndex += this.highlightPos - int_4;
            } else if (this.highlightPos <= this.firstCharacterIndex) {
                this.firstCharacterIndex -= this.firstCharacterIndex - this.highlightPos;
            }
            this.firstCharacterIndex = Mth.m_14045_((int)this.firstCharacterIndex, (int)0, (int)j);
        }
    }

    public void setFocusUnlocked(boolean boolean_1) {
        this.focusUnlocked = boolean_1;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getCharacterX(int index) {
        return index > this.text.length() ? this.bounds.x : this.bounds.x + this.font.m_92895_(this.text.substring(0, index));
    }

    public static interface TextFormatter {
        public static final TextFormatter DEFAULT = (widget, text, index) -> FormattedCharSequence.m_13714_((String)text, (Style)Style.f_131099_);

        public FormattedCharSequence format(TextFieldWidget var1, String var2, int var3);
    }
}

