/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import dev.architectury.registry.ReloadListenerRegistry;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;

public class CachedEntryListRender {
    public static final int RESOLUTION = 64;
    public static DynamicTexture cachedTexture;
    public static ResourceLocation cachedTextureLocation;
    public static Long2LongMap hash;

    public static void refresh() {
        if (ConfigObject.getInstance().doesCacheEntryRendering()) {
            RoughlyEnoughItemsCore.LOGGER.info("Refreshing cached entry list texture...");
        }
        if (cachedTextureLocation != null) {
            Minecraft.m_91087_().m_91097_().m_118513_(cachedTextureLocation);
            cachedTextureLocation = null;
        }
        if (cachedTexture != null) {
            cachedTexture.close();
            cachedTexture = null;
        }
        hash = new Long2LongOpenHashMap();
    }

    @Nullable
    public static Sprite get(EntryStack<?> stack) {
        if (stack.getType() == VanillaEntryTypes.ITEM) {
            long hashExact;
            long hashOrDefault;
            if (stack.getNullable(EntryStack.Settings.RENDERER) != null) {
                return null;
            }
            if (cachedTexture == null) {
                CachedEntryListRender.prepare();
            }
            if ((hashOrDefault = hash.getOrDefault(hashExact = EntryStacks.hashExact(stack), -1L)) != -1L) {
                int x = (int)(hashOrDefault >> 32);
                int y = (int)(hashOrDefault & 0xFFFFFFFFL);
                float width = cachedTexture.m_117991_().m_84982_();
                float height = cachedTexture.m_117991_().m_84982_();
                return new Sprite((float)(x * 64) / width, (float)((x + 1) * 64) / width, (float)(y * 64) / height, (float)((y + 1) * 64) / height);
            }
        }
        return null;
    }

    private static void prepare() {
        int side = 4;
        List<EntryStack<?>> list = EntryRegistry.getInstance().getPreFilteredList();
        while (side * side < list.size()) {
            ++side;
        }
        int width = side * 64;
        int height = side * 64;
        RoughlyEnoughItemsCore.LOGGER.info("Preparing cached texture with size %sx%s for %sx%s entries", width, height, side, side);
        hash = new Long2LongOpenHashMap(list.size() + 10);
        Minecraft minecraft = Minecraft.m_91087_();
        Window window = minecraft.m_91268_();
        TextureTarget target = new TextureTarget(width, height, true, false);
        target.m_83947_(true);
        Matrix4f projectionMatrix = Matrix4f.m_162203_((float)0.0f, (float)width, (float)0.0f, (float)height, (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)projectionMatrix);
        PoseStack modelViewStack = RenderSystem.m_157191_();
        modelViewStack.m_85836_();
        modelViewStack.m_166856_();
        modelViewStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        PoseStack matrices = new PoseStack();
        Rectangle bounds = new Rectangle();
        int index = 0;
        for (EntryStack<?> stack : list) {
            int x = index % side;
            int y = index / side;
            bounds.setBounds(x * 64, y * 64, 64, 64);
            stack.getDefinition().getRenderer().render(stack, matrices, bounds, -1, -1, 0.0f);
            hash.put(EntryStacks.hashExact(stack), CachedEntryListRender.pack(x, y));
            ++index;
        }
        NativeImage nativeImage = new NativeImage(width, height, false);
        RenderSystem.m_69396_((int)target.m_83975_());
        nativeImage.m_85045_(0, false);
        nativeImage.m_85122_();
        cachedTexture = new DynamicTexture(nativeImage);
        cachedTextureLocation = minecraft.m_91097_().m_118490_("rei_cached_entries", cachedTexture);
        target.m_83930_();
        Minecraft.m_91087_().f_91060_.m_173014_();
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        modelViewStack.m_85849_();
        RenderSystem.m_157182_();
    }

    private static long pack(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFFL;
    }

    static {
        hash = new Long2LongOpenHashMap();
        ReloadListenerRegistry.register((PackType)PackType.CLIENT_RESOURCES, (barrier, resourceManager, preparationProfiler, reloadProfiler, preparationExecutor, reloadExecutor) -> barrier.m_6769_((Object)Unit.INSTANCE).thenRunAsync(CachedEntryListRender::refresh, reloadExecutor));
    }

    public static class Sprite {
        public final float u0;
        public final float u1;
        public final float v0;
        public final float v1;

        public Sprite(float u0, float u1, float v0, float v1) {
            this.u0 = u0;
            this.u1 = u1;
            this.v0 = v0;
            this.v1 = v1;
        }
    }
}

