/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import me.shedaniel.rei.impl.client.util.CrashReportUtils;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;

public class BatchedEntryRendererManager {
    private boolean fastEntryRendering = ConfigObject.getInstance().doesFastEntryRendering();
    private Int2ObjectMap<List<Object>> grouping = new Int2ObjectOpenHashMap();
    private List<EntryWidget> toRender = new ArrayList<EntryWidget>();

    public BatchedEntryRendererManager() {
    }

    public BatchedEntryRendererManager(Collection<? extends EntryWidget> widgets) {
        this.addAll(widgets);
    }

    public void addAll(Collection<? extends EntryWidget> widgets) {
        if (this.fastEntryRendering) {
            for (EntryWidget entryWidget : widgets) {
                this.add(entryWidget);
            }
        } else {
            this.toRender.addAll(widgets);
        }
    }

    public void add(EntryWidget widget) {
        if (this.fastEntryRendering) {
            EntryStack<?> currentEntry = widget.getCurrentEntry();
            try {
                EntryStack cast;
                BatchedEntryRenderer batchedRenderer;
                EntryRenderer<?> renderer = currentEntry.getRenderer();
                if (renderer instanceof BatchedEntryRenderer && (batchedRenderer = (BatchedEntryRenderer)renderer).isBatched(cast = currentEntry.cast())) {
                    Object extraData = batchedRenderer.getExtraData(cast);
                    int hash = batchedRenderer.getBatchIdentifier(cast, widget.getBounds(), extraData) ^ widget.getCurrentEntry().getType().hashCode();
                    ArrayList<EntryWidget> entries = (ArrayList<EntryWidget>)this.grouping.get(hash);
                    if (entries == null) {
                        entries = new ArrayList<EntryWidget>();
                        this.grouping.put(hash, entries);
                    }
                    entries.add(widget);
                    entries.add((EntryWidget)extraData);
                    return;
                }
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Adding entry");
                CrashReportUtils.renderer(report, currentEntry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        this.toRender.add(widget);
    }

    public void render(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.render(false, null, null, matrices, mouseX, mouseY, delta);
    }

    public void render(boolean debugTime, MutableInt size, MutableLong time, PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.fastEntryRendering) {
            for (final List entries : this.grouping.values()) {
                Object[] extraData = new Object[entries.size() / 2];
                for (int i = 0; i < extraData.length; ++i) {
                    extraData[i] = entries.get(i * 2 + 1);
                }
                BatchedEntryRendererManager.renderBatched(debugTime, size, time, matrices, mouseX, mouseY, delta, () -> new AbstractIterator<EntryWidget>(){
                    public int i = 0;

                    protected EntryWidget computeNext() {
                        if (this.i >= entries.size()) {
                            return (EntryWidget)this.endOfData();
                        }
                        EntryWidget widget = (EntryWidget)entries.get(this.i);
                        this.i += 2;
                        return widget;
                    }
                }, extraData);
            }
        }
        if (!this.toRender.isEmpty()) {
            BatchedEntryRendererManager.renderSlow(debugTime, size, time, matrices, mouseX, mouseY, delta, this.toRender);
        }
    }

    public static <T extends EntryWidget> void renderEntries(boolean debugTime, MutableInt size, MutableLong time, boolean fastEntryRendering, PoseStack matrices, int mouseX, int mouseY, float delta, Collection<T> entries) {
        if (fastEntryRendering) {
            EntryWidget firstWidget = (EntryWidget)Iterables.getFirst(entries, null);
            if (firstWidget == null) {
                return;
            }
            EntryRenderer<?> renderer = firstWidget.getCurrentEntry().getRenderer();
            if (renderer instanceof BatchedEntryRenderer) {
                BatchedEntryRenderer firstRenderer = (BatchedEntryRenderer)renderer;
                Object[] extraData = new Object[entries.size()];
                int i = 0;
                for (EntryWidget entry : entries) {
                    EntryStack<?> currentEntry = entry.getCurrentEntry();
                    extraData[i++] = ((BatchedEntryRenderer)currentEntry.getRenderer()).getExtraData(currentEntry.cast());
                }
                BatchedEntryRendererManager.renderBatched(debugTime, size, time, matrices, mouseX, mouseY, delta, entries, extraData);
                return;
            }
        }
        BatchedEntryRendererManager.renderSlow(debugTime, size, time, matrices, mouseX, mouseY, delta, entries);
    }

    private static <T extends EntryWidget> void renderBatched(boolean debugTime, MutableInt size, MutableLong time, PoseStack matrices, int mouseX, int mouseY, float delta, Iterable<T> entries, Object[] extraData) {
        EntryStack<?> currentEntry;
        EntryWidget firstWidget = (EntryWidget)Iterables.getFirst(entries, null);
        if (firstWidget == null) {
            return;
        }
        EntryStack<?> first = firstWidget.getCurrentEntry();
        EntryRenderer<?> renderer = first.getRenderer();
        BatchedEntryRenderer firstRenderer = (BatchedEntryRenderer)renderer;
        matrices = firstRenderer.batchModifyMatrices(matrices);
        long l = debugTime ? System.nanoTime() : 0L;
        MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
        int i = 0;
        for (EntryWidget entry : entries) {
            try {
                entry.drawBackground(matrices, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry background");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        firstRenderer.startBatch(first, extraData[0], matrices, delta);
        for (EntryWidget entry : entries) {
            try {
                currentEntry = entry.getCurrentEntry();
                currentEntry.setZ(100);
                firstRenderer.renderBase(currentEntry, extraData[i++], matrices, immediate, entry.getInnerBounds(), mouseX, mouseY, delta);
                if (!debugTime || currentEntry.isEmpty()) continue;
                size.increment();
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry base");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        immediate.m_109911_();
        firstRenderer.afterBase(first, extraData[0], matrices, delta);
        i = 0;
        for (EntryWidget entry : entries) {
            try {
                currentEntry = entry.getCurrentEntry();
                firstRenderer.renderOverlay(currentEntry, extraData[i++], matrices, immediate, entry.getInnerBounds(), mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry base");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        immediate.m_109911_();
        for (EntryWidget entry : entries) {
            try {
                if (entry.containsMouse(mouseX, mouseY)) {
                    entry.queueTooltip(matrices, mouseX, mouseY, delta);
                    if (entry.hasHighlight()) {
                        entry.drawHighlighted(matrices, mouseX, mouseY, delta);
                    }
                }
                entry.drawExtra(matrices, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry extra");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
        if (debugTime) {
            time.add(System.nanoTime() - l);
        }
        firstRenderer.endBatch(first, extraData[0], matrices, delta);
    }

    public static <T extends EntryWidget> void renderSlow(boolean debugTime, MutableInt size, MutableLong time, PoseStack matrices, int mouseX, int mouseY, float delta, Iterable<T> entries) {
        for (EntryWidget entry : entries) {
            if (entry.getCurrentEntry().isEmpty()) continue;
            try {
                if (debugTime) {
                    size.increment();
                    long l = System.nanoTime();
                    entry.m_6305_(matrices, mouseX, mouseY, delta);
                    time.add(System.nanoTime() - l);
                    continue;
                }
                entry.m_6305_(matrices, mouseX, mouseY, delta);
            }
            catch (Throwable throwable) {
                CrashReport report = CrashReportUtils.essential(throwable, "Rendering entry");
                CrashReportUtils.renderer(report, entry);
                CrashReportUtils.catchReport(report);
                return;
            }
        }
    }
}

