/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.widget;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.overlay.ScreenOverlay;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRenderer;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class AutoCraftingEvaluator {
    public static AutoCraftingResult evaluateAutoCrafting(boolean actuallyCrafting, boolean stackedCrafting, Display display, Supplier<Collection<ResourceLocation>> idsSupplier) {
        AbstractContainerScreen<?> containerScreen = REIRuntime.getInstance().getPreviousContainerScreen();
        AutoCraftingResult result = new AutoCraftingResult();
        ArrayList<Object> errorTooltip = new ArrayList<Object>();
        result.tooltipRenderer = (pos, sink) -> {
            Collection locations;
            ArrayList<Component> str = new ArrayList<Component>(errorTooltip);
            if (ConfigObject.getInstance().isFavoritesEnabled()) {
                str.add((Component)new TextComponent(" "));
                str.add((Component)new TranslatableComponent("text.rei.save.recipes", new Object[]{new TextComponent(ConfigObject.getInstance().getFavoriteKeyCode().getLocalizedName().getString().toUpperCase(Locale.ROOT)).m_130940_(ChatFormatting.BOLD)}).m_130940_(ChatFormatting.GRAY));
            }
            if (Minecraft.m_91087_().f_91066_.f_92125_ && idsSupplier != null && !(locations = (Collection)idsSupplier.get()).isEmpty()) {
                str.add((Component)new TextComponent(" "));
                for (ResourceLocation location : locations) {
                    String t = I18n.m_118938_((String)"text.rei.recipe_id", (Object[])new Object[]{"", location.toString()});
                    if (t.startsWith("\n")) {
                        t = t.substring("\n".length());
                    }
                    str.add((Component)new TextComponent(t).m_130940_(ChatFormatting.GRAY));
                }
            }
            sink.accept(Tooltip.create(pos, str));
        };
        if (containerScreen == null) {
            errorTooltip.add(new TranslatableComponent("error.rei.not.supported.move.items").m_130940_(ChatFormatting.RED));
            return result;
        }
        ArrayList<TransferHandler.Result> errors = new ArrayList<TransferHandler.Result>();
        TransferHandler.Context context = TransferHandler.Context.create(actuallyCrafting, stackedCrafting, containerScreen, display);
        for (TransferHandler transferHandler : TransferHandlerRegistry.getInstance()) {
            try {
                TransferHandler.Result transferResult = transferHandler.handle(context);
                if (transferResult.isBlocking() && actuallyCrafting) {
                    if (!transferResult.isReturningToScreen()) break;
                    Minecraft.m_91087_().m_91152_(containerScreen);
                    REIRuntime.getInstance().getOverlay().ifPresent(ScreenOverlay::queueReloadOverlay);
                    break;
                }
                if (!transferResult.isApplicable()) continue;
                result.hasApplicable = true;
                result.tint = transferResult.getColor();
                TransferHandlerRenderer transferHandlerRenderer = transferResult.getRenderer(transferHandler, context);
                if (transferHandlerRenderer != null) {
                    result.renderer = transferHandlerRenderer;
                }
                if (transferResult.getTooltipRenderer() != null) {
                    BiConsumer<Point, TransferHandler.Result.TooltipSink> tooltipRenderer = transferResult.getTooltipRenderer();
                    result.tooltipRenderer = (point, tooltipConsumer) -> tooltipRenderer.accept((Point)point, tooltipConsumer::accept);
                }
                if (transferResult.isSuccessful()) {
                    errors.clear();
                    result.successful = true;
                    result.successfulHandler = transferHandler;
                    break;
                }
                errors.add(transferResult);
                if (!transferResult.isBlocking()) continue;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!result.hasApplicable) {
            errorTooltip.clear();
            errorTooltip.add(new TranslatableComponent("error.rei.not.supported.move.items").m_130940_(ChatFormatting.RED));
            return result;
        }
        if (errors.isEmpty()) {
            errorTooltip.clear();
            errorTooltip.add(new TranslatableComponent("text.auto_craft.move_items"));
        } else {
            errorTooltip.clear();
            ArrayList<Component> tooltipsFilled = new ArrayList<Component>();
            for (TransferHandler.Result error : errors) {
                error.fillTooltip(tooltipsFilled);
            }
            if (errors.size() == 1) {
                for (Component tooltipFilled : tooltipsFilled) {
                    colored = tooltipFilled.m_6881_().m_130940_(ChatFormatting.RED);
                    if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.getString().equalsIgnoreCase(tooltipFilled.getString()))) continue;
                    errorTooltip.add(colored);
                }
            } else {
                errorTooltip.add(new TranslatableComponent("error.rei.multi.errors").m_130940_(ChatFormatting.RED));
                for (Component tooltipFilled : tooltipsFilled) {
                    colored = new TextComponent("- ").m_130940_(ChatFormatting.RED).m_7220_((Component)tooltipFilled.m_6881_().m_130940_(ChatFormatting.RED));
                    if (CollectionUtils.anyMatch(errorTooltip, ss -> ss.getString().equalsIgnoreCase(colored.getString()))) continue;
                    errorTooltip.add(colored);
                }
            }
        }
        return result;
    }

    public static class AutoCraftingResult {
        public int tint = 0;
        public boolean successful = false;
        public TransferHandler successfulHandler;
        public boolean hasApplicable = false;
        public TransferHandlerRenderer renderer;
        public BiConsumer<Point, Consumer<Tooltip>> tooltipRenderer;
    }
}

