/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.modules.entries;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.impl.client.gui.modules.AbstractMenuEntry;
import me.shedaniel.rei.impl.client.gui.modules.Menu;
import me.shedaniel.rei.impl.client.gui.modules.MenuEntry;
import me.shedaniel.rei.impl.client.gui.widget.TabWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class SubMenuEntry
extends AbstractMenuEntry {
    public final Component text;
    private int textWidth = -69;
    protected List<MenuEntry> entries;
    protected Menu childMenu;

    public SubMenuEntry(Component text) {
        this(text, Collections.emptyList());
    }

    public SubMenuEntry(Component text, Supplier<List<MenuEntry>> entries) {
        this(text, entries.get());
    }

    public SubMenuEntry(Component text, List<MenuEntry> entries) {
        this.text = (Component)MoreObjects.firstNonNull((Object)text, (Object)ImmutableTextComponent.EMPTY);
        this.entries = entries;
    }

    private int getTextWidth() {
        if (this.textWidth == -69) {
            this.textWidth = Math.max(0, this.font.m_92852_((FormattedText)this.text));
        }
        return this.textWidth;
    }

    public Menu getChildMenu() {
        if (this.childMenu == null) {
            this.childMenu = new Menu(new Rectangle(this.getParent().getBounds().x + 1, this.getY() - 1, this.getParent().getBounds().width - 2, this.getEntryHeight() - 2), this.entries, false);
        }
        return this.childMenu;
    }

    @Override
    public int getEntryWidth() {
        return 12 + this.getTextWidth() + 4;
    }

    @Override
    public int getEntryHeight() {
        return 12;
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        this.renderBackground(poses, this.getX(), this.getY(), this.getWidth(), this.getEntryHeight());
        if (this.isSelected() && !this.entries.isEmpty()) {
            Menu menu = this.getChildMenu();
            Rectangle menuStart = new Rectangle(this.getParent().getBounds().x, this.getY(), this.getParent().getBounds().width, this.getEntryHeight());
            int fullWidth = Minecraft.m_91087_().f_91080_.f_96543_;
            int fullHeight = Minecraft.m_91087_().f_91080_.f_96544_;
            boolean facingRight = this.getParent().facingRight;
            int menuWidth = menu.getMaxEntryWidth() + 2 + (menu.hasScrollBar() ? 6 : 0);
            if (facingRight && fullWidth - menuStart.getMaxX() < menuWidth + 10) {
                facingRight = false;
            } else if (!facingRight && menuStart.x < menuWidth + 10) {
                facingRight = true;
            }
            boolean facingDownwards = fullHeight - menuStart.getMaxY() > menuStart.y;
            menu.menuStartPoint.y = facingDownwards ? menuStart.y - 1 : menuStart.getMaxY() - (menu.scrolling.getMaxScrollHeight() + 1);
            menu.menuStartPoint.x = facingRight ? menuStart.getMaxX() : menuStart.x - (menu.getMaxEntryWidth() + 2 + (menu.scrolling.getMaxScrollHeight() > menu.getInnerHeight(menu.menuStartPoint.y) ? 6 : 0));
            ArrayList areas = Lists.newArrayList((Iterable)ScissorsHandler.INSTANCE.getScissorsAreas());
            ScissorsHandler.INSTANCE.clearScissors();
            menu.m_6305_(poses, mouseX, mouseY, delta);
            for (Rectangle area : areas) {
                ScissorsHandler.INSTANCE.scissor(area);
            }
        }
        this.font.m_92889_(poses, this.text, (float)(this.getX() + 2), (float)(this.getY() + 2), this.isSelected() ? 0xFFFFFF : 0x888888);
        if (!this.entries.isEmpty()) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)TabWidget.CHEST_GUI_TEXTURE);
            this.m_93228_(poses, this.getX() + this.getWidth() - 15, this.getY() - 2, 0, 28, 18, 18);
        }
    }

    protected void renderBackground(PoseStack poses, int x, int y, int width, int height) {
        if (this.isSelected()) {
            SubMenuEntry.m_93172_((PoseStack)poses, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)-12237499);
        }
    }

    @Override
    public boolean containsMouse(double mouseX, double mouseY) {
        if (super.containsMouse(mouseX, mouseY)) {
            return true;
        }
        if (this.childMenu != null && !this.childMenu.m_6702_().isEmpty() && this.isSelected()) {
            return this.childMenu.containsMouse(mouseX, mouseY);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        return this.childMenu != null && !this.childMenu.m_6702_().isEmpty() && this.isSelected() && this.childMenu.m_6050_(mouseX, mouseY, amount);
    }

    public List<? extends GuiEventListener> m_6702_() {
        if (this.childMenu != null && !this.childMenu.m_6702_().isEmpty() && this.isSelected()) {
            return Collections.singletonList(this.childMenu);
        }
        return Collections.emptyList();
    }
}

