/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.error;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector4f;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ErrorsEntryListWidget
extends DynamicSmoothScrollingEntryListWidget<Entry> {
    private boolean inFocus;

    public ErrorsEntryListWidget(Minecraft client, int width, int height, int startY, int endY) {
        super(client, width, height, startY, endY, GuiComponent.f_93096_);
    }

    public boolean m_5755_(boolean boolean_1) {
        if (!this.inFocus && this.getItemCount() == 0) {
            return false;
        }
        boolean bl = this.inFocus = !this.inFocus;
        if (this.inFocus && this.getFocused() == null && this.getItemCount() > 0) {
            this.moveSelection(1);
        } else if (this.inFocus && this.getFocused() != null) {
            this.moveSelection(0);
        }
        return this.inFocus;
    }

    public void _clearItems() {
        this.clearItems();
    }

    private Entry _getEntry(int index) {
        return (Entry)((Object)this.m_6702_().get(index));
    }

    public void _addEntry(Entry entry) {
        this.addItem(entry);
    }

    public int getItemWidth() {
        return this.width - 80;
    }

    protected int getScrollbarPosition() {
        return this.width - 40;
    }

    public static abstract class Entry
    extends DynamicEntryListWidget.Entry<Entry> {
        public List<? extends NarratableEntry> narratables() {
            return Collections.emptyList();
        }
    }

    public static class LinkEntry
    extends Entry {
        private Component text;
        private List<FormattedCharSequence> textSplit;
        private String link;
        private boolean contains;

        public LinkEntry(Component text, String link, int width) {
            this.text = text;
            this.textSplit = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)text, width - 6);
            this.link = link;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            boolean bl = this.contains = mouseX >= x && mouseX <= x + entryWidth && mouseY >= y && mouseY <= y + entryHeight;
            if (this.contains) {
                Minecraft.m_91087_().f_91080_.m_96602_(matrices, (Component)new TextComponent("Click to open link."), mouseX, mouseY);
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    FormattedCharSequence underlined = characterVisitor -> textSp.m_13731_((charIndex, style, codePoint) -> characterVisitor.m_6411_(charIndex, style.m_131157_(ChatFormatting.UNDERLINE), codePoint));
                    Minecraft.m_91087_().f_91062_.m_92744_(matrices, underlined, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            } else {
                int yy = y;
                for (FormattedCharSequence textSp : this.textSplit) {
                    Minecraft.m_91087_().f_91062_.m_92744_(matrices, textSp, (float)(x + 5), (float)yy, -14695425);
                    yy += 12;
                }
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.contains && button == 0) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                try {
                    Util.m_137581_().m_137648_(new URI(this.link));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    public static class ImageEntry
    extends Entry {
        private DynamicTexture texture;
        private ResourceLocation id;
        private int width;
        private int height;

        public ImageEntry(int width, DynamicTexture texture, ResourceLocation id) {
            this.id = id;
            this.texture = texture;
            this.width = (width - 6) / 2;
            NativeImage image = texture.m_117991_();
            this.height = (int)((double)this.width * ((double)image.m_85084_() / (double)image.m_84982_()));
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.id);
            NativeImage image = this.texture.m_117991_();
            this.width = (entryWidth - 6) / 2;
            this.height = (int)((double)this.width * ((double)image.m_85084_() / (double)image.m_84982_()));
            ErrorsEntryListWidget.m_93172_((PoseStack)matrices, (int)x, (int)y, (int)(x + this.width), (int)(y + this.height + 2), (int)-1);
            ErrorsEntryListWidget.m_93112_((Matrix4f)matrices.m_85850_().m_85861_(), (int)(x + 1), (int)(x + this.width - 1), (int)(y + 1), (int)(y + this.height + 1), (int)0, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }

        public int getItemHeight() {
            return this.height + 2;
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }
    }

    public static class HorizontalRuleEntry
    extends Entry {
        private int width;

        public HorizontalRuleEntry(int width) {
            this.width = width;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.width != entryWidth) {
                this.width = entryWidth;
            }
            ErrorsEntryListWidget.m_93172_((PoseStack)matrices, (int)(x + 2), (int)(y + 2), (int)(x + this.width - 6 - 2), (int)(y + 3), (int)-8947849);
        }

        public int getItemHeight() {
            return 5;
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }
    }

    public static class TextEntry
    extends Entry {
        private Component text;
        private int width;
        private List<FormattedCharSequence> textSplit;
        private int savedX;
        private int savedY;

        public TextEntry(Component text, int width) {
            this.text = text;
            this.width = width - 6;
            this.textSplit = text.getString().trim().isEmpty() ? Collections.singletonList(text.m_7532_()) : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)text, this.width);
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            HoverEvent hoverEvent;
            Component component;
            if (this.width != entryWidth - 6) {
                this.width = entryWidth - 6;
                this.textSplit = this.text.getString().trim().isEmpty() ? Collections.singletonList(this.text.m_7532_()) : Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.text, this.width);
            }
            this.savedX = x;
            this.savedY = y;
            int yy = y;
            for (FormattedCharSequence textSp : this.textSplit) {
                Minecraft.m_91087_().f_91062_.m_92744_(matrices, textSp, (float)(x + 5), (float)yy, -1);
                yy += 12;
            }
            Style style = this.getTextAt(mouseX, mouseY);
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (style != null && screen != null && style.m_131186_() != null && (component = (Component)(hoverEvent = style.m_131186_()).m_130823_(HoverEvent.Action.f_130831_)) != null) {
                screen.m_96617_(matrices, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)component, Math.max(this.width / 2, 200)), x, y);
            }
        }

        public int getItemHeight() {
            return 12 * this.textSplit.size();
        }

        public boolean m_5755_(boolean boolean_1) {
            return false;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            Style style;
            if (button == 0 && (style = this.getTextAt(mouseX, mouseY)) != null && style.m_131182_() != null) {
                ClickEvent clickEvent = style.m_131182_();
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                try {
                    Util.m_137581_().m_137648_(new URI(clickEvent.m_130623_()));
                    return true;
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    return true;
                }
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Nullable
        private Style getTextAt(double x, double y) {
            int lineCount = this.textSplit.size();
            if (lineCount > 0) {
                int line;
                int textX = Mth.m_14107_((double)(x - (double)this.savedX));
                int textY = Mth.m_14107_((double)(y - (double)this.savedY));
                if (textX >= 0 && textY >= 0 && textX <= this.width && textY < 12 * lineCount + lineCount && (line = textY / 12) < this.textSplit.size()) {
                    FormattedCharSequence orderedText = this.textSplit.get(line);
                    return Minecraft.m_91087_().f_91062_.m_92865_().m_92338_(orderedText, textX);
                }
            }
            return null;
        }
    }

    public static class ScaledEntry
    extends Entry
    implements ContainerEventHandler {
        public final Entry entry;
        public final float scale;
        public final Matrix4f transform;
        @Nullable
        private GuiEventListener focused;
        private boolean isDragging;

        public ScaledEntry(Entry entry, float scale) {
            this.entry = entry;
            this.scale = scale;
            this.transform = Matrix4f.m_27632_((float)scale, (float)scale, (float)scale);
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        private Vector4f transformMouse(double mouseX, double mouseY) {
            Vector4f mouse = new Vector4f((float)mouseX, (float)mouseY, 0.0f, 1.0f);
            mouse.m_123607_(this.transform);
            return mouse;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            Vector4f mouse = this.transformMouse(mouseX, mouseY);
            matrices.m_85836_();
            matrices.m_85850_().m_85861_().m_27644_(this.transform);
            Vector4f pos = new Vector4f((float)x, (float)y, 0.0f, 1.0f);
            pos.m_123607_(Matrix4f.m_27632_((float)(1.0f / this.scale), (float)(1.0f / this.scale), (float)(1.0f / this.scale)));
            this.getEntry().render(matrices, index, Math.round(pos.m_123615_()), Math.round(pos.m_123601_()), Math.round((float)entryWidth / this.scale), Math.round((float)entryHeight / this.scale), (int)mouse.m_123601_(), (int)mouse.m_123615_(), isSelected, delta);
            matrices.m_85849_();
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.getEntry().narratables();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.getEntry());
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            Vector4f mouse = this.transformMouse(mouseX, mouseY);
            return super.m_5953_((double)mouse.m_123601_(), (double)mouse.m_123615_());
        }

        public boolean m_6375_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_6375_((double)mouse.m_123601_(), (double)mouse.m_123615_(), i);
        }

        public boolean m_6348_(double d, double e, int i) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_6348_((double)mouse.m_123601_(), (double)mouse.m_123615_(), i);
        }

        public boolean m_7979_(double d, double e, int i, double f, double g) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_7979_((double)mouse.m_123601_(), (double)mouse.m_123615_(), i, f, g);
        }

        public boolean m_6050_(double d, double e, double f) {
            Vector4f mouse = this.transformMouse(d, e);
            return super.m_6050_((double)mouse.m_123601_(), (double)mouse.m_123615_(), f);
        }

        public final boolean m_7282_() {
            return this.isDragging;
        }

        public final void m_7897_(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public void m_7522_(@Nullable GuiEventListener focused) {
            this.focused = focused;
        }
    }

    public static class IndentedEntry
    extends Entry
    implements ContainerEventHandler {
        public final Entry entry;
        public final int indent;
        @Nullable
        private GuiEventListener focused;
        private boolean isDragging;

        public IndentedEntry(Entry entry, int indent) {
            this.entry = entry;
            this.indent = indent;
        }

        public Entry getEntry() {
            this.entry.setParent(this.getParent());
            return this.entry;
        }

        public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.getEntry().render(matrices, index, y, x + this.indent, entryWidth - this.indent, entryHeight, mouseX, mouseY, isSelected, delta);
        }

        public int getItemHeight() {
            return this.getEntry().getItemHeight();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.getEntry().narratables();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.singletonList(this.getEntry());
        }

        public final boolean m_7282_() {
            return this.isDragging;
        }

        public final void m_7897_(boolean dragging) {
            this.isDragging = dragging;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public void m_7522_(@Nullable GuiEventListener focused) {
            this.focused = focused;
        }
    }

    public static class EmptyEntry
    extends Entry {
        public final int height;

        public EmptyEntry(int height) {
            this.height = height;
        }

        public void render(PoseStack poseStack, int i, int i1, int i2, int i3, int i4, int i5, int i6, boolean b, float v) {
        }

        public int getItemHeight() {
            return this.height;
        }
    }
}

