/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.impl.client.gui.toast.ExportRecipeIdentifierToast;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
@ApiStatus.Experimental
public final class RecipeDisplayExporter
extends Widget {
    private static final RecipeDisplayExporter INSTANCE = new RecipeDisplayExporter();

    private RecipeDisplayExporter() {
    }

    public static void exportRecipeDisplay(Rectangle rectangle, DisplaySpec display, List<Widget> widgets, boolean toast) {
        INSTANCE.exportRecipe(rectangle, display, widgets);
        if (toast) {
            ExportRecipeIdentifierToast.addToast(I18n.m_118938_((String)"msg.rei.exported_recipe", (Object[])new Object[0]), I18n.m_118938_((String)"msg.rei.exported_recipe.desc", (Object[])new Object[0]));
        }
    }

    private static File getExportFilename(DisplaySpec display, File directory) {
        Collection<ResourceLocation> locations = display.provideInternalDisplayIds();
        String string = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        if (!locations.isEmpty()) {
            string = locations.iterator().next().toString().replace('/', '_');
        }
        int i = 1;
        File file;
        while ((file = new File(directory, string + (String)(i == 1 ? "" : "_" + i) + ".png")).exists()) {
            ++i;
        }
        return file;
    }

    private void exportRecipe(Rectangle rectangle, DisplaySpec display, List<Widget> widgets) {
        Minecraft client = Minecraft.m_91087_();
        Window window = client.m_91268_();
        TextureTarget renderTarget = new TextureTarget(window.m_85441_(), window.m_85442_(), true, false);
        renderTarget.m_83947_(true);
        RenderSystem.m_69421_((int)256, (boolean)Minecraft.f_91002_);
        Matrix4f matrix4f = Matrix4f.m_162203_((float)0.0f, (float)((float)((double)window.m_85441_() / window.m_85449_())), (float)0.0f, (float)((float)((double)window.m_85442_() / window.m_85449_())), (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        poseStack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        PoseStack matrices = new PoseStack();
        for (Widget widget : widgets) {
            widget.m_6305_(matrices, -1, -1, 0.0f);
        }
        NativeImage nativeImage = new NativeImage(renderTarget.f_83915_, renderTarget.f_83916_, false);
        RenderSystem.m_69396_((int)renderTarget.m_83975_());
        nativeImage.m_85045_(0, false);
        nativeImage.m_85122_();
        int outWidth = (int)((double)rectangle.width * window.m_85449_());
        int outHeight = (int)((double)rectangle.height * window.m_85449_());
        NativeImage strippedImage = new NativeImage(outWidth, outHeight, false);
        for (int y = 0; y < outHeight; ++y) {
            for (int x = 0; x < outWidth; ++x) {
                strippedImage.m_84988_(x, y, nativeImage.m_84985_(x + (int)((double)rectangle.x * window.m_85449_()), y + (int)((double)rectangle.y * window.m_85449_())));
            }
        }
        Util.m_183992_().execute(() -> {
            try {
                File export = new File(this.minecraft.f_91069_, "rei_exports/" + display.provideInternalDisplay().getCategoryIdentifier().toString().replace('/', '_'));
                export.mkdirs();
                strippedImage.m_85056_(RecipeDisplayExporter.getExportFilename(display, export));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                nativeImage.close();
                strippedImage.close();
            }
        });
        renderTarget.m_83930_();
        Minecraft.m_91087_().f_91060_.m_173014_();
        Minecraft.m_91087_().m_91385_().m_83947_(true);
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public void m_6305_(PoseStack matrixStack, int mouseY, int i, float f) {
    }

    public List<? extends GuiEventListener> m_6702_() {
        return null;
    }
}

