/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.favorites;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.client.config.ConfigManager;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.SystemFavoriteEntryProvider;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.registry.ReloadStage;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FavoriteEntryTypeRegistryImpl
implements FavoriteEntryType.Registry {
    private final BiMap<ResourceLocation, FavoriteEntryType<?>> registry = HashBiMap.create();
    private final List<Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>>> systemFavorites = Lists.newArrayList();
    private final Map<Component, FavoriteEntryType.Section> sections = Maps.newConcurrentMap();
    private final List<FavoriteEntryType.Section> sectionsList = Lists.newCopyOnWriteArrayList();

    @Override
    public ReloadStage getStage() {
        return ReloadStage.START;
    }

    @Override
    public void acceptPlugin(REIClientPlugin plugin) {
        plugin.registerFavorites(this);
    }

    @Override
    public void register(ResourceLocation id, FavoriteEntryType<?> type) {
        this.registry.put((Object)id, type);
    }

    @Override
    @Nullable
    public <A extends FavoriteEntry> FavoriteEntryType<A> get(ResourceLocation id) {
        return (FavoriteEntryType)this.registry.get((Object)id);
    }

    @Override
    @Nullable
    public ResourceLocation getId(FavoriteEntryType<?> type) {
        return (ResourceLocation)this.registry.inverse().get(type);
    }

    @Override
    public FavoriteEntryType.Section getOrCrateSection(Component text) {
        return this.sections.computeIfAbsent(text, $ -> {
            SectionImpl section = new SectionImpl((Component)$);
            this.sectionsList.add(section);
            return section;
        });
    }

    @Override
    public Iterable<FavoriteEntryType.Section> sections() {
        return this.sectionsList;
    }

    @Override
    public <A extends FavoriteEntry> void registerSystemFavorites(SystemFavoriteEntryProvider<A> provider) {
        this.systemFavorites.add(Triple.of(provider, (Object)new MutableLong(-1L), new ArrayList()));
    }

    public List<Triple<SystemFavoriteEntryProvider<?>, MutableLong, List<FavoriteEntry>>> getSystemProviders() {
        return this.systemFavorites;
    }

    @Override
    public void startReload() {
        this.registry.clear();
        this.systemFavorites.clear();
        this.sections.clear();
        this.sectionsList.clear();
    }

    @Override
    public void endReload() {
        if (ConfigObject.getInstance().isFavoritesEnabled()) {
            List<FavoriteEntry> favorites = ConfigObject.getInstance().getFavoriteEntries();
            favorites.removeIf(FavoriteEntry::isInvalid);
            ConfigManager.getInstance().saveConfig();
        }
    }

    private static class SectionImpl
    implements FavoriteEntryType.Section {
        private final Component text;
        private final List<FavoriteEntry> entries = new ArrayList<FavoriteEntry>();

        public SectionImpl(Component text) {
            this.text = text;
        }

        @Override
        public void add(FavoriteEntry ... entries) {
            Collections.addAll(this.entries, entries);
        }

        @Override
        public Component getText() {
            return this.text;
        }

        @Override
        public List<FavoriteEntry> getEntries() {
            return this.entries;
        }
    }
}

