/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry.type;

import java.util.stream.Stream;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface EntryDefinition<T> {
    public Class<T> getValueType();

    public EntryType<T> getType();

    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<T> getRenderer();

    @Nullable
    public ResourceLocation getIdentifier(EntryStack<T> var1, T var2);

    @Nullable
    default public String getContainingNamespace(EntryStack<T> entry, T value) {
        ResourceLocation identifier = this.getIdentifier(entry, value);
        if (identifier == null) {
            return null;
        }
        return identifier.m_135827_();
    }

    public boolean isEmpty(EntryStack<T> var1, T var2);

    public T copy(EntryStack<T> var1, T var2);

    public T normalize(EntryStack<T> var1, T var2);

    public T wildcard(EntryStack<T> var1, T var2);

    @Nullable
    default public ItemStack cheatsAs(EntryStack<T> entry, T value) {
        return null;
    }

    public long hash(EntryStack<T> var1, T var2, ComparisonContext var3);

    public boolean equals(T var1, T var2, ComparisonContext var3);

    @Nullable
    public EntrySerializer<T> getSerializer();

    public Component asFormattedText(EntryStack<T> var1, T var2);

    public Stream<? extends TagKey<?>> getTagsFor(EntryStack<T> var1, T var2);

    @ApiStatus.NonExtendable
    default public <O> EntryDefinition<O> cast() {
        return this;
    }

    default public void fillCrashReport(CrashReport report, CrashReportCategory category, EntryStack<T> entry) {
        category.m_128165_("Entry definition class name", () -> this.getClass().getCanonicalName());
    }
}

