/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.display;

import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DynamicDisplayGenerator;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReason;
import me.shedaniel.rei.api.client.registry.display.reason.DisplayAdditionReasons;
import me.shedaniel.rei.api.client.registry.display.visibility.DisplayVisibilityPredicate;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface DisplayRegistry
extends RecipeManagerContext<REIClientPlugin> {
    public static DisplayRegistry getInstance() {
        return PluginManager.getClientInstance().get(DisplayRegistry.class);
    }

    public int displaySize();

    default public void add(Display display) {
        this.add(display, null);
    }

    public void add(Display var1, @Nullable Object var2);

    default public void add(Object object) {
        this.addWithReason(object, DisplayAdditionReason.NONE);
    }

    @ApiStatus.Experimental
    default public void addWithReason(Object object, DisplayAdditionReason ... reasons) {
        if (object instanceof Display) {
            this.add((Display)object, null);
        } else {
            for (Display display : this.tryFillDisplay(object, reasons)) {
                this.add(display, object);
            }
        }
    }

    public Map<CategoryIdentifier<?>, List<Display>> getAll();

    default public <D extends Display> List<D> get(CategoryIdentifier<D> categoryId) {
        return this.getAll().getOrDefault(categoryId, Collections.emptyList());
    }

    public <A extends Display> void registerGlobalDisplayGenerator(DynamicDisplayGenerator<A> var1);

    public <A extends Display> void registerDisplayGenerator(CategoryIdentifier<A> var1, DynamicDisplayGenerator<A> var2);

    public Map<CategoryIdentifier<?>, List<DynamicDisplayGenerator<?>>> getCategoryDisplayGenerators();

    public List<DynamicDisplayGenerator<?>> getGlobalDisplayGenerators();

    default public <D extends Display> List<DynamicDisplayGenerator<?>> getCategoryDisplayGenerators(CategoryIdentifier<D> categoryId) {
        return this.getCategoryDisplayGenerators().getOrDefault(categoryId, Collections.emptyList());
    }

    public void registerVisibilityPredicate(DisplayVisibilityPredicate var1);

    public boolean isDisplayVisible(Display var1);

    default public boolean isDisplayInvisible(Display display) {
        return !this.isDisplayVisible(display);
    }

    public List<DisplayVisibilityPredicate> getVisibilityPredicates();

    default public <T extends Recipe<?>, D extends Display> void registerRecipeFiller(Class<T> typeClass, RecipeType<? super T> recipeType, Function<? extends T, D> filler) {
        this.registerRecipeFiller(typeClass, (RecipeType<? super T> type) -> Objects.equals(recipeType, type), filler);
    }

    default public <T extends Recipe<?>, D extends Display> void registerRecipeFiller(Class<T> typeClass, Predicate<RecipeType<? super T>> recipeType, Function<? extends T, D> filler) {
        this.registerRecipeFiller(typeClass, recipeType, (Predicate<? extends T>)Predicates.alwaysTrue(), filler);
    }

    default public <T extends Recipe<?>, D extends Display> void registerRecipeFiller(Class<T> typeClass, Predicate<RecipeType<? super T>> recipeType, Predicate<? extends T> predicate, Function<? extends T, D> filler) {
        this.registerFiller(typeClass, (? extends T recipe) -> recipeType.test(recipe.m_6671_()) && predicate.test(recipe), filler);
    }

    default public <T, D extends Display> void registerFiller(Class<T> typeClass, Function<? extends T, D> filler) {
        this.registerFiller(typeClass, (Predicate<? extends T>)Predicates.alwaysTrue(), filler);
    }

    public <T, D extends Display> void registerFiller(Class<T> var1, Predicate<? extends T> var2, Function<? extends T, D> var3);

    @ApiStatus.Experimental
    public <T, D extends Display> void registerFiller(Class<T> var1, BiPredicate<? extends T, DisplayAdditionReasons> var2, Function<? extends T, D> var3);

    public <D extends Display> void registerFiller(Predicate<?> var1, Function<?, D> var2);

    default public <T> Collection<Display> tryFillDisplay(T value) {
        return this.tryFillDisplay(value, DisplayAdditionReason.NONE);
    }

    @ApiStatus.Experimental
    public <T> Collection<Display> tryFillDisplay(T var1, DisplayAdditionReason ... var2);

    @Nullable
    public Object getDisplayOrigin(Display var1);
}

