/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.gui.widgets;

import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.rei.api.client.REIRuntime;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public interface Tooltip {
    public static Entry entry(Component text) {
        return ClientInternals.createTooltipEntry(text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Entry entry(ClientTooltipComponent text) {
        return ClientInternals.createTooltipEntry(text);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Entry entry(TooltipComponent text) {
        return ClientInternals.createTooltipEntry(text);
    }

    public static Tooltip create(@Nullable Point point, Collection<Component> texts) {
        return Tooltip.from(point, CollectionUtils.map(texts, Tooltip::entry));
    }

    public static Tooltip create(@Nullable Point point, Component ... texts) {
        return Tooltip.create(point, Arrays.asList(texts));
    }

    public static Tooltip create(Collection<Component> texts) {
        return Tooltip.create(null, texts);
    }

    public static Tooltip create(Component ... texts) {
        return Tooltip.create(Arrays.asList(texts));
    }

    public static Tooltip from(@Nullable Point point, Collection<Entry> entries) {
        return ClientInternals.createTooltip(point, entries);
    }

    public static Tooltip from(@Nullable Point point, Entry ... entries) {
        return Tooltip.from(point, Arrays.asList(entries));
    }

    public static Tooltip from(Collection<Entry> entries) {
        return Tooltip.from(null, entries);
    }

    public static Tooltip from(Entry ... entries) {
        return Tooltip.from(Arrays.asList(entries));
    }

    public int getX();

    public int getY();

    public List<Entry> entries();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public List<TooltipComponent> components();

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public Tooltip add(ClientTooltipComponent var1);

    public Tooltip add(Component var1);

    public Tooltip add(TooltipComponent var1);

    default public Tooltip addAll(TooltipComponent ... components) {
        for (TooltipComponent component : components) {
            this.add(component);
        }
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public Tooltip addAll(ClientTooltipComponent ... components) {
        for (ClientTooltipComponent component : components) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAll(Component ... text) {
        for (Component component : text) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAllTooltipComponents(Iterable<TooltipComponent> text) {
        for (TooltipComponent component : text) {
            this.add(component);
        }
        return this;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    default public Tooltip addAllComponents(Iterable<ClientTooltipComponent> text) {
        for (ClientTooltipComponent component : text) {
            this.add(component);
        }
        return this;
    }

    default public Tooltip addAllTexts(Iterable<Component> text) {
        for (Component component : text) {
            this.add(component);
        }
        return this;
    }

    public EntryStack<?> getContextStack();

    public Tooltip withContextStack(EntryStack<?> var1);

    default public void queue() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> REIRuntime.getInstance().queueTooltip(this));
    }

    public Tooltip copy();

    @ApiStatus.NonExtendable
    public static interface Entry {
        public boolean isText();

        public boolean isTooltipComponent();

        public Component getAsText();

        public TooltipComponent getAsTooltipComponent();

        @Deprecated
        @ApiStatus.ScheduledForRemoval
        public ClientTooltipComponent getAsComponent();
    }
}

