/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client;

import java.util.List;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.view.ViewSearchBuilder;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.FormattingUtils;
import me.shedaniel.rei.impl.ClientInternals;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface ClientHelper {
    public static ClientHelper getInstance() {
        return ClientInternals.getClientHelper();
    }

    public boolean isCheating();

    public void setCheating(boolean var1);

    public boolean tryCheatingEntry(EntryStack<?> var1);

    default public String getModFromItem(Item item) {
        if (item.equals(Items.f_41852_)) {
            return "";
        }
        return this.getModFromIdentifier(Registry.f_122827_.m_7981_((Object)item));
    }

    public void sendDeletePacket();

    default public Component getFormattedModFromItem(Item item) {
        String mod = this.getModFromItem(item);
        if (mod.isEmpty()) {
            return NarratorChatListener.f_93310_;
        }
        return new TextComponent(mod).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
    }

    default public Component getFormattedModFromIdentifier(ResourceLocation identifier) {
        String mod = this.getModFromIdentifier(identifier);
        if (mod.isEmpty()) {
            return NarratorChatListener.f_93310_;
        }
        return new TextComponent(mod).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
    }

    default public Component getFormattedModFromModId(String modid) {
        String mod = this.getModFromModId(modid);
        if (mod.isEmpty()) {
            return NarratorChatListener.f_93310_;
        }
        return new TextComponent(mod).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC});
    }

    default public List<Component> appendModIdToTooltips(List<Component> components, String modId) {
        String modName = ClientHelper.getInstance().getModFromModId(modId);
        boolean alreadyHasMod = false;
        for (Component s : components) {
            if (!FormattingUtils.stripFormatting(s.getString()).equalsIgnoreCase(modName)) continue;
            alreadyHasMod = true;
            break;
        }
        if (!alreadyHasMod) {
            components.add(ClientHelper.getInstance().getFormattedModFromModId(modId));
        }
        return components;
    }

    public void appendModIdToTooltips(Tooltip var1, String var2);

    default public String getModFromIdentifier(ResourceLocation identifier) {
        if (identifier == null) {
            return "";
        }
        return this.getModFromModId(identifier.m_135827_());
    }

    public String getModFromModId(String var1);

    public boolean openView(ViewSearchBuilder var1);

    public boolean canUseMovePackets();
}

