/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java8ParameterNamesLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    @NotNull
    public abstract Member getMember();

    @Override
    @NotNull
    public AnnotatedElement getElement() {
        return (AnnotatedElement)((Object)this.getMember());
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    @NotNull
    public Name getName() {
        Name name;
        Name name2;
        String string = this.getMember().getName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            name2 = Name.identifier(it);
        } else {
            name2 = name = null;
        }
        if (name2 == null) {
            name = SpecialNames.NO_NAME_PROVIDED;
        }
        return name;
    }

    @Override
    @NotNull
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, "member.declaringClass");
        return new ReflectJavaClass(clazz);
    }

    @NotNull
    protected final List<JavaValueParameter> getValueParameters(@NotNull Type[] parameterTypes, @NotNull Annotation[][] parameterAnnotations, boolean isVararg) {
        List<String> names;
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Intrinsics.checkNotNullParameter(parameterAnnotations, "parameterAnnotations");
        ArrayList<ReflectJavaValueParameter> result2 = new ArrayList<ReflectJavaValueParameter>(parameterTypes.length);
        List<String> list = names = Java8ParameterNamesLoader.INSTANCE.loadParameterNames(this.getMember());
        int shift = list != null ? list.size() - parameterTypes.length : 0;
        int n = parameterTypes.length;
        for (int i2 = 0; i2 < n; ++i2) {
            String string;
            ReflectJavaType type2 = ReflectJavaType.Factory.create(parameterTypes[i2]);
            if (names != null) {
                List<String> $this$getValueParameters_u24lambda_u2d1;
                boolean bl = false;
                string = CollectionsKt.getOrNull($this$getValueParameters_u24lambda_u2d1, i2 + shift);
                if (string == null) {
                    throw new IllegalStateException(("No parameter with index " + i2 + '+' + shift + " (name=" + this.getName() + " type=" + type2 + ") in " + this).toString());
                }
            } else {
                string = null;
            }
            String name = string;
            boolean isParamVararg = isVararg && i2 == ArraysKt.getLastIndex(parameterTypes);
            result2.add(new ReflectJavaValueParameter(type2, parameterAnnotations[i2], name, isParamVararg));
        }
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ReflectJavaMember && Intrinsics.areEqual(this.getMember(), ((ReflectJavaMember)other).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @NotNull
    public List<ReflectJavaAnnotation> getAnnotations() {
        return ReflectJavaAnnotationOwner.DefaultImpls.getAnnotations(this);
    }

    @Override
    @Nullable
    public ReflectJavaAnnotation findAnnotation(@NotNull FqName fqName2) {
        return ReflectJavaAnnotationOwner.DefaultImpls.findAnnotation(this, fqName2);
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return ReflectJavaAnnotationOwner.DefaultImpls.isDeprecatedInJavaDoc(this);
    }

    @Override
    public boolean isAbstract() {
        return ReflectJavaModifierListOwner.DefaultImpls.isAbstract(this);
    }

    @Override
    public boolean isStatic() {
        return ReflectJavaModifierListOwner.DefaultImpls.isStatic(this);
    }

    @Override
    public boolean isFinal() {
        return ReflectJavaModifierListOwner.DefaultImpls.isFinal(this);
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return ReflectJavaModifierListOwner.DefaultImpls.getVisibility(this);
    }
}

