/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.client.particle.forge;

import dev.architectury.registry.client.particle.ParticleProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="architectury", value={Dist.CLIENT})
public class ParticleProviderRegistryImpl {
    private static ArrayList<Runnable> deferred = new ArrayList();

    private static <T extends ParticleOptions> void _register(ParticleType<T> type, ParticleProvider<T> provider) {
        Minecraft.m_91087_().f_91061_.m_107381_(type, provider);
    }

    private static <T extends ParticleOptions> void _register(ParticleType<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        Minecraft.m_91087_().f_91061_.m_107378_(type, sprites -> provider.create(new ExtendedSpriteSetImpl(Minecraft.m_91087_().f_91061_, sprites)));
    }

    public static <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProvider<T> provider) {
        if (deferred == null) {
            ParticleProviderRegistryImpl._register(type, provider);
        } else {
            deferred.add(() -> ParticleProviderRegistryImpl._register(type, provider));
        }
    }

    public static <T extends ParticleOptions> void register(ParticleType<T> type, ParticleProviderRegistry.DeferredParticleProvider<T> provider) {
        if (deferred == null) {
            ParticleProviderRegistryImpl._register(type, provider);
        } else {
            deferred.add(() -> ParticleProviderRegistryImpl._register(type, provider));
        }
    }

    @SubscribeEvent
    public static void onParticleFactoryRegister(ParticleFactoryRegisterEvent unused) {
        if (deferred != null) {
            for (Runnable runnable : deferred) {
                runnable.run();
            }
            deferred = null;
        }
    }

    private static final class ExtendedSpriteSetImpl
    implements ParticleProviderRegistry.ExtendedSpriteSet {
        private final ParticleEngine engine;
        private final SpriteSet delegate;

        private ExtendedSpriteSetImpl(ParticleEngine engine, SpriteSet delegate) {
            this.engine = engine;
            this.delegate = delegate;
        }

        @Override
        public TextureAtlas getAtlas() {
            return this.engine.f_107296_;
        }

        @Override
        public List<TextureAtlasSprite> getSprites() {
            return ((ParticleEngine.MutableSpriteSet)this.delegate).f_107406_;
        }

        public TextureAtlasSprite m_5819_(int i, int j) {
            return this.delegate.m_5819_(i, j);
        }

        public TextureAtlasSprite m_7102_(Random random) {
            return this.delegate.m_7102_(random);
        }
    }
}

