/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.core.fluid;

import com.google.common.base.MoreObjects;
import dev.architectury.core.fluid.ArchitecturyFluidAttributes;
import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

class ArchitecturyFluidAttributesForge
extends FluidAttributes {
    private final ArchitecturyFluidAttributes attributes;
    private final String defaultTranslationKey;

    public ArchitecturyFluidAttributesForge(FluidAttributes.Builder builder, Fluid fluid, ArchitecturyFluidAttributes attributes) {
        super(ArchitecturyFluidAttributesForge.addArchIntoBuilder(builder, attributes), fluid);
        this.attributes = attributes;
        this.defaultTranslationKey = Util.m_137492_((String)"fluid", (ResourceLocation)fluid.getRegistryName());
    }

    private static FluidAttributes.Builder addArchIntoBuilder(FluidAttributes.Builder builder, ArchitecturyFluidAttributes attributes) {
        builder.luminosity(attributes.getLuminosity()).density(attributes.getDensity()).temperature(attributes.getTemperature()).viscosity(attributes.getViscosity());
        if (attributes.isLighterThanAir()) {
            builder.gaseous();
        }
        return builder;
    }

    public ResourceLocation getStillTexture() {
        return this.attributes.getSourceTexture();
    }

    public ResourceLocation getStillTexture(FluidStack stack) {
        return this.attributes.getSourceTexture(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public ResourceLocation getStillTexture(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getSourceTexture(null, level, pos);
    }

    public ResourceLocation getFlowingTexture() {
        return this.attributes.getFlowingTexture();
    }

    public ResourceLocation getFlowingTexture(FluidStack stack) {
        return this.attributes.getFlowingTexture(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public ResourceLocation getFlowingTexture(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getFlowingTexture(null, level, pos);
    }

    public int getColor() {
        return this.attributes.getColor();
    }

    public int getColor(FluidStack stack) {
        return this.attributes.getColor(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public int getColor(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getColor(null, level, pos);
    }

    public int getLuminosity(FluidStack stack) {
        return this.attributes.getLuminosity(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public int getLuminosity(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getLuminosity(null, level, pos);
    }

    public int getDensity(FluidStack stack) {
        return this.attributes.getDensity(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public int getDensity(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getDensity(null, level, pos);
    }

    public int getTemperature(FluidStack stack) {
        return this.attributes.getTemperature(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public int getTemperature(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getTemperature(null, level, pos);
    }

    public int getViscosity(FluidStack stack) {
        return this.attributes.getViscosity(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public int getViscosity(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getViscosity(null, level, pos);
    }

    public boolean isGaseous(FluidStack stack) {
        return this.attributes.isLighterThanAir(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public boolean isGaseous(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.isLighterThanAir(null, level, pos);
    }

    public Rarity getRarity() {
        return this.attributes.getRarity();
    }

    public Rarity getRarity(FluidStack stack) {
        return this.attributes.getRarity(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public Rarity getRarity(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getRarity(null, level, pos);
    }

    public Component getDisplayName(FluidStack stack) {
        return this.attributes.getName(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public String getTranslationKey() {
        return (String)MoreObjects.firstNonNull((Object)this.attributes.getTranslationKey(), (Object)this.defaultTranslationKey);
    }

    public String getTranslationKey(FluidStack stack) {
        return (String)MoreObjects.firstNonNull((Object)this.attributes.getTranslationKey(stack == null ? null : FluidStackHooksForge.fromForge(stack)), (Object)this.defaultTranslationKey);
    }

    public SoundEvent getFillSound() {
        return this.attributes.getFillSound();
    }

    public SoundEvent getFillSound(FluidStack stack) {
        return this.attributes.getFillSound(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public SoundEvent getFillSound(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getFillSound(null, level, pos);
    }

    public SoundEvent getEmptySound() {
        return this.attributes.getEmptySound();
    }

    public SoundEvent getEmptySound(FluidStack stack) {
        return this.attributes.getEmptySound(stack == null ? null : FluidStackHooksForge.fromForge(stack));
    }

    public SoundEvent getEmptySound(BlockAndTintGetter level, BlockPos pos) {
        return this.attributes.getEmptySound(null, level, pos);
    }
}

